/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.rest.dto.MdObjectsList;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.MdRestoreCollection;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.DumpFileWriteException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractShellClient {
    public abstract MdObjectsList getObjectsList(ShellContext var1) throws IOException;

    public abstract void dumpObjectsLocal(ShellContext var1) throws IOException;

    public void createMetadataDumpFile(ShellContext context) throws Exception {
        ProjectClient projectClient = new ProjectClient(context.getCanRestClient());
        String projectTitle = projectClient.getProject(context.getCurrentProject()).getTitle();
        String dumpTime = DumpUtils.DUMP_ID_FORMAT.format(new Date());
        DumpMetadataDTO dumpMetadataDTO = new DumpMetadataDTO();
        dumpMetadataDTO.setServer(context.getConnectedServer());
        dumpMetadataDTO.setProjectId(context.getCurrentProject());
        dumpMetadataDTO.setProjectTitle(projectTitle);
        dumpMetadataDTO.setDumpTime(dumpTime);
        dumpMetadataDTO.setUser(context.getUserEmail());
        File metadataDumpFile = context.getDumpMetadataFile();
        DumpUtils.saveObjectToJson((Object)dumpMetadataDTO, (String)metadataDumpFile.getAbsolutePath());
        if (!metadataDumpFile.exists()) {
            throw new DumpFileWriteException("Failed to to create dumpMetadata.json file=" + metadataDumpFile.getAbsolutePath());
        }
    }

    public void updateDumpTimeInMetadataDumpFile(ShellContext context) throws IOException {
        File metadataDumpFile = context.getDumpMetadataFile();
        DumpMetadataDTO dumpMetadataDTO = DumpUtils.loadFileAsDumpMetadataFile((File)metadataDumpFile);
        String dumpTime = DumpUtils.DUMP_ID_FORMAT.format(new Date());
        dumpMetadataDTO.setDumpTime(dumpTime);
        DumpUtils.saveObjectToJson((Object)dumpMetadataDTO, (String)metadataDumpFile.getAbsolutePath());
        if (!metadataDumpFile.exists()) {
            throw new DumpFileWriteException("Failed to to create dumpMetadata.json file=" + metadataDumpFile.getAbsolutePath());
        }
    }

    public void putMetadataChecksumListElement(ShellContext context, File mdObjectFile) throws IOException {
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (dumpMetadataFile != null) {
            DumpMetadataDTO dumpMetadataDTO = DumpUtils.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
            LinkedHashMap<String, String> content = dumpMetadataDTO.getMetadataContent() == null ? new LinkedHashMap<String, String>() : dumpMetadataDTO.getMetadataContent();
            content.put(mdObjectFile.getName(), DumpUtils.calculateMD5((File)mdObjectFile));
            dumpMetadataDTO.setMetadataContent(content);
            DumpUtils.saveObjectToJson((Object)dumpMetadataDTO, (String)dumpMetadataFile.getAbsolutePath());
        }
    }

    public void removeMetadataChecksumListElement(ShellContext context, File mdObjectFile) throws IOException {
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (dumpMetadataFile != null) {
            String nameWithExtension = DumpUtils.appendExtension((String)mdObjectFile.getName(), (String)".json");
            DumpMetadataDTO dumpMetadataDTO = DumpUtils.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
            Map content = dumpMetadataDTO.getMetadataContent();
            if (dumpMetadataDTO.getMetadataContent() != null) {
                content.remove(nameWithExtension);
                dumpMetadataDTO.setMetadataContent(content);
                DumpUtils.saveObjectToJson((Object)dumpMetadataDTO, (String)dumpMetadataFile.getAbsolutePath());
            }
        }
    }

    public void putDataChecksumListElement(ShellContext context, File csvFile) throws IOException {
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (dumpMetadataFile != null) {
            DumpMetadataDTO dumpMetadataDTO = DumpUtils.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
            LinkedHashMap<String, String> content = dumpMetadataDTO.getDataContent() == null ? new LinkedHashMap<String, String>() : dumpMetadataDTO.getDataContent();
            content.put(csvFile.getName(), DumpUtils.calculateMD5((File)csvFile));
            dumpMetadataDTO.setDataContent(content);
            DumpUtils.saveObjectToJson((Object)dumpMetadataDTO, (String)dumpMetadataFile.getAbsolutePath());
        }
    }

    public File createMetadataSubfolder(File metadataDumpDirectory, MdObjectTypeEnum objectType) {
        File directory = Paths.get(metadataDumpDirectory.getAbsolutePath(), objectType.toStringPlural()).toFile();
        if (directory.mkdirs() || directory.isDirectory()) {
            return directory;
        }
        return null;
    }

    public abstract void addObject(String var1, File var2, boolean var3) throws IOException;

    public abstract void pushObject(String var1, File var2) throws IOException;

    public abstract void removeObjectByName(ShellContext var1, String var2, String var3) throws IOException;

    public abstract void removeObjectById(String var1, String var2, String var3) throws IOException;

    public abstract List<DatasetDTO> loadDatasetsFromPath(File var1, List<String> var2) throws IOException;

    public abstract void saveDatasetsToPath(List<DatasetDTO> var1, File var2) throws IOException;

    public abstract File getCurrentDatasetsPath(ShellContext var1);

    public void mdObjectNameCheck(String name) {
        Pattern namePattern = Pattern.compile("^[a-z][a-z0-9_-]*$");
        Matcher matcher = namePattern.matcher(name);
        if (!matcher.matches()) {
            throw new CleverMapsShellException("Object name=" + name + " does not match the regular expression=" + namePattern.pattern());
        }
    }

    public abstract void fetchSingleObject(ShellContext var1, String var2, boolean var3) throws IOException;

    public abstract void fetchAllObjects(ShellContext var1, boolean var2) throws IOException;

    public abstract MdRestoreCollection restoreSingleObject(ShellContext var1, String var2) throws IOException;

    public abstract MdRestoreCollection restoreAllObjects(ShellContext var1) throws IOException;
}

