/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.ReferenceReplaceUtils;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class RenameMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(RenameMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private final ShellContext context;

    @Autowired
    public RenameMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"renameMetadata"})
    public boolean isCommandAvailable() {
        return this.context.isOpenDump();
    }

    @CliCommand(value={"renameMetadata"}, help="Rename a metadata object in a local dump and on the server. If the object is referenced in some other objects by URI (/rest/projects/$projectId/md/{objectType}?name=), the references will be renamed as well.")
    public void renameMetadataCmd(@CliOption(key={"objectName"}, mandatory=true, help="Current name of the object (with or without .json extension)") String objectName, @CliOption(key={"newName"}, mandatory=true, help="New name of the object (with or without .json extension)") String newName) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            this.renameObject(objectName, newName);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void renameObject(String oldNameInput, String newNameInput) throws IOException {
        logger.error("Renaming object {} to {}...\n", (Object)oldNameInput, (Object)newNameInput);
        String newNameWithExt = DumpUtils.appendExtension((String)newNameInput, (String)".json");
        String oldNameWithExt = DumpUtils.appendExtension((String)oldNameInput, (String)".json");
        String newNameWithoutExt = FilenameUtils.removeExtension((String)newNameWithExt);
        String oldNameWithoutExt = FilenameUtils.removeExtension((String)oldNameWithExt);
        File alreadyNamedFile = DumpUtils.findMetadataInDump((ShellContext)this.context, (String)newNameWithoutExt);
        if (alreadyNamedFile != null) {
            throw new FileAlreadyExistsException("File=" + newNameWithExt + " already exists in dump.");
        }
        File localFile = DumpUtils.findMetadataInDump((ShellContext)this.context, (String)oldNameWithoutExt);
        if (localFile == null) {
            throw new FileNotFoundException("File=" + oldNameWithExt + " not found in dump.");
        }
        if (this.context.getShellClient() instanceof MdShellClient) {
            MdShellClient mdShellClient = (MdShellClient)this.context.getShellClient();
            mdShellClient.mdObjectNameCheck(newNameWithoutExt);
            MdObjectDumpDTO renamedObject = mdShellClient.renameObject(this.context, localFile, oldNameWithExt, newNameWithExt);
            List renamedReferences = ReferenceReplaceUtils.replaceNameReferencesInReferencingDumpedMdObjects((File)this.context.getMetadataDumpPath().toFile(), (MdObjectTypeEnum)renamedObject.getContent().getType(), (String)oldNameWithoutExt, (String)newNameWithoutExt);
            mdShellClient.renameObjectReferences(this.context, renamedObject, renamedReferences);
        } else {
            logger.error("Renaming object is not supported for this project type.");
        }
    }
}

