/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client.jdbc;

import com.cleveranalytics.service.md.rest.dto.ColumnDTO;
import com.cleveranalytics.service.md.rest.dto.GenerateDatasetRequestDTO;
import com.cleveranalytics.shell.client.jdbc.StreamingCsvResultSetExtractor;
import com.cleveranalytics.shell.commands.project.ImportDatabaseCommand;
import com.cleveranalytics.shell.exception.JdbcShellClientException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Schema;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class JdbcShellClient {
    private static final Logger logger = LoggerFactory.getLogger(ImportDatabaseCommand.class);
    private JdbcTemplate jdbcTemplate;
    private DSLContext dsl;
    private Schema schema;

    public JdbcShellClient(String url, String user, String password) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(url);
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        this.dsl = DSL.using((String)url, (String)user, (String)password);
        this.schema = this.getSchema(null);
        logger.error("Connection to database " + url + " successfully opened\n");
    }

    public JdbcShellClient(String url, String schema, String user, String password) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(url);
        dataSource.setSchema(schema);
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        this.dsl = DSL.using((String)url, (String)user, (String)password);
        this.schema = this.getSchema(schema);
        logger.error("Connection to database " + url + " successfully opened\n");
    }

    private Schema getSchema(String schemaName) {
        if (schemaName == null) {
            List publicSchemas = this.dsl.meta().getSchemas("public");
            if (publicSchemas.size() == 1) {
                return (Schema)publicSchemas.get(0);
            }
            if (publicSchemas.size() == 0) {
                throw new JdbcShellClientException("Database contains no public schema.");
            }
            throw new JdbcShellClientException("Database contains more than one public schema.");
        }
        for (Schema schema : this.dsl.meta().getSchemas()) {
            if (!schema.getName().equals(schemaName)) continue;
            return schema;
        }
        throw new JdbcShellClientException("Schema name=" + schemaName + " not found.");
    }

    public List<Table<?>> getAllTables() {
        return this.dsl.meta(new Schema[]{this.schema}).getTables();
    }

    public List<Table<?>> getTables(List<String> tableNames) {
        ArrayList tables = new ArrayList();
        for (String tableName : tableNames) {
            List tablesByName = this.dsl.meta(new Schema[]{this.schema}).getTables(tableName);
            if (tablesByName.size() == 1) {
                tables.add((Table)tablesByName.get(0));
                continue;
            }
            if (tablesByName.size() == 0) {
                throw new JdbcShellClientException("Table name=" + tableName + " not found.");
            }
            throw new JdbcShellClientException("There are multiple tables with name=" + tableName + ".");
        }
        return tables;
    }

    public List<GenerateDatasetRequestDTO> generateDatasetRequests(List<Table<?>> tables) {
        ArrayList<GenerateDatasetRequestDTO> requests = new ArrayList<GenerateDatasetRequestDTO>();
        for (Table<?> table : tables) {
            String query = this.prepareSelectQuery(table.getName(), true);
            Map foreignKeys = this.getForeignKeys(table);
            ArrayList columns = new ArrayList();
            this.jdbcTemplate.query(query, resultSet -> {
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    ColumnDTO column = this.createColumn(i, foreignKeys, resultSet.getMetaData());
                    columns.add(column);
                }
                return columns;
            });
            GenerateDatasetRequestDTO request = new GenerateDatasetRequestDTO();
            request.setTableName(table.getName());
            request.setColumns(columns);
            request.setPrimaryKey(this.getPrimaryKey(table));
            requests.add(request);
        }
        return requests;
    }

    private String prepareSelectQuery(String tableName, boolean limit) {
        SelectQuery select = this.dsl.selectQuery();
        select.addSelect(new SelectFieldOrAsterisk[]{DSL.field((String)"*")});
        select.addFrom((TableLike)DSL.table((Name)DSL.name((String[])new String[]{this.schema.getName(), tableName})));
        if (limit) {
            select.addLimit(DSL.inline((int)1));
        }
        return select.getSQL();
    }

    private String getPrimaryKey(Table table) {
        if (table.getPrimaryKey() == null) {
            return null;
        }
        List tableFields = table.getPrimaryKey().getFields();
        if (tableFields.size() == 0) {
            return null;
        }
        if (tableFields.size() == 1) {
            return ((TableField)tableFields.get(0)).getName();
        }
        throw new JdbcShellClientException("Table name=" + table.getName() + " contains multiple primary keys.");
    }

    private Map<String, String> getForeignKeys(Table table) {
        List foreignKeys = table.getReferences();
        HashMap<String, String> foreignKeysMap = new HashMap<String, String>();
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey.getFields().size() > 1) {
                throw new JdbcShellClientException("Foreign key name=" + foreignKey.getName() + " refers to more than one table. Each foreign key can refer to a maximum of one table.");
            }
            TableField tableField = (TableField)foreignKey.getFields().get(0);
            String referencingColumnName = tableField.getName();
            String referencedTableName = foreignKey.getKey().getTable().getName();
            if (foreignKeysMap.containsKey(referencingColumnName)) {
                throw new JdbcShellClientException("Multiple foreign keys on column name=" + referencingColumnName + ". Each column can contain a maximum of one foreign key.");
            }
            foreignKeysMap.put(referencingColumnName, referencedTableName);
        }
        return foreignKeysMap;
    }

    private ColumnDTO createColumn(int index, Map<String, String> foreignKeys, ResultSetMetaData metadata) throws SQLException {
        return new ColumnDTO().withIndex(Integer.valueOf(index)).withName(metadata.getColumnName(index)).withTypeClass(metadata.getColumnClassName(index)).withForeignKey(foreignKeys.get(metadata.getColumnName(index)));
    }

    public void dumpDataToCsv(String tableName, String path) throws IOException {
        String query = this.prepareSelectQuery(tableName, false);
        try (FileOutputStream outputStream = new FileOutputStream(new File(path));){
            this.jdbcTemplate.query(query, (ResultSetExtractor)new StreamingCsvResultSetExtractor((OutputStream)outputStream));
        }
    }

    public void closeConnection() {
        try {
            this.dsl.close();
        }
        catch (DataAccessException ex) {
            throw new JdbcShellClientException("An error occurred when closing the database connection.");
        }
    }
}

