/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.ImportProjectRequest;
import com.cleveranalytics.service.job.JobDetailResponse;
import com.cleveranalytics.service.job.client.JobClient;
import com.cleveranalytics.service.job.rest.dto.GeneralJobRequest;
import com.cleveranalytics.service.job.type.ImportProjectJobRequest;
import com.cleveranalytics.service.job.type.TruncateJobRequest;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobShellClient {
    private static final Logger logger = LoggerFactory.getLogger(JobShellClient.class);

    public void truncateProject(ShellContext context) throws InterruptedException {
        logger.error("Truncation of project started...\n");
        TruncateJobRequest truncateJobRequest = new TruncateJobRequest();
        truncateJobRequest.setType("truncate");
        truncateJobRequest.setProjectId(context.getCurrentProject());
        JobClient jobClient = new JobClient(context.getCanRestClient());
        JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)truncateJobRequest);
        if (!jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            throw new CleverMapsShellException("Project truncate operation failed with status=" + String.valueOf(jobResponse.getStatus()) + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId() + "\n");
        }
        logger.error("Project was successfully truncated.\n");
    }

    public void cloneProject(ShellContext context, String sourceProject) {
        ImportProjectRequest importProjectRequest = this.createImportProjectRequest(sourceProject, true);
        ImportProjectJobRequest importProjectJobRequest = this.createImportProjectJobRequest(importProjectRequest, context.getCurrentProject());
        logger.error("Starting cloning of project {}...", (Object)sourceProject);
        JobDetailResponse jobResponse = this.startImportProjectJob(context, importProjectJobRequest);
        if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            this.handleImportProjectResponse(sourceProject, "Cloning");
        } else {
            this.handleImportProjectFailedResponse(jobResponse, sourceProject, "Cloning");
        }
    }

    public void importProjectServerSide(ShellContext context, String sourceProject, Map<String, Boolean> typesToImport, String prefix, boolean force, boolean skipData, String cascadeFrom) {
        ImportProjectRequest importProjectRequest = this.createImportProjectRequestWithAllParams(sourceProject, typesToImport, prefix, force, skipData, cascadeFrom);
        ImportProjectJobRequest importProjectJobRequest = this.createImportProjectJobRequest(importProjectRequest, context.getCurrentProject());
        logger.error("Importing project {}...\n", (Object)sourceProject);
        JobDetailResponse jobResponse = this.startImportProjectJob(context, importProjectJobRequest);
        if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            this.handleImportProjectResponse(sourceProject, "Importing");
        } else {
            this.handleImportProjectFailedResponse(jobResponse, sourceProject, "Importing");
        }
    }

    private ImportProjectRequest createImportProjectRequestWithAllParams(String sourceProject, Map<String, Boolean> typesToImport, String prefix, boolean force, boolean skipData, String cascadeFrom) {
        ImportProjectRequest importProjectRequest = this.createImportProjectRequest(sourceProject, force);
        importProjectRequest.setCascadeFrom(cascadeFrom);
        importProjectRequest.setPrefix(prefix);
        importProjectRequest.setSkipData(Boolean.valueOf(skipData));
        this.addMetadataToImportProjectRequest(importProjectRequest, typesToImport);
        return importProjectRequest;
    }

    private void addMetadataToImportProjectRequest(ImportProjectRequest request, Map<String, Boolean> typesToImport) {
        request.setAttributeStyles(typesToImport.getOrDefault("attributeStyles", false));
        request.setDashboard(typesToImport.getOrDefault("dashboards", false));
        request.setDataPermissions(typesToImport.getOrDefault("dataPermissions", false));
        request.setDatasets(typesToImport.getOrDefault("datasets", false));
        request.setExports(typesToImport.getOrDefault("exports", false));
        request.setIndicators(typesToImport.getOrDefault("indicators", false));
        request.setIndicatorDrills(typesToImport.getOrDefault("indicatorDrills", false));
        request.setMaps(typesToImport.getOrDefault("maps", false));
        request.setMarkers(typesToImport.getOrDefault("markers", false));
        request.setMarkerSelectors(typesToImport.getOrDefault("markerSelectors", false));
        request.setMetrics(typesToImport.getOrDefault("metrics", false));
        request.setProjectSettings(typesToImport.getOrDefault("projectSettings", false));
        request.setViews(typesToImport.getOrDefault("views", false));
    }

    private ImportProjectRequest createImportProjectRequest(String sourceProject, boolean force) {
        return new ImportProjectRequest().withSourceProjectId(sourceProject).withForce(Boolean.valueOf(force));
    }

    private ImportProjectJobRequest createImportProjectJobRequest(ImportProjectRequest request, String targetProject) {
        return new ImportProjectJobRequest().withType("importProject").withProjectId(targetProject).withContent(request);
    }

    private JobDetailResponse startImportProjectJob(ShellContext context, ImportProjectJobRequest request) {
        JobClient jobClient = new JobClient(context.getCanRestClient());
        try {
            return jobClient.executeJob((GeneralJobRequest)request);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
    }

    private void handleImportProjectResponse(String sourceProject, String jobDesc) {
        logger.error(jobDesc + " of project {} was successful.", (Object)sourceProject);
    }

    private void handleImportProjectFailedResponse(JobDetailResponse jobResponse, String sourceProject, String jobDesc) {
        String[] parts = jobResponse.getMessage().split("\n", 2);
        String message = parts.length < 2 ? jobDesc + " of project " + sourceProject + " failed with status=" + String.valueOf(jobResponse.getStatus()) + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId() : jobDesc + " of project " + sourceProject + " failed with status=" + String.valueOf(jobResponse.getStatus()) + "\nmessage=" + parts[0] + "\njob_id=" + jobResponse.getId() + "\n\n------SERVER LOG------\n" + parts[1] + "------END OF SERVER LOG------\n";
        throw new CleverMapsShellException(message);
    }
}

