/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class FetchCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(FetchCommand.class);
    private final ShellContext context;

    @Autowired
    public FetchCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"fetch"})
    public boolean isCommandAvailable() {
        return this.context.isOpenDump();
    }

    @CliCommand(value={"fetch"}, help="Fetch objects that have changed on server and update objects in dump.")
    public void fetchCmd(@CliOption(key={"force"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Overwrite all local changes.") boolean force, @CliOption(key={"objectName"}, mandatory=false, help="Name of the object to fetch (with or without \".json\" extension).") String objectName) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            AbstractShellClient shellClient = this.context.getShellClient();
            if (objectName != null) {
                shellClient.fetchSingleObject(this.context, objectName, force);
            } else {
                shellClient.fetchAllObjects(this.context, force);
            }
            shellClient.updateDumpTimeInMetadataDumpFile(this.context);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }
}

