/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.CsvOptions;
import com.cleveranalytics.common.libs.aws.stepfunctions.machines.dto.DataPullRequest;
import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.BannerProvider;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LoadCsvCommand
implements CommandMarker {
    private static final Logger logger = LoggerFactory.getLogger(LoadCsvCommand.class);
    private final ShellContext context;

    public LoadCsvCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"loadCsv"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"loadCsv"}, help="Load CSV file into existing CleverMaps dataset.")
    public void loadCsvCmd(@CliOption(key={"dataset"}, mandatory=true, help="Name of dataset into which the data should be loaded.") String datasetName, @CliOption(key={"file"}, mandatory=false, help="Path to a CSV file to be loaded. If a dump is opened and contains some CSV files, file can be specified by using just the filename ('restaurants.csv') instead of full path.") String file, @CliOption(key={"s3Uri"}, mandatory=false, help="S3 object URI which contains a CSV file to be loaded into the dataset.") String s3Uri, @CliOption(key={"url"}, mandatory=false, help="HTTPS URL which contains a CSV file to be loaded into the dataset.") String url, @CliOption(key={"mode"}, mandatory=true, help="Data load mode. Allowed modes=[\"full\", \"incremental\"]. Incremental mode appends the data to the end of the table.Full mode truncates the table and loads the table anew.") String mode, @CliOption(key={"csvHeader"}, mandatory=false, help="Specifies if the CSV file has a header. Defaults to true.") Boolean csvHeader, @CliOption(key={"csvSeparator"}, mandatory=false, help="Specifies the CSV column separator character. Defaults to ','.") Character csvSeparator, @CliOption(key={"csvQuote"}, mandatory=false, help="Specifies the CSV quote character. Defaults to '\"'.") Character csvQuote, @CliOption(key={"csvEscape"}, mandatory=false, help="Specifies the CSV escape character. Defaults to '\\'") Character csvEscape, @CliOption(key={"csvNull"}, mandatory=false, help="Specifies the replacement of custom CSV null values.") String csvNull, @CliOption(key={"csvForceNull"}, mandatory=false, help="Specifies which CSV columns should enforce the null replacement.") String[] csvForceNull, @CliOption(key={"verbose"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Verbose option for more detailed output.") boolean verbose, @CliOption(key={"multipart"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Use multipart file upload.") boolean multipart, @CliOption(key={"gzip"}, mandatory=false, unspecifiedDefaultValue="true", help="Enable or disable gzip compression.") boolean gzip, @CliOption(key={"skipRefreshingMaterializedViews"}, mandatory=false, help="Skip refresh of dataset table for datasets with calculated property when loading linked dataset. Use when you are uploading multiple linked datasets in a row or you will be uploading data to dataset with calculated property soon.") Boolean skipRefreshingMaterializedViews) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (multipart && !gzip) {
                logger.error(String.valueOf(BannerProvider.ANSI_MAGENTA) + "The combination of --multipart and --gzip false is currently not supported" + String.valueOf(BannerProvider.ANSI_RESET));
                return;
            }
            int argsUsed = 0;
            argsUsed = StringUtils.hasText((String)file) ? argsUsed + 1 : argsUsed;
            argsUsed = StringUtils.hasText((String)s3Uri) ? argsUsed + 1 : argsUsed;
            int n = argsUsed = StringUtils.hasText((String)url) ? argsUsed + 1 : argsUsed;
            if (argsUsed == 0) {
                logger.error(String.valueOf(BannerProvider.ANSI_MAGENTA) + "One of --file, --s3Uri, --url CSV file locations must be specified" + String.valueOf(BannerProvider.ANSI_RESET));
            } else if (argsUsed > 1) {
                logger.error(String.valueOf(BannerProvider.ANSI_MAGENTA) + "You can specify only one of --file, --s3Uri and --url CSV file locations" + String.valueOf(BannerProvider.ANSI_RESET));
            } else if (StringUtils.hasText((String)s3Uri) && multipart || StringUtils.hasText((String)url) && multipart) {
                logger.error(String.valueOf(BannerProvider.ANSI_MAGENTA) + "The combination of --s3Uri or --url upload and --multipart is not supported" + String.valueOf(BannerProvider.ANSI_RESET));
            } else {
                logger.error("Asynchronous data upload started...\n");
                DataPullRequest.Mode dataPullMode = this.convertDataPullRequestMode(mode);
                CsvOptions csvOptions = this.parseCsvOptions(csvHeader, csvSeparator, csvQuote, csvEscape, csvNull, csvForceNull);
                if (StringUtils.hasText((String)s3Uri)) {
                    this.loadDataS3(datasetName, s3Uri, dataPullMode, csvOptions, verbose, skipRefreshingMaterializedViews);
                } else if (StringUtils.hasText((String)url)) {
                    this.loadDataHttps(datasetName, new URI(url), dataPullMode, csvOptions, verbose, skipRefreshingMaterializedViews);
                } else {
                    this.loadData(file, datasetName, dataPullMode, csvOptions, verbose, multipart, gzip, skipRefreshingMaterializedViews);
                }
                logger.error("");
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private CsvOptions parseCsvOptions(Boolean csvHeader, Character csvSeparator, Character csvQuote, Character csvEscape, String csvNull, String[] csvForceNull) {
        CsvOptions csvOptions = new CsvOptions();
        csvOptions.setHeader(csvHeader);
        csvOptions.setSeparator(csvSeparator);
        csvOptions.setQuote(csvQuote);
        csvOptions.setEscape(csvEscape);
        csvOptions.setNull(csvNull);
        if (csvForceNull == null) {
            csvOptions.setForceNull(null);
        } else {
            csvOptions.setForceNull(Arrays.asList(csvForceNull));
        }
        return csvOptions;
    }

    public void loadData(String csvName, String datasetName, DataPullRequest.Mode mode, CsvOptions csvOptions, boolean verbose, boolean multipart, boolean gzip, Boolean skipRefreshingMaterializedViews) throws IOException {
        File csvFile = DumpUtils.findDataInDump((ShellContext)this.context, (String)csvName);
        if (csvFile == null || !csvFile.exists() || !csvFile.canRead()) {
            csvFile = DumpUtils.getCsvFileFromPath((String)csvName);
        }
        DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
        if (multipart) {
            if (csvFile.length() > 0x3200000L) {
                dwhShellClient.performMultipartLoad(this.context, csvFile, datasetName, mode, csvOptions, verbose, gzip, skipRefreshingMaterializedViews);
            } else {
                logger.error("File size of CSV file=" + csvName + " is less than 50 MB, using regular upload.\n");
                dwhShellClient.performLoad(this.context, csvFile, datasetName, mode, csvOptions, verbose, gzip, skipRefreshingMaterializedViews);
            }
        } else {
            dwhShellClient.performLoad(this.context, csvFile, datasetName, mode, csvOptions, verbose, gzip, skipRefreshingMaterializedViews);
        }
        if (this.context.isOpenDump()) {
            this.fetchUpdatedDataset(datasetName);
        }
    }

    public void loadDataS3(String datasetName, String s3Uri, DataPullRequest.Mode mode, CsvOptions csvOptions, boolean verbose, Boolean skipRefreshingMaterializedViews) throws IOException, URISyntaxException {
        DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
        dwhShellClient.performS3Load(this.context, s3Uri, datasetName, mode, csvOptions, verbose, skipRefreshingMaterializedViews);
        if (this.context.isOpenDump()) {
            this.fetchUpdatedDataset(datasetName);
        }
    }

    public void loadDataHttps(String datasetName, URI httpsUrl, DataPullRequest.Mode mode, CsvOptions csvOptions, boolean verbose, Boolean skipRefreshingMaterializedViews) throws IOException {
        DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
        dwhShellClient.performHttpsLoad(this.context, httpsUrl, datasetName, mode, csvOptions, verbose, skipRefreshingMaterializedViews);
        if (this.context.isOpenDump()) {
            this.fetchUpdatedDataset(datasetName);
        }
    }

    private void fetchUpdatedDataset(String datasetName) {
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        MdDatasetClient datasetClient = this.context.getDatasetClient();
        try {
            DatasetDTO updatedDataset = datasetClient.getDatasetByName(this.context.getCurrentProject(), datasetName);
            shellClient.wrapAndSaveMdObject(this.context, (MdObjectDTO)updatedDataset);
        }
        catch (Exception ex) {
            logger.error("Failed to fetch a new version of dataset name={}.", (Object)datasetName);
        }
    }

    protected DataPullRequest.Mode convertDataPullRequestMode(String mode) throws IllegalArgumentException {
        try {
            return DataPullRequest.Mode.fromValue((String)mode);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid 'mode' parameter=" + mode + ". Supported values are=" + Arrays.toString(DataPullRequest.Mode.values()) + ".");
        }
    }
}

