/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.shell.client.ReferenceReplacer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectIdPlaceholderLinkReplacer
implements ReferenceReplacer {
    static final Logger logger = LoggerFactory.getLogger(ProjectIdPlaceholderLinkReplacer.class);
    private final String placeholder = "\\$projectId";
    private final Pattern placeholderPattern = Pattern.compile("\\$projectId");
    private final String newProjectId;
    private final String objectName;

    public ProjectIdPlaceholderLinkReplacer(String projectId, String objectName) {
        this.newProjectId = projectId;
        this.objectName = objectName;
    }

    public String replace(String input) {
        Matcher matcher;
        String replaced = null;
        if (input != null && input.equals(replaced = (matcher = this.placeholderPattern.matcher(input)).replaceFirst(this.newProjectId))) {
            logger.error("\nWarning: Failed to replace placeholder in URL=" + input + " of object=" + this.objectName);
            logger.error("Check if the placeholder in the url matches correct placeholder syntax=$projectId");
        }
        return replaced;
    }
}

