/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class CopyMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(CopyMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private final ShellContext context;

    @Autowired
    public CopyMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"copyMetadata"})
    public boolean isCommandAvailable() {
        return this.context.isOpenDump();
    }

    @CliCommand(value={"copyMetadata"}, help="Create a copy of an object existing in a currently opened dump.This command unwraps the object from a wrapper, renames it and removes generated common syntax keys. If the objectName and newName arguments are the same, the object is unwrapped only.")
    public void copyMetadataCmd(@CliOption(key={"objectName"}, mandatory=true, help="Current name of the object (with or without .json extension)") String objectName, @CliOption(key={"newName"}, mandatory=true, help="Name of the object copy (with or without .json extension)") String newName) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            String oldObjectName = DumpUtils.appendExtension((String)objectName, (String)".json");
            String newObjectName = DumpUtils.appendExtension((String)newName, (String)".json");
            File fileToCopy = DumpUtils.findMetadataInDump((ShellContext)this.context, (String)objectName);
            if (fileToCopy == null) {
                logger.error("Metadata object {} not found in dump\n", (Object)objectName);
                logger.error("Can't create a copy of this object\n");
            } else {
                this.createObjectCopy(fileToCopy, oldObjectName, newObjectName);
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void createObjectCopy(File file, String oldNameWithExt, String newNameWithExt) throws IOException {
        MdShellClient mdShellClient = (MdShellClient)this.context.getShellClient();
        String newNameWithoutExt = FilenameUtils.removeExtension((String)newNameWithExt);
        mdShellClient.mdObjectNameCheck(newNameWithoutExt);
        File alreadyNamedFile = DumpUtils.findMetadataInDump((ShellContext)this.context, (String)newNameWithoutExt);
        if (alreadyNamedFile != null) {
            throw new FileAlreadyExistsException("File=" + newNameWithExt + " already exists in dump.");
        }
        if (DumpUtils.isValidMdObjectDump((File)file)) {
            DatasetDTO copy;
            MdObjectDumpDTO mdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)file);
            MdObjectDTO original = mdObjectDump.getContent();
            if (original.getType().equals((Object)MdObjectTypeEnum.DATASET)) {
                copy = new DatasetDTO();
                copy.setOrigin(original.getOrigin());
                copy.setProperties(((DatasetDTO)original).getProperties());
                copy.setRef(((DatasetDTO)original).getRef());
            } else {
                copy = new MdObjectDTO();
                copy.setContent(original.getContent());
            }
            copy.setName(FilenameUtils.removeExtension((String)newNameWithExt));
            copy.setType(original.getType());
            copy.setTitle(original.getTitle());
            copy.setDescription(original.getDescription());
            String parentDir = FilenameUtils.getFullPath((String)file.getAbsolutePath());
            String newPath = Paths.get(parentDir, newNameWithExt).toString();
            DumpUtils.saveObjectToJson((Object)copy, (String)newPath);
            File newFile = new File(DumpUtils.appendExtension((String)newPath, (String)".json"));
            if (newFile.exists()) {
                logger.error("Object {} successfully created as a copy of object {}\n", (Object)newNameWithExt, (Object)oldNameWithExt);
            } else {
                logger.error("Failed to create a copy of object {}\n", (Object)oldNameWithExt);
            }
        } else {
            logger.error("Object {} is not a valid object dump, cannot create copy of it\n", (Object)oldNameWithExt);
        }
    }
}

