/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.shell.client.ReferenceReplacer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectIdLinkReplacer
implements ReferenceReplacer {
    static final Logger logger = LoggerFactory.getLogger(ProjectIdLinkReplacer.class);
    private static final String PROJECT_ID_PLACEHOLDER = "\\$projectId";
    private final Pattern idPattern = Pattern.compile("[a-z0-9]{16}");
    private final String objectName;

    public ProjectIdLinkReplacer(String objectName) {
        this.objectName = objectName;
    }

    public String replace(String input) {
        Matcher matcher;
        String replaced = null;
        if (input != null && input.equals(replaced = (matcher = this.idPattern.matcher(input)).replaceFirst(PROJECT_ID_PLACEHOLDER))) {
            logger.error("\nWarning: Failed to replace project ID in URL=" + input + " of object=" + this.objectName);
            logger.error("Check if the project ID in the URL matches currently opened project.");
        }
        return replaced;
    }
}

