/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.rest.dto.MdObjectsDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectsList;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDwhTypeDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.Datasets;
import com.cleveranalytics.service.md.rest.dto.dataset.DwhAbstractProperty;
import com.cleveranalytics.service.md.rest.dto.dataset.DwhForeignKeyDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DwhGeometryDTO;
import com.cleveranalytics.service.md.util.UriUtils;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.Role;
import com.cleveranalytics.shell.DumpUtils;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.JobShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.PrefixNameLinkReplacer;
import com.cleveranalytics.shell.client.PrefixPropertyIdentifierReplacer;
import com.cleveranalytics.shell.client.ReferenceReplaceUtils;
import com.cleveranalytics.shell.client.ReferenceReplacer;
import com.cleveranalytics.shell.commands.connected.OpenProjectCommand;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.commands.project.OpenDumpCommand;
import com.cleveranalytics.shell.config.BannerProvider;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.DumpFileWriteException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ImportProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(ImportProjectCommand.class);
    private final ShellContext context;
    private final DumpProjectCommand dumpProjectCommand;
    private final OpenProjectCommand openProjectCommand;
    private final OpenDumpCommand openDumpCommand;
    private String tempDirectory;
    private String workDirectory;

    @Autowired
    public ImportProjectCommand(ShellContext context) {
        this.context = context;
        this.dumpProjectCommand = new DumpProjectCommand(context);
        this.openProjectCommand = new OpenProjectCommand(context);
        this.openDumpCommand = new OpenDumpCommand(context);
    }

    @CliAvailabilityIndicator(value={"importProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"importProject"}, help="Import specific parts of a project to another project.")
    public void importProjectCmd(@CliOption(key={"project"}, help="Project ID of the project from which files will be imported.") String project, @CliOption(key={"dump"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Imports project from local dump.") boolean dump, @CliOption(key={"serverSide"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Performs import of specified project on server.") boolean serverSide, @CliOption(key={"attributeStyles"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import attribute styles of the specified project.") boolean attributeStyles, @CliOption(key={"dashboards"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import dashboards of the specified project.") boolean dashboards, @CliOption(key={"dataPermissions"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import dataPermissions of the specified project.") boolean dataPermissions, @CliOption(key={"datasets"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import datasets of the specified project.") boolean datasets, @CliOption(key={"exports"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import exports of the specified project.") boolean exports, @CliOption(key={"indicators"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import indicators of the specified project.") boolean indicators, @CliOption(key={"indicatorDrills"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import indicator drills of the specified project.") boolean indicatorDrills, @CliOption(key={"maps"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import maps of the specified project.") boolean maps, @CliOption(key={"markers"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import markers of the specified project.") boolean markers, @CliOption(key={"markerSelectors"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import marker selectors of the specified project.") boolean markerSelectors, @CliOption(key={"metrics"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import metrics of the specified project.") boolean metrics, @CliOption(key={"projectSettings"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import specified project's settings.") boolean projectSettings, @CliOption(key={"views"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Import views of the specified project.") boolean views, @CliOption(key={"prefix"}, help="Prefix which will be added to the name of all imported objects.") String prefix, @CliOption(key={"force"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Force import when there are DWH model/data violations in source project, or the source project is not empty.") boolean force, @CliOption(key={"skipData"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip DWH data import.") boolean skipData, @CliOption(key={"cascadeFrom"}, help="Cascade import object and all objects it references.") String cascadeFrom) throws Exception {
        ShellContext backup = this.createContextCopy();
        this.tempDirectory = Paths.get(this.context.getDumpDirectory(), "temp").toString();
        this.workDirectory = this.context.getDumpDirectory();
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            LinkedHashMap<String, Boolean> importArguments = new LinkedHashMap<String, Boolean>();
            importArguments.put("attributeStyles", attributeStyles);
            importArguments.put("dashboards", dashboards);
            importArguments.put("dataPermissions", dataPermissions);
            importArguments.put("datasets", datasets);
            importArguments.put("exports", exports);
            importArguments.put("indicators", indicators);
            importArguments.put("indicatorDrills", indicatorDrills);
            importArguments.put("maps", maps);
            importArguments.put("markers", markers);
            importArguments.put("markerSelectors", markerSelectors);
            importArguments.put("metrics", metrics);
            importArguments.put("projectSettings", projectSettings);
            importArguments.put("views", views);
            if (!importArguments.containsValue(true)) {
                importArguments.put("attributeStyles", true);
                importArguments.put("dashboards", true);
                importArguments.put("dataPermissions", true);
                importArguments.put("datasets", true);
                importArguments.put("exports", true);
                importArguments.put("indicators", true);
                importArguments.put("indicatorDrills", true);
                importArguments.put("maps", true);
                importArguments.put("markers", true);
                importArguments.put("markerSelectors", true);
                importArguments.put("metrics", true);
                importArguments.put("projectSettings", true);
                importArguments.put("views", true);
            }
            if (!this.checkImportParameters(project, dump, serverSide)) {
                return;
            }
            if (((Boolean)importArguments.get("projectSettings")).booleanValue() && this.checkProjectSettingsPresentInProject() && !force) {
                logger.error("Project settings found in current project, not importing projectSettings. Use --force to override." + OsUtils.LINE_SEPARATOR);
                importArguments.put("projectSettings", false);
            }
            if (!importArguments.containsValue(true)) {
                logger.error("Skipping import project - nothing to import\n");
                return;
            }
            if (serverSide) {
                JobShellClient jobShellClient = new JobShellClient();
                jobShellClient.importProjectServerSide(this.context, project, importArguments, prefix, force, skipData, cascadeFrom);
                return;
            }
            if (dump) {
                this.importDump(project, importArguments, prefix, force, skipData);
            } else {
                this.importProject(project, importArguments, prefix, force, skipData, cascadeFrom);
            }
            this.context.getShellClient().updateDumpTimeInMetadataDumpFile(this.context);
        }
        catch (Exception ex) {
            this.restoreContext(backup);
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void importDump(String sourceProjectId, Map<String, Boolean> typesToImport, String prefix, boolean force, boolean skipData) throws Exception {
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        boolean shouldProceed = this.checkEmptyProject(this.context.getCurrentProject(), shellClient, force);
        if (!shouldProceed) {
            return;
        }
        logger.error("Importing local dump of project {}...\n", (Object)sourceProjectId);
        File sourceProjectDirectory = Paths.get(this.context.getDumpDirectory(), sourceProjectId).toFile();
        if (!sourceProjectDirectory.exists() || !sourceProjectDirectory.canRead()) {
            throw new FileNotFoundException("Source project directory=" + sourceProjectDirectory + " not found.");
        }
        if (!this.context.isOpenDump() && !this.context.hasDumpMetadataFile()) {
            this.dumpProjectCommand.dumpProject(true, false, false, false, force);
        } else {
            this.openDumpCommand.openDumpCmd();
        }
        File sourceMetadataDumpDirectory = Paths.get(this.context.getDumpDirectory(), sourceProjectId, "metadata").toFile();
        List metadataFiles = DumpUtils.findAllMetadataInDump((File)sourceMetadataDumpDirectory);
        List wrappedMetadataFiles = DumpUtils.filterUnwrappedMetadataFiles((List)metadataFiles);
        int importedObjects = 0;
        for (File file : wrappedMetadataFiles) {
            MdObjectDumpDTO object = DumpUtils.loadFileAsMdObjectDump((File)file);
            MdObjectDTO unwrappedObject = DumpUtils.unwrapMdObject((MdObjectDumpDTO)object);
            if (!typesToImport.get(unwrappedObject.getType().toStringPlural()).booleanValue()) continue;
            Object objectName = unwrappedObject.getName();
            if (prefix != null) {
                objectName = prefix + (String)objectName;
                unwrappedObject.setName((String)objectName);
            }
            File unwrappedObjectFile = this.createUnwrappedObjectFile(unwrappedObject);
            DumpUtils.saveObjectToJson((Object)unwrappedObject, (String)unwrappedObjectFile.getAbsolutePath());
            logger.error("Imported object " + file.getName());
            ++importedObjects;
        }
        logger.error("");
        int importedCsvs = 0;
        if (!skipData) {
            File sourceDataDumpDirectory = Paths.get(this.context.getDumpDirectory(), sourceProjectId, "data").toFile();
            List csvFiles = DumpUtils.findAllDataInDump((File)sourceDataDumpDirectory);
            if (typesToImport.get("datasets").booleanValue()) {
                for (File file : csvFiles) {
                    File newCsvFile = Paths.get(this.context.getDataDumpPath().toString(), file.getName()).toFile();
                    FileUtils.copyFile((File)file, (File)newCsvFile);
                    ++importedCsvs;
                    logger.error("Imported csv file " + file.getName());
                }
                logger.error("");
            }
        }
        File dumpMetadataFile = Paths.get(this.context.getDumpDirectory(), sourceProjectId, "dumpMetadata.json").toFile();
        DumpMetadataDTO dumpMetadata = (DumpMetadataDTO)DumpUtils.loadFileAsClass((File)dumpMetadataFile, DumpMetadataDTO.class);
        this.printImportDumpMessage(sourceProjectId, dumpMetadata.getProjectTitle(), this.context.getCurrentProject(), this.context.getProjectTitle(), importedObjects, importedCsvs);
    }

    protected boolean checkImportParameters(String project, boolean dump, boolean serverSide) {
        if (project == null) {
            logger.error(BannerProvider.ANSI_MAGENTA + "Option --project has to be specified.");
            logger.error("Use --project option to import a project from a server.");
            logger.error("Use --project with --serverSide option to perform import of a project on a server.");
            logger.error("Use --project with --dump option to import dump of a specified project locally." + BannerProvider.ANSI_RESET);
            return false;
        }
        if (serverSide && dump) {
            logger.error(BannerProvider.ANSI_MAGENTA + "You cannot use --serverSide with --dump option." + BannerProvider.ANSI_RESET);
            return false;
        }
        return true;
    }

    private boolean checkProjectSettingsPresentInProject() throws Exception {
        File metadataDumpDirectory;
        List projectSettingsFiles;
        boolean serverProjectSettingPresent;
        MdObjectClient mdObjectClient = new MdObjectClient(this.context.getCanRestClient());
        MdObjectsDTO mdObjects = mdObjectClient.getMdObjects(this.context.getCurrentProject(), "projectSettings");
        boolean bl = serverProjectSettingPresent = mdObjects != null && !mdObjects.isEmpty();
        if (!this.context.isOpenDump()) {
            if (this.context.hasDumpMetadataFile()) {
                this.openDumpCommand.openDumpCmd();
            } else {
                return serverProjectSettingPresent;
            }
        }
        boolean dumpProjectSettingsPresent = !(projectSettingsFiles = DumpUtils.findAllMetadataOfTypeInDump((File)(metadataDumpDirectory = this.context.getMetadataDumpPath().toFile()), (String)"projectSettings")).isEmpty();
        return serverProjectSettingPresent || dumpProjectSettingsPresent;
    }

    protected boolean checkEmptyProject(String projectId, MdShellClient shellClient, boolean force) {
        logger.error("Checking if the project " + projectId + " is empty... ");
        MdObjectsList objectsList = shellClient.getObjectsList(this.context);
        if (!objectsList.isEmpty()) {
            logger.error("FAIL\n");
            if (!force) {
                logger.error("The project already contains " + objectsList.size() + " metadata objects.");
                logger.error("To avoid conflicts, the destination project should be empty. To do that, use truncateProject command.");
                logger.error("If you want to proceed with the import anyway, use the --force argument.\n");
            }
            return force;
        }
        logger.error("OK\n");
        return true;
    }

    protected File createUnwrappedObjectFile(MdObjectDTO unwrappedObject) {
        return Paths.get(this.context.getMetadataDumpPath().toString(), unwrappedObject.getType().toStringPlural(), DumpUtils.appendExtension((String)unwrappedObject.getName(), (String)".json")).toFile();
    }

    protected void importProject(String sourceProjectId, Map<String, Boolean> typesToImport, String prefix, boolean force, boolean skipData, String cascadeFrom) throws Exception {
        if (!this.validationCheck(sourceProjectId, typesToImport, force)) {
            return;
        }
        logger.error("Importing project {}...\n", (Object)sourceProjectId);
        if (!this.context.isOpenDump() && !this.context.hasDumpMetadataFile()) {
            this.dumpProjectCommand.dumpProject(true, false, false, false, force);
        } else {
            this.openDumpCommand.openDumpCmd();
        }
        boolean importDatasets = this.shouldImportDatasets(typesToImport);
        boolean importMdObjects = this.shouldImportMdObjects(typesToImport);
        File destinationDataDirectory = this.context.getDataDumpPath().toFile();
        String destinationProjectId = this.context.getCurrentProject();
        String destinationProjectTitle = this.context.getProjectTitle();
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        List objectsToImport = new ArrayList();
        if (StringUtils.hasText((String)cascadeFrom)) {
            this.openProjectCommand.openProjectCmd(sourceProjectId);
            Boolean datasetsParam = typesToImport.get("datasets");
            boolean includeDatasets = datasetsParam == null || datasetsParam != false || typesToImport.isEmpty();
            objectsToImport = shellClient.getObjectsTree(this.context, cascadeFrom, includeDatasets);
            this.openProjectCommand.openProjectCmd(destinationProjectId);
        }
        Object destinationMdObjects = new MdObjectsDTO();
        if (importMdObjects) {
            destinationMdObjects = DumpUtils.loadMdObjectsFromPath((File)this.context.getMetadataDumpPath().toFile(), typesToImport, objectsToImport);
        }
        this.dumpSourceProject(sourceProjectId, force);
        String sourceProjectTitle = this.context.getProjectTitle();
        File sourceDataDirectory = this.context.getDataDumpPath().toFile();
        Object sourceDatasets = new Datasets();
        if (importDatasets) {
            File sourceDatasetsPath = shellClient.getCurrentDatasetsPath(this.context);
            sourceDatasets = shellClient.loadDatasetsFromPath(sourceDatasetsPath, objectsToImport);
        }
        if (importMdObjects) {
            List sourceMdObjects = DumpUtils.loadMdObjectsFromPath((File)this.context.getMetadataDumpPath().toFile(), typesToImport, objectsToImport);
            destinationMdObjects = this.processMdObjects(prefix, sourceMdObjects, (List)destinationMdObjects);
        }
        this.openDestinationProjectDump(destinationProjectId);
        File destinationDatasetsPath = shellClient.getCurrentDatasetsPath(this.context);
        File destinationMetadataPath = this.context.getMetadataDumpPath().toFile();
        Object destinationDatasets = new Datasets();
        List<Object> destinationCsvs = new ArrayList();
        if (importDatasets) {
            destinationDatasets = shellClient.loadDatasetsFromPath(destinationDatasetsPath, objectsToImport);
            destinationDatasets = this.processDatasets(prefix, sourceProjectId, (List)sourceDatasets, (List)destinationDatasets);
            if (!skipData) {
                this.dumpSourceData(sourceProjectId, (List)destinationDatasets, force);
                File[] sourceDataDirectoryFiles = sourceDataDirectory.listFiles();
                if (sourceDataDirectoryFiles != null) {
                    destinationCsvs = Arrays.asList(sourceDataDirectoryFiles);
                }
            }
            if (prefix != null) {
                this.addPrefixToCsvFiles(sourceDataDirectory, prefix);
                this.addPrefixToDatasets((List)destinationDatasets, prefix);
            }
            FileUtils.copyDirectory((File)sourceDataDirectory, (File)destinationDataDirectory);
            shellClient.saveDatasetsToPath((List)destinationDatasets, destinationDatasetsPath);
        }
        if (importMdObjects) {
            shellClient.saveMdObjectsToPath((List)destinationMdObjects, destinationMetadataPath);
        }
        this.openDestinationProjectDump(destinationProjectId);
        this.printImportServerMessage(sourceProjectId, sourceProjectTitle, destinationProjectId, destinationProjectTitle, (List)destinationDatasets, (List)destinationMdObjects, destinationCsvs);
    }

    private boolean validationCheck(String sourceProjectId, Map<String, Boolean> typesToImport, boolean force) throws IOException {
        ProjectClient projectClient;
        Role roleInProject;
        if (typesToImport.get("datasets").booleanValue() && !(roleInProject = (projectClient = this.getSourceProjectClient()).getMembershipInProject(sourceProjectId).getRole()).equals((Object)Role.VIEWER) && !roleInProject.equals((Object)Role.DUMP_DATA)) {
            DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
            Map violationTypes = dwhShellClient.simpleProjectIntegrityCheck(this.context.getCanRestClient(), sourceProjectId);
            return this.printValidationCheck(violationTypes, force);
        }
        return true;
    }

    private ProjectClient getSourceProjectClient() {
        return new ProjectClient(this.context.getCanRestClient());
    }

    private boolean printValidationCheck(Map<String, Integer> violationTypes, boolean force) {
        if (!violationTypes.isEmpty()) {
            logger.error("FAIL\n");
            logger.error("There are DWH model/data integrity violations in the source project:");
            logger.error(violationTypes + "\n");
            if (!force) {
                logger.error("For a verbose output, open the source project and use validate command.");
                logger.error("If you want to proceed with the import anyway, use the --force argument.\n");
            }
            return force;
        }
        logger.error("OK\n");
        return true;
    }

    private void printImportServerMessage(String sourceProjectId, String sourceProjectTitle, String destinationProjectId, String destinationProjectTitle, List<DatasetDTO> destinationDatasets, List<MdObjectDTO> destinationMdObjects, List<File> destinationCsvs) {
        logger.error("\nImport finished!");
        logger.error("Source project: {} ({})", (Object)sourceProjectId, (Object)sourceProjectTitle);
        logger.error("Destination project: {} ({})", (Object)destinationProjectId, (Object)destinationProjectTitle);
        logger.error("Imported datasets: {}", (Object)destinationDatasets.size());
        logger.error("Imported metadata objects: {}", (Object)destinationMdObjects.size());
        logger.error("Imported CSV files: {}", (Object)destinationCsvs.size());
        logger.error("\nTo view detailed imported content, use status command.");
        logger.error("Now you can make changes, or import another project.");
        if (!destinationDatasets.isEmpty() || !destinationMdObjects.isEmpty()) {
            logger.error("When you're done, use addMetadata command to add the metadata to the project.");
        }
        if (!destinationDatasets.isEmpty()) {
            logger.error("To push the data to the project, use pushProject command.");
        }
        logger.error("");
    }

    private void printImportDumpMessage(String sourceProjectId, String sourceProjectTitle, String destinationProjectId, String destinationProjectTitle, int importedObjects, int importedCsvs) {
        logger.error("\nImport finished!");
        logger.error("Source project: {} ({})", (Object)sourceProjectId, (Object)sourceProjectTitle);
        logger.error("Destination project: {} ({})", (Object)destinationProjectId, (Object)destinationProjectTitle);
        logger.error("Imported metadata objects: {}", (Object)importedObjects);
        logger.error("Imported CSV files: {}", (Object)importedCsvs);
        logger.error("\nTo view detailed imported content, use status command.");
        logger.error("When you're done, use addMetadata command to add the metadata to the project.");
        logger.error("To push the data to the project, use pushProject command.");
        logger.error("");
    }

    private boolean shouldImportMdObjects(Map<String, Boolean> typesToImport) {
        return typesToImport.get("attributeStyles") != false || typesToImport.get("dashboards") != false || typesToImport.get("dataPermissions") != false || typesToImport.get("exports") != false || typesToImport.get("indicators") != false || typesToImport.get("indicatorDrills") != false || typesToImport.get("maps") != false || typesToImport.get("markers") != false || typesToImport.get("markerSelectors") != false || typesToImport.get("metrics") != false || typesToImport.get("projectSettings") != false || typesToImport.get("views") != false;
    }

    private boolean shouldImportDatasets(Map<String, Boolean> typesToImport) {
        return typesToImport.get("datasets");
    }

    private String getAbsoluteDatasetURI(String projectId, String datasetName) {
        MdDatasetClient datasetClient = this.context.getDatasetClient();
        return datasetClient.getAbsoluteDatasetURI(this.context.getConnectedServer(), projectId, datasetName);
    }

    private String getAbsoluteObjectURI(String projectId, MdObjectDTO mdObject) {
        String mdObjectType = mdObject.getType().toStringPlural();
        String mdObjectName = mdObject.getName();
        String relativeURI = UriUtils.objectNameToUri((String)projectId, (String)mdObjectType, (String)mdObjectName).toString();
        return this.context.getConnectedServer() + relativeURI;
    }

    private void dumpSourceProject(String sourceProjectId, boolean force) throws Exception {
        this.createTempDirectory(this.workDirectory, this.context);
        this.context.setDumpDirectory(this.tempDirectory);
        this.openProjectCommand.openProjectCmd(sourceProjectId);
        this.dumpProjectCommand.dumpProject(true, false, false, true, force);
    }

    private void dumpSourceData(String sourceProjectId, List<DatasetDTO> destinationDatasets, boolean force) throws Exception {
        this.context.setDumpDirectory(this.tempDirectory);
        this.openProjectCommand.openProjectCmd(sourceProjectId);
        Datasets dwhDatasets = new Datasets();
        for (DatasetDTO dataset : destinationDatasets) {
            if (!dataset.getRef().getType().equals("dwh")) continue;
            dwhDatasets.add((Object)dataset);
        }
        DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
        dwhShellClient.dumpData(this.context, (List)dwhDatasets, force);
    }

    private void openDestinationProjectDump(String destinationProjectId) throws Exception {
        this.context.setDumpDirectory(this.workDirectory);
        this.openProjectCommand.openProjectCmd(destinationProjectId);
    }

    private List<MdObjectDTO> processMdObjects(String prefix, List<MdObjectDTO> sourceMdObjects, List<MdObjectDTO> destinationMdObjects) throws IOException {
        MdObjectsDTO mdObjectsToImport = new MdObjectsDTO();
        for (MdObjectDTO mdObject : sourceMdObjects) {
            if (prefix != null) {
                PrefixNameLinkReplacer prefixNameLinkReplacer = new PrefixNameLinkReplacer(prefix, mdObject.getName());
                mdObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)mdObject, (ReferenceReplacer)prefixNameLinkReplacer);
                PrefixPropertyIdentifierReplacer prefixPropertyIdentifierReplacer = new PrefixPropertyIdentifierReplacer(prefix);
                mdObject = ReferenceReplaceUtils.replaceReferencesInMdObject((MdObjectDTO)mdObject, (ReferenceReplacer)prefixPropertyIdentifierReplacer);
                mdObject.setName(prefix + mdObject.getName());
            } else if (this.containsName(destinationMdObjects, mdObject.getName())) continue;
            mdObject.setOrigin(this.getAbsoluteObjectURI(this.context.getCurrentProject(), mdObject));
            mdObjectsToImport.add((Object)mdObject);
        }
        return mdObjectsToImport;
    }

    private boolean containsName(List<MdObjectDTO> list, String name) {
        return list.stream().anyMatch(o -> o.getName().equals(name));
    }

    private List<DatasetDTO> processDatasets(String prefix, String sourceProjectId, List<DatasetDTO> sourceDatasets, List<DatasetDTO> destinationDatasets) {
        Datasets datasetsToImport = new Datasets();
        for (DatasetDTO sourceDataset : sourceDatasets) {
            sourceDataset.setType(MdObjectTypeEnum.DATASET);
            if (prefix == null) {
                DatasetDTO destinationDataset = null;
                for (DatasetDTO dataset : destinationDatasets) {
                    if (!dataset.getName().equals(sourceDataset.getName())) continue;
                    destinationDataset = dataset;
                }
                if (destinationDataset != null) {
                    if (sourceDataset.getOrigin() == null || sourceDataset.getOrigin().equals(destinationDataset.getOrigin())) continue;
                    logger.error("Warning: source dataset={} and destination dataset={} have the same name, but different origin.", (Object)sourceDataset.getName(), (Object)destinationDataset.getName());
                    continue;
                }
                if (sourceDataset.getOrigin() == null) {
                    sourceDataset.setOrigin(this.getAbsoluteDatasetURI(sourceProjectId, sourceDataset.getName()));
                }
                datasetsToImport.add((Object)sourceDataset);
                continue;
            }
            if (sourceDataset.getOrigin() == null) {
                sourceDataset.setOrigin(this.getAbsoluteDatasetURI(sourceProjectId, sourceDataset.getName()));
            }
            datasetsToImport.add((Object)sourceDataset);
        }
        return datasetsToImport;
    }

    private void addPrefixToCsvFiles(File dataDumpDirectory, String prefix) throws IOException {
        File[] files = dataDumpDirectory.listFiles();
        if (files != null) {
            for (File csvFile : files) {
                String newFilename;
                String basePath = FilenameUtils.getFullPath((String)csvFile.getPath());
                if (csvFile.renameTo(new File(basePath + (newFilename = prefix + FilenameUtils.getName((String)csvFile.toString()))))) continue;
                throw new FileSystemException("Failed to rename CSV file " + csvFile.getPath());
            }
        }
    }

    private void addPrefixToDatasets(List<DatasetDTO> datasets, String prefix) {
        for (DatasetDTO dataset : datasets) {
            dataset.setName(prefix + dataset.getName());
            if (!(dataset.getRef() instanceof DatasetDwhTypeDTO)) continue;
            this.prefixForeignKeys(dataset, prefix);
            this.prefixGeometries(dataset, prefix);
        }
    }

    private void prefixGeometries(DatasetDTO datasetDTO, String prefix) {
        List h3Geometries;
        String geometry = ((DatasetDwhTypeDTO)datasetDTO.getRef()).getGeometry();
        if (geometry != null) {
            ((DatasetDwhTypeDTO)datasetDTO.getRef()).setGeometry(prefix + geometry);
        }
        if (!CollectionUtils.isEmpty((Collection)(h3Geometries = ((DatasetDwhTypeDTO)datasetDTO.getRef()).getH3Geometries()))) {
            List newH3Geometries = h3Geometries.stream().map(x -> prefix + x).collect(Collectors.toList());
            ((DatasetDwhTypeDTO)datasetDTO.getRef()).setH3Geometries(newH3Geometries);
        }
        List datasetProperties = ((DatasetDwhTypeDTO)datasetDTO.getRef()).getProperties();
        for (DwhAbstractProperty property : datasetProperties) {
            if (!(property instanceof DwhGeometryDTO)) continue;
            String foreignKey = ((DwhGeometryDTO)property).getGeometry();
            ((DwhGeometryDTO)property).setGeometry(prefix + foreignKey);
        }
    }

    private void prefixForeignKeys(DatasetDTO datasetDTO, String prefix) {
        List datasetProperties = ((DatasetDwhTypeDTO)datasetDTO.getRef()).getProperties();
        for (DwhAbstractProperty property : datasetProperties) {
            if (!(property instanceof DwhForeignKeyDTO)) continue;
            String foreignKey = ((DwhForeignKeyDTO)property).getForeignKey();
            ((DwhForeignKeyDTO)property).setForeignKey(prefix + foreignKey);
        }
    }

    private ShellContext createContextCopy() {
        ShellContext backup = new ShellContext();
        backup.setUserEmail(this.context.getUserEmail());
        backup.setUserPassword(this.context.getUserPassword());
        backup.setConnectedServer(this.context.getConnectedServer());
        backup.setProxyHost(this.context.getProxyHost());
        backup.setProxyPort(this.context.getProxyPort());
        backup.setDumpDirectory(this.context.getDumpDirectory());
        backup.setOpenDump(this.context.isOpenDump());
        backup.setCurrentProject(this.context.getCurrentProject());
        backup.setProjectTitle(this.context.getProjectTitle());
        backup.setExitOnError(this.context.isExitOnError());
        backup.setIncompatibleVersion(this.context.isIncompatibleVersion());
        backup.setCanRestClient(this.context.getCanRestClient());
        return backup;
    }

    private void restoreContext(ShellContext backup) {
        this.context.setUserEmail(backup.getUserEmail());
        this.context.setUserPassword(backup.getUserPassword());
        this.context.setConnectedServer(backup.getConnectedServer());
        this.context.setDumpDirectory(backup.getDumpDirectory());
        this.context.setProxyHost(backup.getProxyHost());
        this.context.setProxyPort(backup.getProxyPort());
        this.context.setOpenDump(backup.isOpenDump());
        this.context.setCurrentProject(backup.getCurrentProject());
        this.context.setProjectTitle(backup.getProjectTitle());
        this.context.setExitOnError(backup.isExitOnError());
        this.context.setIncompatibleVersion(backup.isIncompatibleVersion());
        this.context.setCanRestClient(backup.getCanRestClient());
    }

    private void createTempDirectory(String shellDirectory, ShellContext context) {
        File tempDirectory = Paths.get(shellDirectory, context.getCurrentProject()).toFile();
        if (!tempDirectory.exists()) {
            if (tempDirectory.mkdirs()) {
                logger.error("Creating project directory {}", (Object)tempDirectory);
            } else {
                throw new DumpFileWriteException("Cannot create temp directory=" + tempDirectory.getAbsolutePath() + ".");
            }
        }
    }
}

