/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell;

import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.rest.dto.MdObjectsList;
import com.cleveranalytics.service.md.util.AdditionalPropsAllowingMdObjectMapper;
import com.cleveranalytics.service.md.util.CanPrettyPrinter;
import com.cleveranalytics.service.md.util.ETag;
import com.cleveranalytics.service.md.util.UriUtils;
import com.cleveranalytics.shell.LocaleMessageInterpolator;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.ShellConfig;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.DumpFileReadException;
import com.cleveranalytics.shell.exception.DumpFileWriteException;
import com.cleveranalytics.shell.exception.MetadataObjectSyntaxException;
import com.cleveranalytics.shell.exception.ValidationViolationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import jakarta.validation.Configuration;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.hibernate.validator.HibernateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;

/*
 * Exception performing whole class analysis ignored.
 */
public class DumpUtils {
    private static final Logger logger = LoggerFactory.getLogger(DumpUtils.class);
    public static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final DateFormat DUMP_ID_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    public static final Pattern CSV_PATTERN = Pattern.compile("[a-z][a-z0-9_-]+\\.csv");
    public static final Pattern JSON_PATTERN = Pattern.compile("[a-z][a-z0-9_-]+\\.json");
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final ObjectMapper mapper = new AdditionalPropsAllowingMdObjectMapper();
    private static final Validator validator = DumpUtils.initValidator();

    public static Validator initValidator() {
        Configuration config = Validation.byProvider(HibernateValidator.class).configure();
        config = config.messageInterpolator((MessageInterpolator)new LocaleMessageInterpolator(config.getDefaultMessageInterpolator()));
        return config.buildValidatorFactory().getValidator();
    }

    public static boolean isMappableToMd(File file) {
        try {
            mapper.readValue(file, MdObjectDumpDTO.class);
            if (!DumpUtils.isValidMdObjectDump((File)file)) {
                return false;
            }
        }
        catch (IOException ex1) {
            logger.debug("Mapping of file={} to MdObjectDumpDTO failed, message={}", (Object)file.getName(), (Object)ex1.getMessage());
            try {
                mapper.readValue(file, MdObjectDTO.class);
            }
            catch (IOException ex2) {
                logger.debug("Mapping of file={} to MdObjectDTO failed, message={}", (Object)file.getName(), (Object)ex2.getMessage());
                return false;
            }
        }
        return true;
    }

    public static boolean isValidMdObjectDump(File file) {
        try {
            MdObjectDumpDTO mdObjectDump = (MdObjectDumpDTO)mapper.readValue(file, MdObjectDumpDTO.class);
            mdObjectDump.setContent(new MdObjectDTO());
            Set violations = validator.validate((Object)mdObjectDump, new Class[0]);
            if (violations.size() > 0) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static void validateMdObjectDump(File file) throws IOException {
        MdObjectDumpDTO mdObjectDump = (MdObjectDumpDTO)mapper.readValue(file, MdObjectDumpDTO.class);
        mdObjectDump.setContent(new MdObjectDTO());
        Set violations = validator.validate((Object)mdObjectDump, new Class[0]);
        if (violations.size() > 0) {
            throw new ValidationViolationException(violations, file.getName());
        }
    }

    public static <T> T loadFileAsClass(File file, Class<T> clazz) throws IOException {
        try {
            return (T)mapper.readValue(file, clazz);
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileReadException(file.getAbsolutePath(), clazz.getSimpleName(), ex.getMessage());
            }
            throw ex;
        }
    }

    public static MdObjectDumpDTO loadFileAsMdObjectDump(File file) throws IOException {
        try {
            return (MdObjectDumpDTO)mapper.readValue(file, MdObjectDumpDTO.class);
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileReadException(file.getAbsolutePath(), MdObjectDumpDTO.class.getSimpleName(), ex.getMessage());
            }
            throw ex;
        }
    }

    public static List<MdObjectDTO> loadMdObjectsFromPath(File dumpPath, Map<String, Boolean> typesToLoad, List<String> namesToLoad) throws IOException {
        ArrayList<MdObjectDTO> mdObjects = new ArrayList<MdObjectDTO>();
        File[] subdirectories = dumpPath.listFiles();
        if (subdirectories != null) {
            for (File mdObjectTypeFolder : subdirectories) {
                File[] files;
                if (mdObjectTypeFolder.getName().equals("datasets") || (files = mdObjectTypeFolder.listFiles()) == null) continue;
                for (File mdObjectFile : files) {
                    MdObjectDTO mdObject;
                    if (DumpUtils.isValidMdObjectDump((File)mdObjectFile)) {
                        MdObjectDumpDTO mdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)mdObjectFile);
                        mdObject = DumpUtils.unwrapMdObject((MdObjectDumpDTO)mdObjectDump);
                    } else {
                        mdObject = (MdObjectDTO)DumpUtils.loadFileAsClass((File)mdObjectFile, MdObjectDTO.class);
                    }
                    if (!typesToLoad.isEmpty() && !typesToLoad.get(mdObject.getType().toStringPlural()).booleanValue() || !namesToLoad.isEmpty() && !namesToLoad.contains(mdObject.getName())) continue;
                    mdObjects.add(mdObject);
                }
            }
        }
        return mdObjects;
    }

    public static List<MdObjectDumpDTO> loadMdObjectTypeDumps(File dumpPath, List<MdObjectTypeEnum> types) throws IOException {
        ArrayList<MdObjectDumpDTO> mdObjectDumps = new ArrayList<MdObjectDumpDTO>();
        for (MdObjectTypeEnum type : types) {
            mdObjectDumps.addAll(DumpUtils.loadMdObjectTypeDumps((File)dumpPath, (MdObjectTypeEnum)type));
        }
        return mdObjectDumps;
    }

    public static List<MdObjectDumpDTO> loadMdObjectTypeDumps(File dumpPath, MdObjectTypeEnum type) throws IOException {
        ArrayList<MdObjectDumpDTO> mdObjectDumps = new ArrayList<MdObjectDumpDTO>();
        File[] subdirectories = DumpUtils.listFilesSorted((File)dumpPath);
        if (subdirectories != null) {
            for (File mdObjectTypeFolder : subdirectories) {
                File[] files;
                if (!mdObjectTypeFolder.getName().equals(type.toStringPlural()) || (files = DumpUtils.listFilesSorted((File)mdObjectTypeFolder)) == null) continue;
                for (File mdObjectFile : files) {
                    if (!DumpUtils.isValidMdObjectDump((File)mdObjectFile)) continue;
                    MdObjectDumpDTO mdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)mdObjectFile);
                    mdObjectDumps.add(mdObjectDump);
                }
            }
        }
        return mdObjectDumps;
    }

    public static MdObjectDumpDTO wrapMdObject(String projectId, MdObjectDTO mdObject) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)mdObject, (String)"MdObject is null.");
        Long version = mdObject.getVersion();
        mdObject.setVersion(null);
        URI uri = UriUtils.objectIdToURI((String)projectId, (String)mdObject.getType().toStringPlural(), (String)mdObject.getId());
        return new MdObjectDumpDTO().withUrl(uri.toString()).withDumpTime(DumpUtils.formatTimeToIso8601((Date)new Date())).withVersion(version.toString()).withContent(mdObject);
    }

    public static MdObjectDTO unwrapMdObject(MdObjectDumpDTO mdObjectDump) {
        Assert.notNull((Object)mdObjectDump, (String)"MdObjectDump is null.");
        MdObjectDTO mdObject = mdObjectDump.getContent();
        mdObject.setId(null);
        mdObject.setAccessInfo(null);
        Map additionalProperties = mdObject.getAdditionalProperties();
        additionalProperties.remove("links");
        mdObject.setAdditionalProperties(additionalProperties);
        String localVersion = mdObjectDump.getVersion();
        mdObject.setVersion(Long.valueOf(Long.parseLong(localVersion)));
        return mdObject;
    }

    public static File getCsvFileFromPath(String path) throws FileNotFoundException {
        File csvFile = new FileSystemResource(path).getFile();
        if (!csvFile.exists() || !csvFile.canRead()) {
            throw new FileNotFoundException("Cannot find CSV file on path=" + path + ".");
        }
        return csvFile;
    }

    public static String loadCsvLines(File csvFile, int lines) throws IOException {
        StringBuilder output = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            for (int i = 0; i < lines; ++i) {
                String line = br.readLine();
                if (line == null) continue;
                output.append(line);
                output.append(OsUtils.LINE_SEPARATOR);
            }
        }
        return output.toString();
    }

    public static DumpMetadataDTO loadFileAsDumpMetadataFile(File file) throws IOException {
        try {
            return (DumpMetadataDTO)mapper.readValue(file, DumpMetadataDTO.class);
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileReadException(file.getAbsolutePath(), DumpMetadataDTO.class.getSimpleName(), ex.getMessage());
            }
            throw ex;
        }
    }

    public static boolean modifiedSinceDate(File file, Date date) {
        Date lastModified = new Date(file.lastModified());
        return date.compareTo(lastModified) < 0;
    }

    public static boolean modifiedSinceDumpDate(File file) throws ParseException, IOException {
        Date lastModified;
        MdObjectDumpDTO mdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)file);
        Date dumpTime = DumpUtils.parseTimeFromIso8601((String)mdObjectDump.getDumpTime());
        return dumpTime.compareTo(lastModified = new Date(file.lastModified())) < 0;
    }

    public static boolean modifiedSinceDumpMd5(File file, File dumpMetadataFile) throws IOException {
        DumpMetadataDTO dumpMetadata = DumpUtils.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
        LinkedHashMap md5List = new LinkedHashMap();
        if (dumpMetadata.getMetadataContent() != null) {
            md5List.putAll(dumpMetadata.getMetadataContent());
        }
        if (dumpMetadata.getDataContent() != null) {
            md5List.putAll(dumpMetadata.getDataContent());
        }
        if (md5List.size() == 0) {
            return true;
        }
        if (!md5List.containsKey(file.getName())) {
            if (DumpUtils.isValidJsonFilename((File)file)) {
                return !DumpUtils.isValidMdObjectDump((File)file);
            }
            return true;
        }
        String currentMd5 = DumpUtils.calculateMD5((File)file);
        String dumpMd5 = (String)md5List.get(file.getName());
        return !dumpMd5.equals(currentMd5);
    }

    public static String calculateMD5(File file) {
        String string;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            string = DigestUtils.md5Hex((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new CleverMapsShellException("Failed to calculate MD5 checksum of file=" + file.getAbsolutePath());
            }
        }
        inputStream.close();
        return string;
    }

    public static List<File> findNewDataInDump(File dataDumpDirectory) throws IOException {
        File[] subdirectories;
        ArrayList<File> newData = new ArrayList<File>();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File dumpMetadataFile = Paths.get(dataDumpDirectory.getParent(), "dumpMetadata.json").toFile();
        DumpMetadataDTO dumpMetadata = DumpUtils.loadFileAsDumpMetadataFile((File)dumpMetadataFile);
        Map data = new LinkedHashMap();
        if (dumpMetadata.getDataContent() != null) {
            data = dumpMetadata.getDataContent();
        }
        if ((subdirectories = dataDumpDirectory.listFiles()) != null) {
            for (File dataFile : subdirectories) {
                if (!DumpUtils.isValidCsvFilename((File)dataFile)) continue;
                if (data.containsKey(dataFile.getName())) {
                    data.remove(dataFile.getName());
                    continue;
                }
                newData.add(dataFile);
            }
        }
        return newData;
    }

    public static List<File> findModifiedDataInDump(ShellContext context, File dataDumpDirectory) throws IOException {
        ArrayList<File> modifiedData = new ArrayList<File>();
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory + " not found.");
        }
        if (!dumpMetadataFile.exists()) {
            throw new FileNotFoundException("File=" + dumpMetadataFile + " not found.");
        }
        File[] subdirectories = dataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File dataFile : subdirectories) {
                if (DumpUtils.isValidCsvFilename((File)dataFile)) {
                    if (!DumpUtils.modifiedSinceDumpMd5((File)dataFile, (File)dumpMetadataFile)) continue;
                    modifiedData.add(dataFile);
                    continue;
                }
                logger.error("File=" + dataFile.getName() + " has an invalid data filename. The filename must match [a-z0-9_-].csv.");
            }
        }
        return modifiedData;
    }

    public static File findMetadataInDump(ShellContext context, String objectName) throws FileNotFoundException {
        objectName = DumpUtils.appendExtension((String)objectName, (String)".json");
        Path metadataDumpDirectoryPath = context.getMetadataDumpPath();
        if (metadataDumpDirectoryPath != null) {
            File metadataDumpDirectory = metadataDumpDirectoryPath.toFile();
            List allMetadataFiles = DumpUtils.findAllMetadataInDump((File)metadataDumpDirectory);
            List mappableMetadataFiles = DumpUtils.filterUnmappableMetadataFiles((List)allMetadataFiles);
            List wrappedMetadataFiles = DumpUtils.filterUnwrappedMetadataFiles((List)mappableMetadataFiles);
            for (File searchedFile : wrappedMetadataFiles) {
                if (!searchedFile.getName().equals(objectName)) continue;
                return searchedFile;
            }
            List unmappableMetadataFiles = DumpUtils.filterMappableMetadataFiles((List)allMetadataFiles);
            for (File searchedFile : unmappableMetadataFiles) {
                if (!searchedFile.getName().equals(objectName)) continue;
                throw new MetadataObjectSyntaxException("Object " + objectName + " was found in dump , but contains syntax errors and/or constraint violations");
            }
        }
        return null;
    }

    public static File findDataInDump(ShellContext context, String csvName) {
        File[] allDataFiles;
        csvName = DumpUtils.appendExtension((String)csvName, (String)".csv");
        Path dataDumpDirectoryPath = context.getDataDumpPath();
        File foundFile = null;
        if (dataDumpDirectoryPath != null && (allDataFiles = dataDumpDirectoryPath.toFile().listFiles()) != null) {
            for (File searchedFile : allDataFiles) {
                if (!searchedFile.getName().equals(csvName)) continue;
                foundFile = searchedFile;
                break;
            }
        }
        return foundFile;
    }

    public static Map<File, Long> findModifiedMetadataOnServer(ShellContext context, File metadataDumpDirectory) throws IOException {
        HashMap<File, Long> modifiedOnServer = new HashMap<File, Long>();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files;
                if (!metadataType.isDirectory() || (files = metadataType.listFiles()) == null) continue;
                for (File metadataObject : files) {
                    Long version;
                    if (!DumpUtils.isMappableToMd((File)metadataObject) || !DumpUtils.isValidMdObjectDump((File)metadataObject) || (version = DumpUtils.wasModifiedOnServer((ShellContext)context, (File)metadataObject)) == null) continue;
                    modifiedOnServer.put(metadataObject, version);
                }
            }
        }
        return modifiedOnServer;
    }

    protected static Long wasModifiedOnServer(ShellContext context, File metadataObject) throws IOException {
        ETag serverETag;
        MdObjectDumpDTO objectDump = DumpUtils.loadFileAsMdObjectDump((File)metadataObject);
        MdObjectDTO object = objectDump.getContent();
        object.setVersion(Long.valueOf(Long.parseLong(objectDump.getVersion())));
        ETag localETag = new ETag(object);
        try {
            MdShellClient shellClient = (MdShellClient)context.getShellClient();
            String etagValue = shellClient.headMdObjectETag(context.getCurrentProject(), object);
            serverETag = new ETag(etagValue);
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode().equals(HttpStatus.NOT_FOUND)) {
                return -1L;
            }
            throw ex;
        }
        if (!localETag.equals((Object)serverETag)) {
            return serverETag.getVersion();
        }
        return null;
    }

    public static List<File> findAllMetadataInDump(File metadataDumpDirectory) throws FileNotFoundException {
        ArrayList<File> metadataFiles = new ArrayList<File>();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files = metadataType.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    if (DumpUtils.isValidJsonFilename((File)file)) {
                        metadataFiles.add(file);
                        continue;
                    }
                    logger.error("File=" + file.getName() + " has an invalid metadata filename. The filename must match [a-z0-9_-].json.");
                }
            }
        }
        return metadataFiles;
    }

    public static List<File> findAllMetadataOfTypeInDump(File metadataDumpDirectory, String mdObjectType) throws FileNotFoundException {
        ArrayList<File> metadataFiles = new ArrayList<File>();
        File metadataDumpSubdirectory = Paths.get(metadataDumpDirectory.getAbsolutePath(), mdObjectType).toFile();
        if (!metadataDumpSubdirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpSubdirectory.getAbsolutePath() + " not found.");
        }
        File[] files = metadataDumpSubdirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (DumpUtils.isValidJsonFilename((File)file)) {
                    metadataFiles.add(file);
                    continue;
                }
                logger.error("File=" + file.getName() + " has an invalid metadata filename. The filename must match [a-z0-9_-].json.");
            }
        }
        return metadataFiles;
    }

    public static List<File> findAllDataInDump(File dataDumpDirectory) throws IOException {
        ArrayList<File> dataFiles = new ArrayList<File>();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File[] files = dataDumpDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!DumpUtils.isValidCsvFilename((File)file)) continue;
                dataFiles.add(file);
            }
        }
        return dataFiles;
    }

    public static List<File> findModifiedMetadataInDump(ShellContext context, File metadataDumpDirectory) throws IOException {
        ArrayList<File> modifiedMetadata = new ArrayList<File>();
        File dumpMetadataFile = context.getDumpMetadataFile();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory + " not found.");
        }
        if (!dumpMetadataFile.exists()) {
            throw new FileNotFoundException("File=" + dumpMetadataFile + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File subdirectory : subdirectories) {
                File[] files;
                if (!subdirectory.isDirectory() || !DumpUtils.isValidMdType((String)subdirectory.getName()) || (files = subdirectory.listFiles()) == null) continue;
                for (File metadataFile : files) {
                    if (!DumpUtils.isMappableToMd((File)metadataFile) || !DumpUtils.modifiedSinceDumpMd5((File)metadataFile, (File)dumpMetadataFile) || !DumpUtils.isValidJsonFilename((File)metadataFile)) continue;
                    modifiedMetadata.add(metadataFile);
                }
            }
        }
        return modifiedMetadata;
    }

    public static List<MdObjectDTO> findAllMissingFilesInDump(ShellContext context, List<File> allMetadataFiles) throws IOException {
        AbstractShellClient shellClient = context.getShellClient();
        MdObjectsList objectsList = shellClient.getObjectsList(context);
        List localFileNames = allMetadataFiles.stream().map(File::getName).collect(Collectors.toList());
        ArrayList serverMdObjects = new ArrayList();
        ArrayList<MdObjectDTO> missingObjects = new ArrayList<MdObjectDTO>();
        for (String mdObjectType : MdObjectType.getList()) {
            serverMdObjects.addAll(objectsList.getObjectsList(mdObjectType));
        }
        for (MdObjectDTO serverFileName : serverMdObjects) {
            String serverFileNameWithExtension = serverFileName.getName() + ".json";
            if (localFileNames.contains(serverFileNameWithExtension)) continue;
            missingObjects.add(serverFileName);
        }
        return missingObjects;
    }

    public static File renameLocalObject(File oldFile, String newName) throws IOException {
        MdObjectDumpDTO localMdObjectDump = DumpUtils.loadFileAsMdObjectDump((File)oldFile);
        MdObjectDTO localMdObject = localMdObjectDump.getContent();
        String newObjectName = FilenameUtils.removeExtension((String)newName);
        localMdObject.setName(newObjectName);
        Map additionalProperties = localMdObject.getAdditionalProperties();
        additionalProperties.remove("links");
        localMdObject.setAdditionalProperties(additionalProperties);
        localMdObjectDump.setContent(localMdObject);
        String parentDir = FilenameUtils.getFullPath((String)oldFile.getAbsolutePath());
        File newFile = Paths.get(parentDir, newName).toFile();
        DumpUtils.saveObjectToJson((Object)localMdObjectDump, (String)newFile.getPath());
        return newFile;
    }

    public static List<File> filterWrappedMetadataFiles(List<File> metadataFiles) {
        return metadataFiles.stream().filter(file -> !DumpUtils.isValidMdObjectDump((File)file)).collect(Collectors.toList());
    }

    public static List<File> filterUnwrappedMetadataFiles(List<File> metadataFiles) {
        return metadataFiles.stream().filter(DumpUtils::isValidMdObjectDump).collect(Collectors.toList());
    }

    public static List<File> filterUnmappableMetadataFiles(List<File> metadataFiles) {
        return metadataFiles.stream().filter(DumpUtils::isMappableToMd).collect(Collectors.toList());
    }

    public static List<File> filterMappableMetadataFiles(List<File> metadataFiles) {
        return metadataFiles.stream().filter(file -> !DumpUtils.isMappableToMd((File)file)).collect(Collectors.toList());
    }

    public static List<File> filterFilesPresentInMd5List(ShellContext context, List<File> files) throws IOException {
        ArrayList<File> filesNotPresentInMd5List = new ArrayList<File>();
        DumpMetadataDTO dumpMetadataDTO = DumpUtils.loadFileAsDumpMetadataFile((File)context.getDumpMetadataFile());
        Map dumpContent = dumpMetadataDTO.getMetadataContent();
        if (dumpContent != null) {
            for (File file : files) {
                if (dumpContent.containsKey(file.getName())) continue;
                filesNotPresentInMd5List.add(file);
            }
            return filesNotPresentInMd5List;
        }
        return files;
    }

    public static HashMap<String, Integer> getMetadataObjectsDumpList(File dumpDirectory) throws FileNotFoundException {
        File metadataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "metadata").toFile();
        HashMap<String, Integer> objects = new HashMap<String, Integer>();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files = metadataType.listFiles();
                if (files == null || !metadataType.isDirectory()) continue;
                for (int i = 0; i < files.length; ++i) {
                    if (objects.containsKey(metadataType.getName())) {
                        Integer objectCount;
                        Integer n = objectCount = objects.get(metadataType.getName());
                        objectCount = objectCount + 1;
                        objects.put(metadataType.getName(), objectCount);
                        continue;
                    }
                    objects.put(metadataType.getName(), 1);
                }
            }
        }
        return objects;
    }

    public static LinkedHashMap<String, String> getMetadataObjectsMD5List(File dumpDirectory) throws FileNotFoundException {
        File metadataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "metadata").toFile();
        LinkedHashMap<String, String> objects = new LinkedHashMap<String, String>();
        if (!metadataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + metadataDumpDirectory.getAbsolutePath() + " not found.");
        }
        File[] subdirectories = metadataDumpDirectory.listFiles();
        if (subdirectories != null) {
            for (File metadataType : subdirectories) {
                File[] files = metadataType.listFiles();
                if (files == null || !metadataType.isDirectory()) continue;
                for (File object : files) {
                    String md5 = DumpUtils.calculateMD5((File)object);
                    objects.put(object.getName(), md5);
                }
            }
        }
        return objects;
    }

    public static File fetchConfigFile() {
        Path configPath;
        Path canPath = Paths.get(System.getProperty("user.home"), ".cleverAnalytics");
        if (!canPath.toFile().exists()) {
            canPath = Paths.get(System.getProperty("user.home"), ".cleverMaps");
        }
        if ((configPath = Paths.get(canPath.toString(), "config")).toFile().exists()) {
            return configPath.toFile();
        }
        Path configTxtPath = Paths.get(DumpUtils.appendExtension((String)configPath.toString(), (String)".txt"), new String[0]);
        if (configTxtPath.toFile().exists()) {
            return configTxtPath.toFile();
        }
        return null;
    }

    public static void loadProperties(ShellConfig config, File file) throws IOException {
        if (file != null) {
            try (InputStream inputStream = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                Properties properties = new Properties();
                String content = IOUtils.toString((InputStream)inputStream, (Charset)UTF_8);
                properties.load(new StringReader(content.replace("\\", "\\\\").replace("\\:", ":").replace("\\=", "=")));
                if (properties.getProperty("accessToken") != null) {
                    config.setAccessToken(properties.getProperty("accessToken"));
                }
                if (properties.getProperty("server") != null) {
                    config.setServer(properties.getProperty("server"));
                }
                if (properties.getProperty("proxyHost") != null) {
                    config.setProxyHost(properties.getProperty("proxyHost"));
                }
                if (properties.getProperty("proxyPort") != null) {
                    config.setProxyPort(Integer.valueOf(properties.getProperty("proxyPort")));
                }
                if (properties.getProperty("dumpDirectory") != null) {
                    config.setDumpDirectory(properties.getProperty("dumpDirectory"));
                }
                if (properties.getProperty("s3AccessKeyId") != null) {
                    config.setS3AccessKeyId(properties.getProperty("s3AccessKeyId"));
                }
                if (properties.getProperty("s3SecretAccessKey") != null) {
                    config.setS3SecretAccessKey(properties.getProperty("s3SecretAccessKey"));
                }
            }
        }
    }

    public static void saveProperties(ShellConfig config, File file) throws IOException {
        if (file != null) {
            Properties properties = new Properties();
            try (InputStream inputStream = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                String content = IOUtils.toString((InputStream)inputStream, (Charset)UTF_8);
                properties.load(new StringReader(content.replace("\\", "\\\\").replace("\\:", ":").replace("\\=", "=")));
            }
            try (OutputStream outputStream = Files.newOutputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                if (config.getAccessToken() != null) {
                    if (config.getAccessToken().equals("")) {
                        properties.remove("accessToken");
                    } else {
                        properties.setProperty("accessToken", config.getAccessToken());
                    }
                }
                if (config.getServer() != null) {
                    if (config.getServer().equals("")) {
                        properties.remove("server");
                    } else {
                        properties.setProperty("server", config.getServer());
                    }
                }
                if (config.getProxyHost() != null) {
                    if (config.getProxyHost().equals("")) {
                        properties.remove("proxyHost");
                    } else {
                        properties.setProperty("proxyHost", config.getProxyHost());
                    }
                }
                if (config.getProxyPort() != null) {
                    if (config.getProxyPort().equals(0)) {
                        properties.remove("proxyPort");
                    } else {
                        properties.setProperty("proxyPort", String.valueOf(config.getProxyPort()));
                    }
                }
                if (config.getDumpDirectory() != null) {
                    if (config.getDumpDirectory().equals("")) {
                        properties.remove("dumpDirectory");
                    } else {
                        properties.setProperty("dumpDirectory", config.getDumpDirectory());
                    }
                }
                if (config.getS3AccessKeyId() != null) {
                    if (config.getS3AccessKeyId().equals("")) {
                        properties.remove("s3AccessKeyId");
                    } else {
                        properties.setProperty("s3AccessKeyId", config.getS3AccessKeyId());
                    }
                }
                if (config.getS3SecretAccessKey() != null) {
                    if (config.getS3SecretAccessKey().equals("")) {
                        properties.remove("s3SecretAccessKey");
                    } else {
                        properties.setProperty("s3SecretAccessKey", config.getS3SecretAccessKey());
                    }
                }
                properties.store(outputStream, null);
            }
        }
    }

    public static LinkedHashMap<String, String> getDataFilesMD5List(File dumpDirectory) throws FileNotFoundException {
        File dataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "data").toFile();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory + " not found.");
        }
        File[] files = dataDumpDirectory.listFiles();
        if (files != null) {
            for (File csvFile : files) {
                String md5 = DumpUtils.calculateMD5((File)csvFile);
                data.put(csvFile.getName(), md5);
            }
        }
        return data;
    }

    public static HashMap<String, String> getDataDumpList(File dumpDirectory) throws FileNotFoundException {
        File dataDumpDirectory = Paths.get(dumpDirectory.getAbsolutePath(), "data").toFile();
        HashMap<String, String> csvFiles = new HashMap<String, String>();
        if (!dataDumpDirectory.exists()) {
            throw new FileNotFoundException("Directory=" + dataDumpDirectory + " not found.");
        }
        File[] files = dataDumpDirectory.listFiles();
        if (files != null) {
            for (File csvFile : files) {
                String readableFileSize = FileUtils.byteCountToDisplaySize((long)csvFile.length());
                csvFiles.put(csvFile.getName(), readableFileSize);
            }
        }
        return csvFiles;
    }

    public static void saveObjectToJson(Object object, String path) throws IOException {
        path = DumpUtils.appendExtension((String)path, (String)".json");
        CanPrettyPrinter canPrettyPrinter = new CanPrettyPrinter();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]), UTF_8));){
            ObjectWriter ow = mapper.writer().with((PrettyPrinter)canPrettyPrinter);
            writer.write(ow.writeValueAsString(object));
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileWriteException("Cannot write file to path=" + path);
            }
            throw ex;
        }
    }

    public static void saveStringToJson(String content, String path) throws IOException {
        path = DumpUtils.appendExtension((String)path, (String)".json");
        CanPrettyPrinter canPrettyPrinter = new CanPrettyPrinter();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]), UTF_8));){
            Object json = mapper.readValue(content, Object.class);
            ObjectWriter ow = mapper.writer().with((PrettyPrinter)canPrettyPrinter);
            writer.write(ow.with((PrettyPrinter)canPrettyPrinter).writeValueAsString(json));
        }
        catch (IOException ex) {
            if (ex instanceof JsonProcessingException) {
                throw new DumpFileWriteException("Cannot write file to path=" + path);
            }
            throw ex;
        }
    }

    public static void saveStringToJsonUnchecked(String content, String path) {
        path = DumpUtils.appendExtension((String)path, (String)".json");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]), UTF_8));){
            writer.write(content);
        }
        catch (IOException ex) {
            throw new DumpFileWriteException("Cannot write file to path=" + path);
        }
    }

    public static void saveStringToCsv(String content, String path, boolean append) {
        path = DumpUtils.appendExtension((String)path, (String)".csv");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, append), UTF_8));){
            writer.write(content);
        }
        catch (IOException ex) {
            throw new DumpFileWriteException("Cannot write file to path=" + path);
        }
    }

    public static void saveInputStreamToCsv(InputStream csvInputStream, String path) throws IOException {
        path = DumpUtils.appendExtension((String)path, (String)".csv");
        File csvFile = new File(path);
        try (OutputStream outputStream = Files.newOutputStream(csvFile.toPath(), new OpenOption[0]);){
            byte[] buffer = new byte[8192];
            while (csvInputStream.read(buffer) != -1) {
                outputStream.write(buffer);
            }
        }
    }

    public static long getLineCount(File file) throws IOException {
        return Files.lines(file.toPath()).count();
    }

    protected static boolean isValidMdType(String directoryName) {
        return MdObjectType.isValidMdType((String)directoryName);
    }

    public static boolean isValidCsvFilename(File file) {
        return CSV_PATTERN.matcher(file.getName()).matches();
    }

    public static boolean isValidJsonFilename(File file) {
        return JSON_PATTERN.matcher(file.getName()).matches();
    }

    public static String appendExtension(String name, String extension) {
        if (!((String)name).endsWith(extension)) {
            name = (String)name + extension;
        }
        return name;
    }

    public static String removeExtension(String name, String extension) {
        if (name.endsWith(extension)) {
            name = FilenameUtils.removeExtension((String)name);
        }
        return name;
    }

    public static String formatTimeToIso8601(Date date) {
        return ISO_8601_FORMAT.format(date);
    }

    public static Date parseTimeFromIso8601(String date) throws ParseException {
        return ISO_8601_FORMAT.parse(date);
    }

    public static void cleanMetadataDirectories(File metadataDumpPath) throws IOException {
        FileUtils.cleanDirectory((File)metadataDumpPath);
        List typeList = MdObjectType.getList();
        for (String objectType : typeList) {
            File subdirectory = Paths.get(metadataDumpPath.toString(), objectType).toFile();
            if (subdirectory.mkdirs()) continue;
            throw new DumpFileWriteException("Cannot create metadata type subdirectory=" + metadataDumpPath + ".");
        }
    }

    private static File[] listFilesSorted(File directory) {
        Object[] files = directory.listFiles();
        if (files != null) {
            Arrays.sort(files);
            return files;
        }
        return null;
    }
}

