/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.exception;

import com.cleveranalytics.common.exception.CleverMapsException;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.cleveranalytics.shell.exception.ValidationViolationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.sentry.Sentry;
import io.sentry.event.UserBuilder;
import jakarta.validation.ConstraintViolation;
import java.sql.SQLException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShellExceptionHandler {
    private static final String JAVA_VERSION_UP_TO_EIGHT_PATTERN_STRING = "^1\\..*$";
    private static final String JAVA_VERSION_NINE_PATTERN_STRING = "^(9\\..*)|9$";
    private static final String JAVA_VERSION_FROM_TEN_PATTERN_STRING = "^(\\d\\d\\..*)|(\\d\\d)$";
    private static final Pattern javaVersionUpToEightPattern = Pattern.compile("^1\\..*$");
    private static final Pattern javaVersionNinePattern = Pattern.compile("^(9\\..*)|9$");
    private static final Pattern javaVersionFromTenPattern = Pattern.compile("^(\\d\\d\\..*)|(\\d\\d)$");
    private static final Logger logger = LoggerFactory.getLogger(ShellExceptionHandler.class);

    public static void handle(Exception ex, ShellContext context) throws Exception {
        logger.warn("Handling exception={}", (Object)ex.getClass().getCanonicalName(), (Object)ex);
        logger.error("");
        String message = ex instanceof JsonSyntaxException ? ShellExceptionHandler.handleJsonSyntaxException((JsonSyntaxException)((JsonSyntaxException)ex)) : (ex instanceof ValidationViolationException ? ShellExceptionHandler.handleValidationViolationException((ValidationViolationException)((ValidationViolationException)ex)) : (ex instanceof CleverMapsShellException ? ShellExceptionHandler.handleException((Exception)ex) : (ex instanceof CleverMapsException ? ShellExceptionHandler.handleCleverMapsException((CleverMapsException)((CleverMapsException)ex)) : (ex instanceof SQLException ? ShellExceptionHandler.handleSQLException((SQLException)((SQLException)ex)) : ShellExceptionHandler.handleException((Exception)ex)))));
        logger.error(message);
        if (context.getUserEmail() != null && !context.getUserEmail().equals("ci@cleveranalytics.com") && !context.getUserEmail().equals("john@cleveranalytics.com")) {
            ShellExceptionHandler.captureSentryEvent((ShellContext)context, (Exception)ex, (String)message);
        }
        logger.error("Execution failed. Please contact support for assistance with request_id={}\n", (Object)MDC.get((String)"requestId"));
        if (context.isRethrowExceptions()) {
            throw ex;
        }
        if (context.isExitOnError()) {
            System.exit(1);
        }
    }

    private static String handleCleverMapsException(CleverMapsException cleverMapsException) {
        String errorMessage = cleverMapsException.getMessage();
        if (cleverMapsException.getStatus() == null) {
            return ShellExceptionHandler.formatGeneralCleverMapsException((String)errorMessage);
        }
        return ShellExceptionHandler.formatStatusCodeCleverMapsException((String)errorMessage, (HttpStatus)cleverMapsException.getStatus());
    }

    private static String formatGeneralCleverMapsException(String errorMessage) {
        StringBuilder fullMessage = new StringBuilder();
        fullMessage.append("General error=");
        if (StringUtils.hasText((String)errorMessage)) {
            fullMessage.append(errorMessage);
        }
        return fullMessage.toString();
    }

    private static String formatStatusCodeCleverMapsException(String errorMessage, HttpStatus status) {
        StringBuilder fullMessage = new StringBuilder();
        if (status.is5xxServerError()) {
            fullMessage.append("Server error=");
        } else {
            fullMessage.append("Client error=");
        }
        fullMessage.append(status.value());
        fullMessage.append(" - ");
        fullMessage.append(status.getReasonPhrase());
        fullMessage.append("\n");
        if (StringUtils.hasText((String)errorMessage)) {
            fullMessage.append("Error description=");
            fullMessage.append(errorMessage);
        }
        return fullMessage.toString();
    }

    private static String handleJsonSyntaxException(JsonSyntaxException syntaxException) {
        JsonProcessingException exception = syntaxException.getOriginalException();
        String errorFileName = syntaxException.getErrorFileName();
        if (syntaxException.getCausingCommand().equals("addMetadata")) {
            logger.error("Failed to add object {}\n", (Object)errorFileName);
        } else if (syntaxException.getCausingCommand().equals("pushProject")) {
            logger.error("Failed to push object {}\n", (Object)errorFileName);
        } else if (syntaxException.getCausingCommand().equals("diff")) {
            logger.error("Failed to create a diff of object {}\n", (Object)errorFileName);
        } else {
            throw new CleverMapsShellException("Unknown JsonSyntaxException causing command=" + syntaxException.getCausingCommand() + ".");
        }
        if (exception instanceof JsonParseException) {
            return ShellExceptionHandler.handleJsonParseException((JsonParseException)((JsonParseException)exception));
        }
        if (exception instanceof JsonMappingException) {
            if (exception.getCause() instanceof JsonParseException) {
                return ShellExceptionHandler.handleJsonParseException((JsonParseException)((JsonParseException)exception.getCause()));
            }
            return ShellExceptionHandler.handleJsonMappingException((JsonMappingException)((JsonMappingException)exception));
        }
        throw new CleverMapsShellException("Exception thrown is not a descendant of JsonProcessingException. Failed to create the error output.");
    }

    private static String handleJsonParseException(JsonParseException exception) {
        StringBuilder fullMessage = new StringBuilder();
        int lineNumber = exception.getLocation().getLineNr();
        int columnNumber = exception.getLocation().getColumnNr();
        String detailMessage = exception.getMessage().split("\\r?\\n|\\r")[0];
        fullMessage.append("General error=JSON syntax error at line: ");
        fullMessage.append(lineNumber);
        fullMessage.append(", column: ");
        fullMessage.append(columnNumber);
        fullMessage.append("\n");
        fullMessage.append("Error description=");
        fullMessage.append(ShellExceptionHandler.simplifyDetailMessage((String)detailMessage));
        return fullMessage.toString();
    }

    private static String handleJsonMappingException(JsonMappingException exception) {
        StringBuilder path = new StringBuilder("$");
        if (exception.getPath().size() == 0) {
            path.append(" (object root)");
        } else {
            path.append(".");
            for (int i = 0; i < exception.getPath().size(); ++i) {
                JsonMappingException.Reference reference = (JsonMappingException.Reference)exception.getPath().get(i);
                if (reference.getFieldName() == null) {
                    path.append(reference.getIndex());
                } else {
                    path.append(reference.getFieldName());
                }
                if (i >= exception.getPath().size() - 1) continue;
                path.append(".");
            }
        }
        StringBuilder fullMessage = new StringBuilder();
        if (exception.getLocation() != null) {
            int lineNumber = exception.getLocation().getLineNr();
            int columnNumber = exception.getLocation().getColumnNr();
            fullMessage.append("General error=JSON syntax error at line: ");
            fullMessage.append(lineNumber);
            fullMessage.append(", column: ");
            fullMessage.append(columnNumber);
            fullMessage.append(", path: ");
            fullMessage.append((CharSequence)path);
        } else {
            fullMessage.append("General error=JSON syntax error at path: ");
            fullMessage.append((CharSequence)path);
        }
        fullMessage.append("\n");
        fullMessage.append("Error description=");
        String detailMessage = exception.getMessage().split("\\r?\\n|\\r")[0];
        fullMessage.append(ShellExceptionHandler.simplifyDetailMessage((String)detailMessage));
        return fullMessage.toString();
    }

    private static String simplifyDetailMessage(String message) {
        message = message.replace("(for ARRAY starting at [Source: {", "");
        message = message.split("\\(for class")[0];
        message = message.split("\\(through")[0];
        return message;
    }

    private static String handleValidationViolationException(ValidationViolationException exception) {
        ConstraintViolation[] violationArray;
        StringBuilder fullMessage = new StringBuilder();
        Set violationSet = exception.violations;
        for (ConstraintViolation violation : violationArray = violationSet.toArray(new ConstraintViolation[violationSet.size()])) {
            fullMessage.append("General error=Field '");
            fullMessage.append(violation.getPropertyPath());
            fullMessage.append("' of object name=");
            fullMessage.append(exception.fileName);
            fullMessage.append(" ");
            fullMessage.append(violation.getMessage());
            fullMessage.append("\n");
        }
        return fullMessage.toString();
    }

    private static String handleSQLException(SQLException exception) {
        return "General error=" + exception.getMessage() + " (SQL state " + exception.getSQLState() + ")";
    }

    private static String handleException(Exception exception) {
        String message = exception.getMessage();
        Object fullMessage = "General error=";
        fullMessage = exception.getMessage() != null ? (String)fullMessage + exception.getMessage() : (String)fullMessage + "No details are available. Exception type=" + exception.getClass().getName();
        if (message != null && message.contains("invalid byte sequence")) {
            fullMessage = (String)fullMessage + "\n\nHINT: If this error persists you can bypass by using loadCsv or pushProject with the '--gzip false' parameter.";
        }
        return fullMessage;
    }

    public static void captureSentryEvent(ShellContext context, Exception ex, String message) {
        String userAgent;
        String version = null;
        if (context.getCanRestClient() != null && (userAgent = context.getCanRestClient().getUserAgent()).split("/").length > 2) {
            version = userAgent.split("/")[2];
        }
        Sentry.getContext().setUser(new UserBuilder().setUsername(context.getUserEmail()).build());
        Sentry.getContext().addTag("project_id", context.getCurrentProject());
        Sentry.getContext().addTag("exception", ex.getClass().getSimpleName());
        Sentry.getContext().addTag("user", context.getUserEmail());
        Sentry.getContext().addTag("version", version);
        Sentry.getContext().addTag("running_in_docker", context.isRunningInDocker() ? "true" : "false");
        Sentry.getContext().addTag("java_runtime", ShellExceptionHandler.getJavaRuntimeMajorVersion());
        Sentry.getContext().addExtra("server", (Object)context.getConnectedServer());
        Sentry.getContext().addExtra("project_id", (Object)context.getCurrentProject());
        Sentry.getContext().addExtra("project_title", (Object)context.getProjectTitle());
        Sentry.getContext().addExtra("user", (Object)context.getUserEmail());
        Sentry.getContext().addExtra("version", (Object)version);
        Sentry.getContext().addExtra("dump_directory", (Object)context.getDumpDirectory());
        Sentry.getContext().addExtra("open_dump", (Object)(context.isOpenDump() ? "true" : "false"));
        Sentry.getContext().addExtra("exit_on_error", (Object)context.isExitOnError());
        Sentry.getContext().addExtra("incompatible_version", (Object)context.isIncompatibleVersion());
        Sentry.getContext().addExtra("running_in_docker", (Object)context.isRunningInDocker());
        Sentry.getContext().addExtra("request_id", (Object)MDC.get((String)"requestId"));
        Sentry.getContext().addExtra("exception", (Object)ex.getClass().getName());
        Sentry.getContext().addExtra("stack_trace", (Object)ex.getStackTrace());
        Sentry.capture((String)message);
    }

    private static String getJavaRuntimeMajorVersion() {
        try {
            Matcher versionFromTenMatcher;
            Matcher versionNineMatcher;
            String javaVersion = System.getProperty("java.version");
            if (javaVersion == null) {
                return null;
            }
            String javaMajorVersion = null;
            Matcher versionUpToEightMatcher = javaVersionUpToEightPattern.matcher(javaVersion);
            if (versionUpToEightMatcher.matches()) {
                javaMajorVersion = javaVersion.substring(2, 3);
            }
            if ((versionNineMatcher = javaVersionNinePattern.matcher(javaVersion)).matches()) {
                javaMajorVersion = javaVersion.substring(0, 1);
            }
            if ((versionFromTenMatcher = javaVersionFromTenPattern.matcher(javaVersion)).matches()) {
                javaMajorVersion = javaVersion.substring(0, 2);
            }
            return javaMajorVersion;
        }
        catch (SecurityException securityException) {
            logger.warn("Could not retrieve java.version property. Error={} ", (Object)securityException.getMessage());
            return null;
        }
    }
}

