/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.ProjectDTO;
import com.cleveranalytics.shell.commands.connected.OpenProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CreateProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(CreateProjectCommand.class);
    protected ProjectClient projectClient;
    private ShellContext context;
    private OpenProjectCommand openProjectCommand;

    @Autowired
    public CreateProjectCommand(ShellContext context) {
        this.context = context;
        this.openProjectCommand = new OpenProjectCommand(context);
    }

    @CliAvailabilityIndicator(value={"createProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null;
    }

    @CliCommand(value={"createProject"}, help="Creates a new project and opens it.")
    public void createProjectCmd(@CliOption(key={"title"}, mandatory=true, help="Title of the project. Use quotes (\"sample project\") if the title contains spaces.") String title, @CliOption(key={"description"}, mandatory=false, help="Description of the project. Use quotes (\"sample description\") if the description contains spaces. A description can be formatted by markdown syntax.") String description, @CliOption(key={"organization"}, mandatory=false, help="ID of the organization which will become the owner of the project. If not set, a CM Trial will be selected.") String organization) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            String newProjectId = this.createProject(title, description, organization);
            this.openProjectCommand.openProjectCmd(newProjectId);
            this.context.setCurrentProject(newProjectId);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected String createProject(String title, String description, String organization) {
        ProjectDTO project;
        this.projectClient = new ProjectClient(this.context.getCanRestClient());
        if (StringUtils.hasText((String)organization)) {
            project = this.projectClient.createProject(title, description, organization);
        } else {
            System.out.println("No organization has been set for a new project, creating a TRIAL project.");
            project = this.projectClient.createProject(title, description);
        }
        System.out.println("Created project " + project.getId());
        return project.getId();
    }
}

