/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.client.CanRestClient;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.exception.MdException;
import com.cleveranalytics.service.md.rest.dto.GenerateDatasetRequestDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.rest.dto.MdObjectsDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectsList;
import com.cleveranalytics.service.md.rest.dto.MdReferenceTree;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.rest.dto.other.ShareContentDTO;
import com.cleveranalytics.service.md.util.ETag;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.Role;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.IdLinkReplacer;
import com.cleveranalytics.shell.client.LinkReplacer;
import com.cleveranalytics.shell.client.NameLinkReplacer;
import com.cleveranalytics.shell.client.PlaceholderLinkReplacer;
import com.cleveranalytics.shell.client.PropertyIdentifierReplacer;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MdShellClient
extends AbstractShellClient {
    private static final Logger logger = LoggerFactory.getLogger(MdShellClient.class);
    private final ObjectMapper mapper = new MdObjectMapper();
    private final MdObjectClient mdObjectClient;

    public MdShellClient(CanRestClient canRestClient) {
        this.mdObjectClient = new MdObjectClient(canRestClient);
    }

    public MdObjectsList getObjectsList(ShellContext context) {
        MdObjectsList objectsList = new MdObjectsList();
        ProjectClient projectClient = new ProjectClient(context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        block28: for (String mdObjectType : MdObjectType.getList()) {
            if (mdObjectType.equals("dataPermissions") && !projectRole.equals((Object)Role.ADMIN)) {
                objectsList = objectsList.withDataPermissions(new ArrayList());
                continue;
            }
            MdObjectsDTO mdObjects = this.mdObjectClient.getMdObjects(context.getCurrentProject(), mdObjectType);
            switch (mdObjectType) {
                case "dashboards": {
                    objectsList = objectsList.withDashboards((List)mdObjects);
                    continue block28;
                }
                case "dataPermissions": {
                    objectsList = objectsList.withDataPermissions((List)mdObjects);
                    continue block28;
                }
                case "datasets": {
                    objectsList = objectsList.withDatasets((List)mdObjects);
                    continue block28;
                }
                case "exports": {
                    objectsList = objectsList.withExports((List)mdObjects);
                    continue block28;
                }
                case "indicatorDrills": {
                    objectsList = objectsList.withIndicatorDrills((List)mdObjects);
                    continue block28;
                }
                case "indicators": {
                    objectsList = objectsList.withIndicators((List)mdObjects);
                    continue block28;
                }
                case "markers": {
                    objectsList = objectsList.withMarkers((List)mdObjects);
                    continue block28;
                }
                case "markerSelectors": {
                    objectsList = objectsList.withMarkerSelectors((List)mdObjects);
                    continue block28;
                }
                case "metrics": {
                    objectsList = objectsList.withMetrics((List)mdObjects);
                    continue block28;
                }
                case "projectSettings": {
                    objectsList = objectsList.withProjectSettings((List)mdObjects);
                    continue block28;
                }
                case "shares": {
                    objectsList = objectsList.withShares((List)mdObjects);
                    continue block28;
                }
                case "views": {
                    objectsList = objectsList.withViews((List)mdObjects);
                    continue block28;
                }
            }
            logger.error("\"" + mdObjectType + "\" is not a valid MdObject type.");
        }
        return objectsList;
    }

    public List<String> getObjectsTree(ShellContext context, String objectName, boolean includeDatasets) {
        MdReferenceTree tree = this.mdObjectClient.getReferenceTree(context.getCurrentProject(), objectName, includeDatasets);
        Set objectNames = this.parseReferenceTree(tree, new HashSet());
        return new ArrayList<String>(objectNames);
    }

    private Set<String> parseReferenceTree(MdReferenceTree tree, Set<String> objectNames) {
        objectNames.add(tree.getName());
        for (MdReferenceTree reference : tree.getReferences()) {
            this.parseReferenceTree(reference, objectNames);
        }
        return objectNames;
    }

    public List<MdReferenceTree> getOrphanObjects(ShellContext context) {
        List trees = this.mdObjectClient.getReferenceOrphans(context.getCurrentProject());
        HashSet allObjectReferences = new HashSet();
        for (MdReferenceTree tree : trees) {
            Set objectReferences = this.flattenReferenceTree(tree, new HashSet());
            allObjectReferences.addAll(objectReferences);
        }
        return new ArrayList<MdReferenceTree>(allObjectReferences);
    }

    private Set<MdReferenceTree> flattenReferenceTree(MdReferenceTree tree, Set<MdReferenceTree> objectReferences) {
        objectReferences.add(tree);
        for (MdReferenceTree reference : tree.getReferences()) {
            this.flattenReferenceTree(reference, objectReferences);
        }
        return objectReferences;
    }

    public void dumpObjectsLocal(ShellContext context) throws IOException {
        String projectId = context.getCurrentProject();
        ProjectClient projectClient = new ProjectClient(context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        for (String mdObjectType : MdObjectType.getList()) {
            MdObjectsDTO mdObjects;
            if (mdObjectType.equals("dataPermissions") && !projectRole.equals((Object)Role.ADMIN) || (mdObjects = this.mdObjectClient.getMdObjects(projectId, mdObjectType)).size() <= 0) continue;
            System.out.println("Dumping " + mdObjectType);
            for (MdObjectDTO mdObject : mdObjects) {
                this.wrapAndSaveMdObject(context, mdObject);
            }
        }
    }

    public void wrapAndSaveMdObject(ShellContext context, MdObjectDTO mdObject) throws IOException {
        Assert.notNull((Object)context, (String)"ShellContext is null.");
        Assert.notNull((Object)mdObject, (String)"MdObject is null.");
        String serverETagValue = this.headMdObjectETag(context.getCurrentProject(), mdObject);
        mdObject = this.replaceURILinks(mdObject, (LinkReplacer)new IdLinkReplacer(mdObject.getName()));
        mdObject.setVersion(new ETag(serverETagValue).getVersion());
        MdObjectDumpDTO objectDump = this.wrapMdObject(context.getCurrentProject(), mdObject);
        String filename = FileTools.appendExtension((String)mdObject.getName(), (String)".json");
        File typeDirectory = this.createMetadataSubfolder(context.getMetadataDumpPath().toFile(), mdObject.getType());
        Path path = Paths.get(typeDirectory.toString(), filename);
        FileTools.saveObjectToJson((Object)objectDump, (String)path.toString());
        this.putMetadataChecksumListElement(context, path.toFile());
    }

    public void addObject(String projectId, File file, boolean silent) throws IOException {
        MdObjectDTO mdObject;
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to add is null.");
        try {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            mdObject = (MdObjectDTO)this.mapper.readValue(content, MdObjectDTO.class);
        }
        catch (JsonProcessingException exception) {
            throw new JsonSyntaxException(file, (Object)"addMetadata", exception);
        }
        try {
            if (!mdObject.getName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
                throw new CleverMapsShellException("JSON object name=" + mdObject.getName() + " and the filename=" + file.getName() + " do not match.");
            }
            mdObject = this.replaceURILinks(mdObject, (LinkReplacer)new PlaceholderLinkReplacer(projectId, mdObject.getName()));
            MdObjectDTO response = this.mdObjectClient.postMdObject(projectId, mdObject);
            response = this.replaceURILinks(response, (LinkReplacer)new IdLinkReplacer(mdObject.getName()));
            String serverETagValue = this.headMdObjectETag(projectId, response);
            response.setVersion(new ETag(serverETagValue).getVersion());
            MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, response);
            FileTools.saveObjectToJson((Object)objectDump, (String)file.getAbsolutePath());
        }
        catch (MdException ex) {
            if (!silent) {
                logger.error("Failed to add object " + file.getName());
            }
            throw ex;
        }
    }

    public void pushObject(String projectId, File file) throws IOException {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to push is null.");
        MdObjectDumpDTO mdObjectDump = this.validateAndMapToMdObjectDump(file);
        MdObjectDTO mdObject = mdObjectDump.getContent();
        try {
            mdObject = this.replaceURILinks(mdObject, (LinkReplacer)new PlaceholderLinkReplacer(projectId, mdObject.getName()));
            mdObject.setVersion(Long.valueOf(Long.parseLong(mdObjectDump.getVersion())));
            MdObjectDTO response = this.mdObjectClient.putMdObject(projectId, mdObject.getType().toStringPlural(), mdObject.getId(), mdObject, false);
            response = this.replaceURILinks(response, (LinkReplacer)new IdLinkReplacer(mdObject.getName()));
            String serverETagValue = this.headMdObjectETag(projectId, response);
            response.setVersion(new ETag(serverETagValue).getVersion());
            MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, response);
            FileTools.saveObjectToJson((Object)objectDump, (String)file.getAbsolutePath());
        }
        catch (MdException ex) {
            logger.error("Failed to push object " + file.getName());
            throw ex;
        }
    }

    public void pushObjectForce(String projectId, File file, boolean force) throws IOException {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to push is null.");
        MdObjectDumpDTO mdObjectDump = this.validateAndMapToMdObjectDump(file);
        MdObjectDTO mdObject = mdObjectDump.getContent();
        try {
            mdObject = this.replaceURILinks(mdObject, (LinkReplacer)new PlaceholderLinkReplacer(projectId, mdObject.getName()));
            mdObject.setVersion(Long.valueOf(Long.parseLong(mdObjectDump.getVersion())));
            MdObjectDTO response = this.mdObjectClient.putMdObject(projectId, mdObject.getType().toStringPlural(), mdObject.getId(), mdObject, true);
            response = this.replaceURILinks(response, (LinkReplacer)new IdLinkReplacer(mdObject.getName()));
            String serverETagValue = this.headMdObjectETag(projectId, response);
            response.setVersion(new ETag(serverETagValue).getVersion());
            MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, response);
            FileTools.saveObjectToJson((Object)objectDump, (String)file.getAbsolutePath());
        }
        catch (MdException ex) {
            logger.error("Failed to push object " + file.getName());
            throw ex;
        }
    }

    private MdObjectDumpDTO validateAndMapToMdObjectDump(File file) throws IOException {
        try {
            FileTools.validateMdObjectDump((File)file);
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            MdObjectDumpDTO mdObjectDump = (MdObjectDumpDTO)this.mapper.readValue(content, MdObjectDumpDTO.class);
            if (!mdObjectDump.getContent().getName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
                throw new CleverMapsShellException("JSON object name=" + mdObjectDump.getContent().getName() + " and the filename=" + file.getName() + " do not match.");
            }
            return mdObjectDump;
        }
        catch (JsonProcessingException exception) {
            throw new JsonSyntaxException(file, (Object)"pushProject", exception);
        }
    }

    public void removeObjectByName(ShellContext context, String mdObjectType, String filename) {
        Assert.notNull((Object)context, (String)"Context cannot be null.");
        Assert.hasText((String)mdObjectType, (String)"Missing property type.");
        Assert.hasText((String)filename, (String)"Missing filename of object to delete.");
        String objectName = FilenameUtils.removeExtension((String)filename);
        MdObjectDTO mdObject = this.mdObjectClient.getMdObjectByName(context.getCurrentProject(), mdObjectType, objectName);
        this.mdObjectClient.deleteMdObjectById(context.getCurrentProject(), mdObjectType, mdObject.getId());
    }

    public void removeObjectById(String projectId, String mdObjectType, String id) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.hasText((String)mdObjectType, (String)"Missing property type.");
        Assert.hasText((String)id, (String)"Missing id of object to delete.");
        this.mdObjectClient.deleteMdObjectById(projectId, mdObjectType, id);
    }

    public DatasetDTO generateDataset(String projectId, String name, String subtype, String primaryKey, String geometry, File csvFile, Character csvSeparator, Character csvQuote, Character csvEscape) throws IOException {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.hasText((String)name, (String)"Missing property name.");
        Assert.hasText((String)subtype, (String)"Missing property subtype.");
        Assert.notNull((Object)csvFile, (String)"Missing csv file.");
        String csvContent = FileTools.loadCsvLines((File)csvFile, (int)10);
        return this.mdObjectClient.generateDataset(projectId, name, subtype, Optional.ofNullable(primaryKey), csvContent, Optional.ofNullable(geometry), Optional.ofNullable(csvSeparator), Optional.ofNullable(csvQuote), Optional.ofNullable(csvEscape));
    }

    public DatasetDTO generateDataset(String projectId, GenerateDatasetRequestDTO generateRequest) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)generateRequest, (String)"GenerateDatasetRequest must not be null.");
        return this.mdObjectClient.generateDataset(projectId, generateRequest);
    }

    public MdObjectDumpDTO renameObject(ShellContext context, File localFile, String oldName, String newName) throws IOException {
        Assert.notNull((Object)context, (String)"ShellContext is null.");
        Assert.notNull((Object)localFile, (String)"LocalFile is null.");
        Assert.hasText((String)oldName, (String)"Missing oldName of object to be renamed.");
        Assert.hasText((String)newName, (String)"Missing newName of object to be renamed.");
        File renamedLocalFile = FileTools.renameLocalObject((File)localFile, (String)newName);
        if (!renamedLocalFile.exists()) {
            throw new IOException("Failed to rename local object " + oldName);
        }
        logger.error("Object:");
        logger.error("\tLocal object {} successfully renamed to {}", (Object)oldName, (Object)newName);
        FileUtils.deleteQuietly((File)localFile);
        AbstractShellClient shellClient = context.getShellClient();
        String oldObjectName = FilenameUtils.removeExtension((String)oldName);
        String newObjectName = FilenameUtils.removeExtension((String)newName);
        shellClient.pushObject(context.getCurrentProject(), renamedLocalFile);
        logger.error("\tRemote object {} successfully renamed to {}\n", (Object)oldObjectName, (Object)newObjectName);
        shellClient.removeMetadataChecksumListElement(context, localFile);
        shellClient.putMetadataChecksumListElement(context, renamedLocalFile);
        return FileTools.loadFileAsMdObjectDump((File)renamedLocalFile);
    }

    public void renameObjectReferences(ShellContext context, MdObjectDumpDTO objectDumpToRename, List<MdObjectDumpDTO> renamedReferences) throws IOException {
        logger.error("Object references:");
        if (renamedReferences.size() > 0) {
            for (MdObjectDumpDTO renamedReference : renamedReferences) {
                String objectName = renamedReference.getContent().getName();
                String filename = FileTools.appendExtension((String)objectName, (String)".json");
                Path path = Paths.get(context.getMetadataDumpPath().toString(), renamedReference.getContent().getType().toStringPlural(), filename);
                FileTools.saveObjectToJson((Object)renamedReference, (String)path.toAbsolutePath().toString());
                String objectType = objectDumpToRename.getContent().getType().toString();
                logger.error("\tRenamed {} reference(s) key in local file {} and uploaded it", (Object)objectType, (Object)filename);
                AbstractShellClient shellClient = context.getShellClient();
                shellClient.pushObject(context.getCurrentProject(), path.toFile());
                shellClient.putMetadataChecksumListElement(context, path.toFile());
            }
            logger.error("");
        } else {
            logger.error("\tThis object is not referenced in any other object(s).\n");
        }
    }

    public List<DatasetDTO> loadDatasetsFromPath(File path, List<String> namesToLoad) throws IOException {
        ArrayList<DatasetDTO> datasets = new ArrayList<DatasetDTO>();
        File[] files = path.listFiles();
        if (files != null) {
            for (File datasetFile : files) {
                DatasetDTO dataset;
                if (FileTools.isValidMdObjectDump((File)datasetFile)) {
                    MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)datasetFile);
                    dataset = (DatasetDTO)this.unwrapMdObject(mdObjectDump);
                } else {
                    dataset = (DatasetDTO)FileTools.loadFileAsClass((File)datasetFile, DatasetDTO.class);
                }
                if (!namesToLoad.isEmpty() && !namesToLoad.contains(dataset.getName())) continue;
                datasets.add(dataset);
            }
        }
        return datasets;
    }

    public List<MdObjectDTO> loadMdObjectsFromPath(File dumpPath, Map<String, Boolean> typesToLoad, List<String> namesToLoad) throws IOException {
        ArrayList<MdObjectDTO> mdObjects = new ArrayList<MdObjectDTO>();
        File[] subdirectories = dumpPath.listFiles();
        if (subdirectories != null) {
            for (File mdObjectTypeFolder : subdirectories) {
                File[] files;
                if (mdObjectTypeFolder.getName().equals("datasets") || (files = mdObjectTypeFolder.listFiles()) == null) continue;
                for (File mdObjectFile : files) {
                    MdObjectDTO mdObject;
                    if (FileTools.isValidMdObjectDump((File)mdObjectFile)) {
                        MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)mdObjectFile);
                        mdObject = this.unwrapMdObject(mdObjectDump);
                    } else {
                        mdObject = (MdObjectDTO)FileTools.loadFileAsClass((File)mdObjectFile, MdObjectDTO.class);
                    }
                    if (!typesToLoad.isEmpty() && !typesToLoad.get(mdObject.getType().toStringPlural()).booleanValue() || !namesToLoad.isEmpty() && !namesToLoad.contains(mdObject.getName())) continue;
                    mdObjects.add(mdObject);
                }
            }
        }
        return mdObjects;
    }

    public List<MdObjectDumpDTO> loadMdObjectTypeDumps(File dumpPath, List<MdObjectTypeEnum> types) throws IOException {
        ArrayList<MdObjectDumpDTO> mdObjectDumps = new ArrayList<MdObjectDumpDTO>();
        for (MdObjectTypeEnum type : types) {
            mdObjectDumps.addAll(this.loadMdObjectTypeDumps(dumpPath, type));
        }
        return mdObjectDumps;
    }

    public List<MdObjectDumpDTO> loadMdObjectTypeDumps(File dumpPath, MdObjectTypeEnum type) throws IOException {
        ArrayList<MdObjectDumpDTO> mdObjectDumps = new ArrayList<MdObjectDumpDTO>();
        File[] subdirectories = dumpPath.listFiles();
        if (subdirectories != null) {
            for (File mdObjectTypeFolder : subdirectories) {
                File[] files;
                if (!mdObjectTypeFolder.getName().equals(type.toStringPlural()) || (files = mdObjectTypeFolder.listFiles()) == null) continue;
                for (File mdObjectFile : files) {
                    if (!FileTools.isValidMdObjectDump((File)mdObjectFile)) continue;
                    MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)mdObjectFile);
                    mdObjectDumps.add(mdObjectDump);
                }
            }
        }
        return mdObjectDumps;
    }

    public void saveDatasetsToPath(List<DatasetDTO> datasets, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Failed to create directory=" + path);
        }
        for (DatasetDTO dataset : datasets) {
            String datasetName = FileTools.appendExtension((String)dataset.getName(), (String)".json");
            Path finalPath = Paths.get(path.toString(), datasetName);
            FileTools.saveObjectToJson((Object)dataset, (String)finalPath.toString());
        }
    }

    public void saveMdObjectsToPath(List<MdObjectDTO> mdObjects, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Failed to create directory=" + path);
        }
        for (MdObjectDTO mdObject : mdObjects) {
            String mdObjectName = FileTools.appendExtension((String)mdObject.getName(), (String)".json");
            String type = mdObject.getType().toStringPlural();
            Path finalPath = Paths.get(path.toString(), type, mdObjectName);
            FileTools.saveObjectToJson((Object)mdObject, (String)finalPath.toString());
        }
    }

    public File getCurrentDatasetsPath(ShellContext context) {
        return Paths.get(context.getMetadataDumpPath().toString(), "datasets").toFile();
    }

    public String headMdObjectETag(String projectId, MdObjectDTO mdObject) {
        MdObjectTypeEnum type = mdObject.getType();
        if (type.equals((Object)MdObjectTypeEnum.SHARE)) {
            String objectId = ((ShareContentDTO)mdObject.getContent()).getObjectId();
            return this.mdObjectClient.headETagValue(projectId, type.toStringPlural(), mdObject.getId(), objectId);
        }
        return this.mdObjectClient.headETagValue(projectId, type.toStringPlural(), mdObject.getId());
    }

    public MdObjectDumpDTO wrapMdObject(String projectId, MdObjectDTO mdObject) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)mdObject, (String)"MdObject is null.");
        Long version = mdObject.getVersion();
        mdObject.setVersion(null);
        URI uri = this.mdObjectClient.objectIdToURI(projectId, mdObject.getType().toStringPlural(), mdObject.getId(), false);
        return new MdObjectDumpDTO().withUrl(uri.toString()).withDumpTime(FileTools.formatTimeToIso8601((Date)new Date())).withVersion(version.toString()).withContent(mdObject);
    }

    public MdObjectDTO unwrapMdObject(MdObjectDumpDTO mdObjectDump) {
        Assert.notNull((Object)mdObjectDump, (String)"MdObjectDump is null.");
        MdObjectDTO mdObject = mdObjectDump.getContent();
        mdObject.setId(null);
        mdObject.setAccessInfo(null);
        Map additionalProperties = mdObject.getAdditionalProperties();
        additionalProperties.remove("links");
        mdObject.setAdditionalProperties(additionalProperties);
        return mdObject;
    }

    private JsonNode createJsonNode(MdObjectDTO mdObject) throws IOException {
        try {
            return (JsonNode)this.mapper.readValue(this.mapper.writeValueAsString((Object)mdObject), JsonNode.class);
        }
        catch (Exception ex) {
            logger.warn("Failed to create JsonNode from object={}.", (Object)mdObject, (Object)ex);
            throw new IOException("Failed to create JsonNode from object=" + mdObject.getId() + ".");
        }
    }

    private JsonNode traverseJsonNode(JsonNode input, LinkReplacer linkReplacer) {
        Iterator fields = input.fields();
        if (input.isObject()) {
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode value = (JsonNode)field.getValue();
                if (value.isContainerNode()) {
                    this.traverseJsonNode(value, linkReplacer);
                    continue;
                }
                if (linkReplacer.isLink(value.asText())) {
                    if (((String)field.getKey()).equals("href") || linkReplacer instanceof PropertyIdentifierReplacer) continue;
                    field.setValue(new TextNode(linkReplacer.replace(value.asText())));
                    continue;
                }
                if (linkReplacer instanceof NameLinkReplacer) {
                    NameLinkReplacer nameLinkReplacer = (NameLinkReplacer)linkReplacer;
                    if (!nameLinkReplacer.getOldName().equals(((JsonNode)field.getValue()).textValue())) continue;
                    field.setValue(new TextNode(nameLinkReplacer.getNewName()));
                    continue;
                }
                if (!(linkReplacer instanceof PropertyIdentifierReplacer)) continue;
                PropertyIdentifierReplacer propertyReplacer = (PropertyIdentifierReplacer)linkReplacer;
                if (((JsonNode)field.getValue()).textValue() == null || !propertyReplacer.isPropertyIdentifier(((JsonNode)field.getValue()).textValue())) continue;
                field.setValue(new TextNode(linkReplacer.replace(value.asText())));
            }
        }
        if (input.isArray()) {
            ArrayNode array = (ArrayNode)input;
            for (int i = 0; i < array.size(); ++i) {
                JsonNode element = array.get(i);
                if (element.isContainerNode()) {
                    this.traverseJsonNode(element, linkReplacer);
                    continue;
                }
                if (!(linkReplacer instanceof PropertyIdentifierReplacer)) continue;
                PropertyIdentifierReplacer propertyReplacer = (PropertyIdentifierReplacer)linkReplacer;
                if (!(element instanceof TextNode) || !propertyReplacer.isPropertyIdentifier(element.textValue())) continue;
                array.set(i, (JsonNode)new TextNode(linkReplacer.replace(element.asText())));
            }
        }
        return input;
    }

    public MdObjectDTO replaceURILinks(MdObjectDTO mdObject, LinkReplacer linkReplacer) throws IOException {
        JsonNode replacedJsonNode = this.traverseJsonNode(this.createJsonNode(mdObject), linkReplacer);
        return (MdObjectDTO)this.mapper.readValue(replacedJsonNode.toString(), MdObjectDTO.class);
    }

    public List<MdObjectDumpDTO> replaceURIReferences(File metadataDumpPath, MdObjectDTO mdObject, NameLinkReplacer linkReplacer) throws IOException {
        List<MdObjectTypeEnum> objectWithReferences = Arrays.asList(MdObjectTypeEnum.MARKER_SELECTOR, MdObjectTypeEnum.VIEW, MdObjectTypeEnum.INDICATOR, MdObjectTypeEnum.INDICATOR_DRILL, MdObjectTypeEnum.DATASET, MdObjectTypeEnum.DASHBOARD, MdObjectTypeEnum.PROJECT_SETTINGS);
        ArrayList<MdObjectTypeEnum> objectsToLoad = new ArrayList<MdObjectTypeEnum>();
        for (MdObjectTypeEnum type : objectWithReferences) {
            if (mdObject.getType().equals((Object)type) && mdObject.getType() != MdObjectTypeEnum.DATASET) continue;
            objectsToLoad.add(type);
        }
        List allObjectTypes = this.loadMdObjectTypeDumps(metadataDumpPath, objectsToLoad);
        ArrayList<MdObjectDumpDTO> renamedReferences = new ArrayList<MdObjectDumpDTO>();
        for (MdObjectDumpDTO mdObjectDump : allObjectTypes) {
            JsonNode replacedJsonNode;
            MdObjectDTO replaced = this.replaceURILinks(mdObjectDump.getContent(), (LinkReplacer)linkReplacer);
            JsonNode original = this.createJsonNode(mdObjectDump.getContent());
            if (original.equals((Object)(replacedJsonNode = this.createJsonNode(replaced)))) continue;
            mdObjectDump.setContent(replaced);
            renamedReferences.add(mdObjectDump);
        }
        return renamedReferences;
    }
}

