/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DumpFileList;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class AddMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(AddMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public AddMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"addMetadata"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"addMetadata"}, help="Add new metadata object and upload it to the project. The file must be located in a currently opened dump, and in the correct directory.If the --objectName parameter is not specified, addMetadata will add all new objects in the current dump.")
    public void addMetadataCmd(@CliOption(key={"objectName"}, mandatory=false, help="Name of the object (with or without \".json\" extension).") String inputName) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            File metadataDumpDirectory = this.context.getMetadataDumpPath().toFile();
            List metadataFiles = FileTools.findAllMetadataInDump((File)metadataDumpDirectory);
            List unwrappedMetadataFiles = FileTools.filterWrappedMetadataFiles((List)metadataFiles);
            List newMetadataFiles = FileTools.filterFilesPresentInMd5List((ShellContext)this.context, (List)unwrappedMetadataFiles);
            String objectName = inputName;
            File foundFile = null;
            if (objectName == null) {
                if (newMetadataFiles.size() > 0) {
                    this.addAllFiles(newMetadataFiles);
                } else {
                    System.out.println("There are no new objects to add\n");
                    System.out.println("No new objects were uploaded to the project\n");
                }
            } else {
                objectName = FileTools.appendExtension((String)objectName, (String)".json");
                for (File searchedFile : metadataFiles) {
                    if (!searchedFile.getName().equals(objectName)) continue;
                    foundFile = searchedFile;
                }
                if (foundFile == null) {
                    System.out.println("Object " + FilenameUtils.removeExtension((String)objectName) + " not found in dump " + this.context.getCurrentDump() + "\n");
                    System.out.println("No new objects were uploaded to the project\n");
                } else if (newMetadataFiles.contains(foundFile)) {
                    this.addOneFile(foundFile);
                } else if (metadataFiles.contains(foundFile)) {
                    System.out.println("Object " + objectName + " was found in dump " + this.context.getCurrentDump() + ", but it's not new (it's already wrapped)\n");
                    System.out.println("No new objects were uploaded to the project\n");
                }
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void addOneFile(File file) throws IOException {
        logger.error("Adding new object {} to the project...", (Object)file.getName());
        AbstractShellClient shellClient = this.context.getShellClient();
        shellClient.addObject(this.context.getCurrentProject(), file, false);
        shellClient.putMetadataChecksumListElement(this.context, file);
        logger.error("\nObject {} successfully uploaded to project {}\n", (Object)file.getName(), (Object)this.context.getCurrentProject());
    }

    protected void addAllFiles(List<File> files) throws IOException {
        logger.error("Adding all new objects to the project...\n");
        DumpFileList fileList = new DumpFileList();
        fileList.create(files);
        if (fileList.size() != files.size()) {
            throw new CleverMapsShellException("Failed to create DumpFileList. The input and output sizes differ (" + fileList.size() + " out of " + files.size() + ").");
        }
        for (int i = 0; i < fileList.getOrder().size(); ++i) {
            List objectType = (List)fileList.getOrder().get(i);
            this.addObjects(objectType);
        }
        logger.error("\n{} new {} successfully uploaded to project {}\n", new Object[]{files.size(), files.size() == 1 ? "object has been" : "objects have been", this.context.getCurrentProject()});
    }

    private void addObjects(List<File> objects) throws IOException {
        AbstractShellClient shellClient = this.context.getShellClient();
        ArrayList<File> workingArray = new ArrayList<File>(objects);
        File latestDatasetToAdd = null;
        while (!workingArray.isEmpty()) {
            boolean iterationSuccessful = false;
            for (File datasetFile : objects) {
                try {
                    latestDatasetToAdd = datasetFile;
                    shellClient.addObject(this.context.getCurrentProject(), datasetFile, true);
                    logger.error("Added object {}", (Object)datasetFile.getName());
                    shellClient.putMetadataChecksumListElement(this.context, datasetFile);
                    workingArray.remove(datasetFile);
                    objects = new ArrayList<File>(workingArray);
                    iterationSuccessful = true;
                }
                catch (Exception exception) {}
            }
            if (iterationSuccessful) continue;
            shellClient.addObject(this.context.getCurrentProject(), latestDatasetToAdd, false);
        }
    }
}

