/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.util.UriTool;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.exception.OrganizationNotFoundException;
import com.cleveranalytics.service.project.exception.ProjectException;
import com.cleveranalytics.service.project.rest.dto.ProjectDTO;
import com.cleveranalytics.service.project.rest.dto.ProjectShare;
import com.cleveranalytics.shell.commands.connected.ListProjectsCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.inamik.text.tables.GridTable;
import com.inamik.text.tables.SimpleTable;
import com.inamik.text.tables.grid.Border;
import com.inamik.text.tables.grid.Util;
import java.util.List;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class ListProjectsCommand
implements CommandMarker {
    @Value(value="${can.service.project.serverUrl:#{null}}")
    private final String projectServerUrl;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    protected ProjectClient projectClient;
    private final ShellContext context;

    @Autowired
    public ListProjectsCommand(ShellContext context) {
        this.projectServerUrl = null;
        this.authnServerUrl = null;
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"listProjects"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null;
    }

    @CliCommand(value={"listProjects"}, help="List all projects available to you on the server.")
    public void listProjectsCmd(@CliOption(key={"verbose"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Specifies if the output should be more verbose.") boolean verbose, @CliOption(key={"share"}, mandatory=false, help="List projects by share type. Allowed values=[\"demo\", \"dimension\", \"template\"].") String share, @CliOption(key={"organization"}, mandatory=false, help="List projects by organization (organization ID).") String organization) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.authnServerUrl != null) {
                System.out.println("\nObtaining refresh token from " + this.authnServerUrl);
            }
            if (this.projectServerUrl != null) {
                System.out.println("Obtaining projects from " + this.projectServerUrl + "\n");
            }
            if (share != null) {
                try {
                    ProjectShare.fromValue((String)share);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("Invalid 'share' parameter=" + share + ". Supported values are: [\"demo\", \"dimension\", \"template\"]");
                }
            }
            this.projectClient = new ProjectClient(this.context.getCanRestClient());
            this.listProjects(this.projectClient, Boolean.valueOf(verbose), share, organization);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    public String listProjects(ProjectClient projectClient, Boolean verbose, String share, String organization) {
        GridTable gridTable = null;
        String stringTable = null;
        List projects = share != null && organization != null ? projectClient.getProjectsByShareAndOrganization(share, organization) : (organization != null ? projectClient.getProjectsByOrganization(organization) : (share != null ? projectClient.getProjectsByShare(ProjectShare.fromValue((String)share)) : projectClient.getProjects()));
        StringBuilder stringBuilder = new StringBuilder();
        if (projects.size() == 0) {
            stringBuilder.append("There are no");
            stringBuilder.append(share != null ? " " + share : "");
            stringBuilder.append(" projects");
            stringBuilder.append(organization != null ? " in organization " + organization : "");
            stringBuilder.append(" available to ");
            stringBuilder.append(this.context.getUserEmail());
            stringBuilder.append("\n");
            System.out.println(stringBuilder);
        } else {
            stringBuilder.append("Listing available");
            stringBuilder.append(share != null ? " " + share : "");
            stringBuilder.append(" projects");
            stringBuilder.append(organization != null ? " in organization " + organization : "");
            stringBuilder.append(" for ");
            stringBuilder.append(this.context.getUserEmail());
            stringBuilder.append("...\n");
            System.out.println(stringBuilder);
            projects.sort(new ProjectTitleComparator());
            gridTable = verbose != false ? this.formatVerboseProjectsGridTable(projectClient, projects) : this.formatProjectsGridTable(projectClient, projects);
            stringTable = Util.asString((GridTable)gridTable);
            System.out.println(stringTable);
        }
        return gridTable == null ? "" : stringTable;
    }

    public GridTable formatProjectsGridTable(ProjectClient projectClient, List<ProjectDTO> projects) {
        SimpleTable projectsTable = SimpleTable.of().nextRow().nextCell().addLine(this.whitespaceWrap("Project ID")).nextCell().addLine(this.whitespaceWrap("Project title")).nextCell().addLine(this.whitespaceWrap("Organization")).nextCell().addLine(this.whitespaceWrap("Role")).nextCell().addLine(this.whitespaceWrap("Share"));
        for (ProjectDTO project : projects) {
            projectsTable.nextRow().nextCell().addLine(this.whitespaceWrap(project.getId())).nextCell().addLine(this.whitespaceWrap(project.getTitle())).nextCell().addLine(this.whitespaceWrap(this.getProjectOrganizationTitle(projectClient, project.getId()))).nextCell().addLine(this.whitespaceWrap(this.getProjectRole(projectClient, project.getId()))).nextCell().addLine(this.whitespaceWrap(project.getShare().toString()).toLowerCase());
        }
        GridTable gridTable = projectsTable.toGrid();
        gridTable = Border.of((Border.Chars)Border.Chars.SINGLE_LINE).apply(gridTable);
        return gridTable;
    }

    public GridTable formatVerboseProjectsGridTable(ProjectClient projectClient, List<ProjectDTO> projects) {
        SimpleTable projectsTable = SimpleTable.of().nextRow().nextCell().addLine(this.whitespaceWrap("Project ID")).nextCell().addLine(this.whitespaceWrap("Project title")).nextCell().addLine(this.whitespaceWrap("Organization")).nextCell().addLine(this.whitespaceWrap("Role")).nextCell().addLine(this.whitespaceWrap("Description")).nextCell().addLine(this.whitespaceWrap("Status")).nextCell().addLine(this.whitespaceWrap("Created at")).nextCell().addLine(this.whitespaceWrap("Modified at")).nextCell().addLine(this.whitespaceWrap("Share"));
        for (ProjectDTO project : projects) {
            projectsTable.nextRow().nextCell().addLine(this.whitespaceWrap(project.getId())).nextCell().addLine(this.whitespaceWrap(project.getTitle())).nextCell().addLine(this.whitespaceWrap(this.getProjectOrganizationTitle(projectClient, project.getId()))).nextCell().addLine(this.whitespaceWrap(this.getProjectRole(projectClient, project.getId()))).nextCell().addLine(this.whitespaceWrap(this.processDescription(project))).nextCell().addLine(this.whitespaceWrap(project.getStatus().toString().toLowerCase())).nextCell().addLine(this.whitespaceWrap(new ISO8601DateFormat().format(project.getCreatedAt()))).nextCell().addLine(this.whitespaceWrap(new ISO8601DateFormat().format(project.getModifiedAt()))).nextCell().addLine(this.whitespaceWrap(project.getShare().toString().toLowerCase()));
        }
        GridTable gridTable = projectsTable.toGrid();
        gridTable = Border.of((Border.Chars)Border.Chars.SINGLE_LINE).apply(gridTable);
        return gridTable;
    }

    private String whitespaceWrap(String text) {
        return " " + text + " ";
    }

    private String processDescription(ProjectDTO project) {
        String desc = project.getDescription() == null ? "" : project.getDescription();
        int lengthLimit = 64;
        if (desc.length() > lengthLimit) {
            desc = desc.substring(0, lengthLimit);
            desc = desc + "...";
        }
        return desc;
    }

    private String getProjectRole(ProjectClient projectClient, String projectId) {
        try {
            return projectClient.getMembershipInProject(projectId).getRole().toString().toLowerCase();
        }
        catch (ProjectException ex) {
            if (HttpStatus.FORBIDDEN.equals((Object)ex.getStatus())) {
                return "disabled";
            }
            throw ex;
        }
    }

    private String getProjectOrganizationTitle(ProjectClient projectClient, String projectId) {
        try {
            return projectClient.getOrganizationForProject(projectId).getTitle();
        }
        catch (OrganizationNotFoundException ex) {
            return "no organization";
        }
        catch (ProjectException ex) {
            if (HttpStatus.FORBIDDEN.equals((Object)ex.getStatus())) {
                return "forbidden access";
            }
            throw ex;
        }
    }
}

