/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.exception;

import com.cleveranalytics.service.authn.rest.dto.HttpErrorDTO;
import com.cleveranalytics.service.md.rest.dto.share.ShareBreakingChange;
import com.cleveranalytics.service.md.rest.dto.share.ShareErrorDTO;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.cleveranalytics.shell.exception.ValidationViolationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.sentry.Sentry;
import io.sentry.event.UserBuilder;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShellExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShellExceptionHandler.class);
    private static ObjectMapper mapper = new MdObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void handle(Exception ex, ShellContext context) throws Exception {
        message = null;
        try {
            ShellExceptionHandler.logger.warn("Handling exception={}", (Object)ex.getClass().getCanonicalName(), (Object)ex);
            ShellExceptionHandler.logger.error("");
            message = ex instanceof HttpServerErrorException != false || ex instanceof HttpClientErrorException != false ? ShellExceptionHandler.handleHttpStatusCodeException((HttpStatusCodeException)((HttpStatusCodeException)ex)) : (ex instanceof JsonSyntaxException != false ? ShellExceptionHandler.handleJsonSyntaxException((JsonSyntaxException)((JsonSyntaxException)ex)) : (ex instanceof ValidationViolationException != false ? ShellExceptionHandler.handleValidationViolationException((ValidationViolationException)((ValidationViolationException)ex)) : (ex instanceof SQLException != false ? ShellExceptionHandler.handleSQLException((SQLException)((SQLException)ex)) : ShellExceptionHandler.handleException((Exception)ex))));
        }
        catch (IOException exc) {
            try {
                message = "Unhandled error=" + ex.getMessage();
                ShellExceptionHandler.logger.warn("Error parsing exception={}", (Object)exc.getCause(), (Object)exc);
            }
            catch (Throwable var4_4) {
                ShellExceptionHandler.logger.error(message);
                if (context.getUserEmail() != null && !context.getUserEmail().equals("ci@cleveranalytics.com") && !context.getUserEmail().equals("john@cleveranalytics.com")) {
                    ShellExceptionHandler.captureSentryEvent((ShellContext)context, (Exception)ex, (String)message);
                }
                throw var4_4;
            }
            ShellExceptionHandler.logger.error(message);
            if (context.getUserEmail() != null && !context.getUserEmail().equals("ci@cleveranalytics.com") && !context.getUserEmail().equals("john@cleveranalytics.com")) {
                ShellExceptionHandler.captureSentryEvent((ShellContext)context, (Exception)ex, (String)message);
            } else {
                ** GOTO lbl23
            }
        }
        ShellExceptionHandler.logger.error(message);
        if (context.getUserEmail() != null && !context.getUserEmail().equals("ci@cleveranalytics.com") && !context.getUserEmail().equals("john@cleveranalytics.com")) {
            ShellExceptionHandler.captureSentryEvent((ShellContext)context, (Exception)ex, (String)message);
        }
        ShellExceptionHandler.logger.error("Execution failed. Please contact support for assistance with request_id={}\n", (Object)MDC.get((String)"requestId"));
        if (context.isRethrowExceptions()) {
            throw ex;
        }
        if (context.isExitOnError()) {
            System.exit(1);
        }
    }

    private static String handleHttpStatusCodeException(HttpStatusCodeException statusException) throws IOException {
        String responseBody = statusException.getResponseBodyAsString();
        String responseBodyMessage = "";
        try {
            Map error = (Map)mapper.readValue(responseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (error.get("code") != null && error.get("code").equals(400009)) {
                ShareErrorDTO shareError = (ShareErrorDTO)mapper.readValue(responseBody, ShareErrorDTO.class);
                responseBodyMessage = ShellExceptionHandler.handleShareError((ShareErrorDTO)shareError);
            } else if (error.get("message") != null) {
                responseBodyMessage = error.get("message").toString();
            } else {
                HttpErrorDTO httpError = (HttpErrorDTO)mapper.readValue(responseBody, HttpErrorDTO.class);
                responseBodyMessage = httpError.getMessage();
            }
        }
        catch (JsonMappingException mappingException) {
            logger.warn("Error parsing status exception response body. Using empty body.");
        }
        StringBuilder fullMessage = new StringBuilder();
        if (statusException instanceof HttpServerErrorException) {
            fullMessage.append("Server error=");
        } else {
            fullMessage.append("Client error=");
        }
        fullMessage.append(statusException.getStatusCode().value());
        fullMessage.append(" - ");
        fullMessage.append(statusException.getStatusCode().getReasonPhrase());
        if (responseBody.length() > 0) {
            fullMessage.append("\n");
            fullMessage.append("Error description=");
            fullMessage.append(responseBodyMessage);
        }
        return fullMessage.toString();
    }

    private static String handleShareError(ShareErrorDTO shareError) throws IOException {
        StringBuilder shareMessage = new StringBuilder();
        shareMessage.append(shareError.getMessage());
        shareMessage.append("\n");
        List content = shareError.getContent();
        if (content != null) {
            for (int i = 0; i < content.size(); ++i) {
                ShareBreakingChange change = (ShareBreakingChange)content.get(i);
                shareMessage.append("\n\tMetadata object ID: ");
                shareMessage.append(change.getObjectId());
                shareMessage.append("\n\tShare object ID: ");
                shareMessage.append(change.getShareId());
                shareMessage.append("\n\tCreated by: ");
                shareMessage.append(change.getCreatedBy());
                shareMessage.append("\n\tCreated at: ");
                shareMessage.append(change.getCreatedAt());
                shareMessage.append("\n\tContent: ");
                shareMessage.append(mapper.writeValueAsString((Object)change.getContent()));
                shareMessage.append("\n");
                if (i < content.size() - 1) continue;
                shareMessage.append("\n");
            }
        } else {
            shareMessage.append("\n");
        }
        shareMessage.append("Use pushProject with --force parameter to override this warning and push the object.\nKeep in mind that this action will modify/damage some user's shared view(s).");
        shareMessage.append("\n");
        return shareMessage.toString();
    }

    private static String handleJsonSyntaxException(JsonSyntaxException syntaxException) {
        JsonProcessingException exception = syntaxException.getOriginalException();
        String errorFileName = syntaxException.getErrorFileName();
        if (syntaxException.getCausingCommand().equals("addMetadata")) {
            logger.error("Failed to add object {}\n", (Object)errorFileName);
        } else if (syntaxException.getCausingCommand().equals("pushProject")) {
            logger.error("Failed to push object {}\n", (Object)errorFileName);
        } else if (syntaxException.getCausingCommand().equals("diff")) {
            logger.error("Failed to create a diff of object {}\n", (Object)errorFileName);
        } else {
            throw new CleverMapsShellException("Unknown JsonSyntaxException causing command=" + syntaxException.getCausingCommand() + ".");
        }
        if (exception instanceof JsonParseException) {
            return ShellExceptionHandler.handleJsonParseException((JsonParseException)((JsonParseException)exception));
        }
        if (exception instanceof JsonMappingException) {
            if (exception.getCause() instanceof JsonParseException) {
                return ShellExceptionHandler.handleJsonParseException((JsonParseException)((JsonParseException)exception.getCause()));
            }
            return ShellExceptionHandler.handleJsonMappingException((JsonMappingException)((JsonMappingException)((Object)exception)));
        }
        throw new CleverMapsShellException("Exception thrown is not a descendant of JsonProcessingException. Failed to create the error output.");
    }

    private static String handleJsonParseException(JsonParseException exception) {
        StringBuilder fullMessage = new StringBuilder();
        int lineNumber = exception.getLocation().getLineNr();
        int columnNumber = exception.getLocation().getColumnNr();
        String detailMessage = exception.getMessage().split("\\r?\\n|\\r")[0];
        fullMessage.append("General error=JSON syntax error at line: ");
        fullMessage.append(String.valueOf(lineNumber));
        fullMessage.append(", column: ");
        fullMessage.append(String.valueOf(columnNumber));
        fullMessage.append("\n");
        fullMessage.append("Error description=");
        fullMessage.append(ShellExceptionHandler.simplifyDetailMessage((String)detailMessage));
        return fullMessage.toString();
    }

    private static String handleJsonMappingException(JsonMappingException exception) {
        StringBuilder path = new StringBuilder("$");
        if (exception.getPath().size() == 0) {
            path.append(" (object root)");
        } else {
            path.append(".");
            for (int i = 0; i < exception.getPath().size(); ++i) {
                JsonMappingException.Reference reference = (JsonMappingException.Reference)exception.getPath().get(i);
                if (reference.getFieldName() == null) {
                    path.append(reference.getIndex());
                } else {
                    path.append(reference.getFieldName());
                }
                if (i >= exception.getPath().size() - 1) continue;
                path.append(".");
            }
        }
        StringBuilder fullMessage = new StringBuilder();
        if (exception.getLocation() != null) {
            int lineNumber = exception.getLocation().getLineNr();
            int columnNumber = exception.getLocation().getColumnNr();
            fullMessage.append("General error=JSON syntax error at line: ");
            fullMessage.append(String.valueOf(lineNumber));
            fullMessage.append(", column: ");
            fullMessage.append(String.valueOf(columnNumber));
            fullMessage.append(", path: ");
            fullMessage.append(path.toString());
        } else {
            fullMessage.append("General error=JSON syntax error at path: ");
            fullMessage.append((CharSequence)path);
        }
        fullMessage.append("\n");
        fullMessage.append("Error description=");
        String detailMessage = exception.getMessage().split("\\r?\\n|\\r")[0];
        fullMessage.append(ShellExceptionHandler.simplifyDetailMessage((String)detailMessage));
        return fullMessage.toString();
    }

    private static String simplifyDetailMessage(String message) {
        message = message.replace("(for ARRAY starting at [Source: {", "");
        message = message.split("\\(for class")[0];
        message = message.split("\\(through")[0];
        return message;
    }

    private static String handleValidationViolationException(ValidationViolationException exception) {
        ConstraintViolation[] violationArray;
        StringBuilder fullMessage = new StringBuilder();
        Set violationSet = exception.violations;
        for (ConstraintViolation violation : violationArray = violationSet.toArray(new ConstraintViolation[violationSet.size()])) {
            fullMessage.append("General error=Field '");
            fullMessage.append(violation.getPropertyPath());
            fullMessage.append("' of object name=");
            fullMessage.append(exception.fileName);
            fullMessage.append(" ");
            fullMessage.append(violation.getMessage());
            fullMessage.append("\n");
        }
        return fullMessage.toString();
    }

    private static String handleSQLException(SQLException exception) {
        return "General error=" + exception.getMessage() + " (SQL state " + exception.getSQLState() + ")";
    }

    private static String handleException(Exception exception) {
        String message = exception.getMessage();
        String fullMessage = "General error=" + exception.getMessage();
        if (message != null && message.contains("invalid byte sequence")) {
            fullMessage = fullMessage + "\n\nHINT: If this error persists you can bypass by using loadCsv or pushProject with the '--gzip false' parameter.";
        }
        return fullMessage;
    }

    public static void captureSentryEvent(ShellContext context, Exception ex, String message) {
        String userAgent;
        String version = null;
        if (context.getCanRestClient() != null && (userAgent = context.getCanRestClient().getUserAgent()).split("/").length > 2) {
            version = userAgent.split("/")[2];
        }
        Sentry.getContext().setUser(new UserBuilder().setUsername(context.getUserEmail()).build());
        Sentry.getContext().addTag("project_id", context.getCurrentProject());
        Sentry.getContext().addTag("exception", ex.getClass().getSimpleName());
        Sentry.getContext().addTag("user", context.getUserEmail());
        Sentry.getContext().addTag("version", version);
        Sentry.getContext().addTag("running_in_docker", context.isRunningInDocker() ? "true" : "false");
        Sentry.getContext().addExtra("server", (Object)context.getConnectedServer());
        Sentry.getContext().addExtra("project_id", (Object)context.getCurrentProject());
        Sentry.getContext().addExtra("project_title", (Object)context.getProjectTitle());
        Sentry.getContext().addExtra("user", (Object)context.getUserEmail());
        Sentry.getContext().addExtra("version", (Object)version);
        Sentry.getContext().addExtra("dump_directory", (Object)context.getDumpDirectory());
        Sentry.getContext().addExtra("dump_id", (Object)context.getCurrentDump());
        Sentry.getContext().addExtra("exit_on_error", (Object)context.isExitOnError());
        Sentry.getContext().addExtra("incompatible_version", (Object)context.isIncompatibleVersion());
        Sentry.getContext().addExtra("running_in_docker", (Object)context.isRunningInDocker());
        Sentry.getContext().addExtra("request_id", (Object)MDC.get((String)"requestId"));
        Sentry.getContext().addExtra("exception", (Object)ex.getClass().getName());
        Sentry.getContext().addExtra("stack_trace", (Object)ex.getStackTrace());
        Sentry.capture((String)message);
    }
}

