/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell;

import com.cleveranalytics.shell.CmJLineShellComponent;
import com.cleveranalytics.shell.config.ShellContext;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.shell.Bootstrap;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.util.StopWatch;
import sun.misc.Signal;
import sun.misc.SignalHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class ShellApplication {
    static final Logger logger = LoggerFactory.getLogger(ShellApplication.class);
    private static Bootstrap bootstrap;
    private static Options options;
    private static final String CMDFILE_ARG = "--cmdfile";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ParseException {
        ExitShellRequest exitShellRequest;
        CommandLine cmd = new DefaultParser().parse(options, args, true);
        List argsList = cmd.getArgList();
        try {
            bootstrap = new Bootstrap(args);
            ShellApplication.startStopWatch();
            ShellApplication.ignoreSigint();
            ApplicationContext context = bootstrap.getApplicationContext();
            ShellContext shellContext = (ShellContext)context.getBean("shellContext");
            shellContext.setExitOnError(argsList.contains("--cmdfile"));
            shellContext.setRunningInDocker(ShellApplication.isRunningInsideDocker().booleanValue());
            ShellApplication.registerShellBean();
            exitShellRequest = bootstrap.run();
        }
        catch (RuntimeException ex) {
            exitShellRequest = ExitShellRequest.FATAL_EXIT;
            if (!(ex instanceof IllegalStateException)) {
                throw ex;
            }
        }
        finally {
            HandlerUtils.flushAllHandlers((java.util.logging.Logger)java.util.logging.Logger.getLogger(""));
        }
        System.exit(exitShellRequest.getExitCode());
    }

    private static void startStopWatch() {
        try {
            Field field = bootstrap.getClass().getDeclaredField("sw");
            field.setAccessible(true);
            StopWatch sw = (StopWatch)field.get(bootstrap);
            sw.start();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            logger.error("internal error in spring shell", (Throwable)ex);
        }
    }

    private static void ignoreSigint() {
        Signal.handle(new Signal("INT"), (SignalHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void registerShellBean() throws BeanDefinitionStoreException {
        GenericApplicationContext gac = (GenericApplicationContext)bootstrap.getApplicationContext();
        DefaultListableBeanFactory bf = (DefaultListableBeanFactory)gac.getBeanFactory();
        RootBeanDefinition rbd = new RootBeanDefinition();
        rbd.setBeanClass(CmJLineShellComponent.class);
        bf.registerBeanDefinition("shell", (BeanDefinition)rbd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean isRunningInsideDocker() {
        try (Stream<String> stream = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));){
            Boolean bl = stream.anyMatch(line -> line.contains("/docker"));
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        options = new Options();
    }
}

