/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.authn.client.GeneratedTokenClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class DeleteProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(DeleteProjectCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public DeleteProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"deleteProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null;
    }

    @CliCommand(value={"deleteProject"}, help="Delete a project.")
    public void deleteCmd(@CliOption(key={"project"}, mandatory=true, help="ID of the project to be deleted.") String projectId) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            logger.error("Deleting project {}...", (Object)projectId);
            this.deleteProject(projectId);
            logger.error("\nProject deleted successfully\n");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void deleteProject(String projectId) {
        try {
            CanRestClient client = this.context.getCanRestClient();
            if (client instanceof UserCredentialsCanRestClient) {
                ((UserCredentialsCanRestClient)client).refreshAccessToken();
            } else if (client instanceof GeneratedTokenClient) {
                ((GeneratedTokenClient)client).authenticate(this.context.getAccessToken());
            }
            ProjectClient projectClient = new ProjectClient(client);
            projectClient.getProject(projectId);
            projectClient.deleteProject(projectId);
        }
        catch (HttpClientErrorException ex) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "Project id=" + projectId + " not found on server=" + this.context.getConnectedServer());
        }
    }
}

