/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.login;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.config.ShellConfig;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class SetupCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(SetupCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    private ShellContext context;

    @Autowired
    public SetupCommand(ShellContext context) {
        this.serviceName = null;
        this.authnServerUrl = null;
        this.context = context;
    }

    @CliCommand(value={"setup"}, help="Set your Shell credentials and configuration.")
    public void setupCmd(@CliOption(key={"email"}, mandatory=false, help="Your email account.", specifiedDefaultValue="") String email, @CliOption(key={"password"}, mandatory=false, help="Your password.", specifiedDefaultValue="") String password, @CliOption(key={"server"}, mandatory=false, help="Server to connect to.", specifiedDefaultValue="") String server, @CliOption(key={"proxyHost"}, mandatory=false, help="Hostname of the proxy server.", specifiedDefaultValue="") String proxyHost, @CliOption(key={"proxyPort"}, mandatory=false, help="Proxy server port number.", specifiedDefaultValue="") String proxyPort, @CliOption(key={"dumpDirectory"}, mandatory=false, help="Directory to store project dumps.", specifiedDefaultValue="") String dumpDirectory, @CliOption(key={"s3AccessKeyId"}, mandatory=false, help="AWS S3 Access Key ID.", specifiedDefaultValue="") String s3AccessKeyId, @CliOption(key={"s3SecretAccessKey"}, mandatory=false, help="AWS S3 Secret Access Key.", specifiedDefaultValue="") String s3SecretAccessKey) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (email == null && password == null && server == null && proxyHost == null && proxyPort == null && dumpDirectory == null && s3AccessKeyId == null && s3SecretAccessKey == null) {
                System.out.println("Please at least one option (--email, --password, --server, --proxyHost, --proxyPort, --dumpDirectory, --s3AccessKeyId, --s3SecretAccessKey) for this command\n");
                return;
            }
            Path directoryPath = Paths.get(System.getProperty("user.home"), ".cleverMaps");
            Path credentialsPath = Paths.get(System.getProperty("user.home"), ".cleverMaps", "credentials.txt");
            Path configPath = Paths.get(System.getProperty("user.home"), ".cleverMaps", "config.txt");
            if (!directoryPath.toFile().exists()) {
                Files.createDirectory(directoryPath, new FileAttribute[0]);
                System.out.println("Created CleverMaps Shell directory: " + directoryPath);
            }
            if (!credentialsPath.toFile().exists()) {
                Files.createFile(credentialsPath, new FileAttribute[0]);
                System.out.println("Created credentials file: " + configPath);
            }
            if (!configPath.toFile().exists()) {
                Files.createFile(configPath, new FileAttribute[0]);
                System.out.println("Created config file: " + configPath);
            }
            ShellConfig credentials = new ShellConfig();
            FileTools.loadProperties((ShellConfig)credentials, (File)credentialsPath.toFile());
            credentials.setEmail(email);
            credentials.setPassword(password);
            FileTools.saveProperties((ShellConfig)credentials, (File)credentialsPath.toFile());
            ShellConfig config = new ShellConfig();
            FileTools.loadProperties((ShellConfig)config, (File)configPath.toFile());
            config.setServer(server);
            config.setProxyHost(proxyHost);
            config.setProxyPort(Integer.valueOf(proxyPort == null || proxyPort.equals("") ? 0 : Integer.parseInt(proxyPort)));
            config.setDumpDirectory(dumpDirectory);
            config.setS3AccessKeyId(s3AccessKeyId);
            config.setS3SecretAccessKey(s3SecretAccessKey);
            FileTools.saveProperties((ShellConfig)config, (File)configPath.toFile());
            System.out.println("\nConfig and credentials saved successfully to " + directoryPath + " \n");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }
}

