/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetTypeEnum;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class DumpCsvCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(DumpCsvCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public DumpCsvCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"dumpCsv"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"dumpCsv"}, help="Dump DWH data of one dataset to a CSV file.")
    public void dumpCsvCmd(@CliOption(key={"dataset"}, mandatory=true, help="Name of the dataset to dump.") String datasetName, @CliOption(key={"directory"}, mandatory=false, help="Path to a dump directory, where the project will be saved in a defined directory structure.") String directory) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            File shellDirectory = DumpProjectCommand.createShellDirectory((String)directory, (ShellContext)this.context);
            File dumpDirectory = DumpProjectCommand.createDumpDirectory((File)shellDirectory, (ShellContext)this.context, (boolean)true);
            DumpProjectCommand.createDataDumpDirectory((File)dumpDirectory, (ShellContext)this.context);
            DumpProjectCommand.createMetadataDumpDirectory((File)dumpDirectory, (ShellContext)this.context);
            logger.error("");
            AbstractShellClient shellClient = this.context.getShellClient();
            shellClient.createMetadataDumpFile(this.context);
            this.dumpDataset(datasetName);
            logger.error("\nDump {} opened and set as current\n", (Object)this.context.getCurrentDump());
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private void dumpDataset(String datasetName) throws IOException {
        MdDatasetClient datasetClient = this.context.getDatasetClient();
        DatasetDTO dataset = datasetClient.getDatasetByName(this.context.getCurrentProject(), datasetName);
        if (!dataset.getRef().getType().equals(DatasetTypeEnum.DWH_TYPE.toString())) {
            throw new IllegalArgumentException("Dataset " + datasetName + " is not of DWH type, it's data cannot be dumped.");
        }
        ArrayList<DatasetDTO> oneDataset = new ArrayList<DatasetDTO>();
        oneDataset.add(dataset);
        DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
        dwhShellClient.dumpData(this.context, oneDataset, false);
    }
}

