/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class OpenDumpCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(OpenDumpCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public OpenDumpCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"openDump"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"openDump"}, help="Set a dump as current (e.g. working directory).")
    public void openDumpCmd(@CliOption(key={"dump"}, mandatory=false, help="ID of a project dump. E.g. 2019-01-01_12-00-00.") String dumpId, @CliOption(key={"directory"}, mandatory=false, help="Path to a shell directory, where the dumps are located. E.g. /var/local/can-shell.") String inputDirectory) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            File shellDirectory = DumpProjectCommand.createShellDirectory((String)inputDirectory, (ShellContext)this.context);
            File projectDirectory = DumpProjectCommand.createProjectDirectory((File)shellDirectory, (ShellContext)this.context);
            this.openMetadataDump(projectDirectory, dumpId);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void openMetadataDump(File projectDirectory, String dumpId) throws Exception {
        File dumpDirectory;
        if (dumpId == null) {
            dumpId = this.findLatestDump(projectDirectory);
        }
        if (!(dumpDirectory = Paths.get(projectDirectory.getAbsolutePath(), dumpId).toFile()).exists()) {
            throw new FileNotFoundException("Dump=" + dumpId + " not found in directory " + this.context.getProjectPath() + ".");
        }
        this.context.setCurrentDump(dumpId);
        System.out.println("Dump " + dumpId + " opened and set as current");
        System.out.println("Full path: " + this.context.getDumpPath() + "\n");
    }

    protected String findLatestDump(File projectDirectory) throws Exception {
        ArrayList<File> dumpFolders = new ArrayList<File>();
        try {
            File[] subdirectories = projectDirectory.listFiles();
            if (subdirectories != null) {
                for (File dump : subdirectories) {
                    if (!FileTools.isValidDumpDirectory((File)dump)) continue;
                    dumpFolders.add(dump);
                }
            }
            DateFormat directoryDateFormat = FileTools.DUMP_ID_FORMAT;
            Date lastDumpDate = directoryDateFormat.parse(((File)dumpFolders.get(0)).getName());
            for (File dump : dumpFolders) {
                Date date = directoryDateFormat.parse(dump.getName());
                if (date.compareTo(lastDumpDate) < 0) continue;
                lastDumpDate = date;
            }
            return directoryDateFormat.format(lastDumpDate);
        }
        catch (Exception ex) {
            if (ex instanceof IndexOutOfBoundsException) {
                throw new CleverMapsShellException("No valid dump directories found in: " + projectDirectory.getAbsolutePath() + ", please make a dump first.");
            }
            throw ex;
        }
    }
}

