/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdFileList;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.BannerProvider;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StringUtils;

@Component
public class RemoveMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(RemoveMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public RemoveMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"removeMetadata"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"removeMetadata"}, help="Remove metadata object from the server and current dump.")
    public void removeMetadataCmd(@CliOption(key={"objectName"}, mandatory=false, help="Name of the metadata object to be removed from the server and the current dump (with or without \".json\" extension).") String objectName, @CliOption(key={"objectId"}, mandatory=false, help="ID of the metadata object to be removed from the server and the current dump.") String objectId) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (StringUtils.hasText((String)objectName) && StringUtils.hasText((String)objectId)) {
                System.out.println(BannerProvider.ANSI_MAGENTA + "You can specify either --objectName or --objectId option, but not both" + BannerProvider.ANSI_RESET);
                return;
            }
            if (StringUtils.hasText((String)objectName)) {
                this.removeObjectByName(objectName);
            } else if (StringUtils.hasText((String)objectId)) {
                this.removeObjectById(objectId);
            } else {
                System.out.println(BannerProvider.ANSI_MAGENTA + "You must specify either --objectName or --objectId option" + BannerProvider.ANSI_RESET);
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void removeObjectByName(String objectName) throws IOException {
        logger.error("Removing object {} from project {}...\n", (Object)objectName, (Object)this.context.getCurrentProject());
        String nameWithExt = FileTools.appendExtension((String)objectName, (String)".json");
        String nameWithoutExt = FilenameUtils.removeExtension((String)objectName);
        AbstractShellClient shellClient = this.context.getShellClient();
        MdFileList fileList = shellClient.getObjectsList(this.context);
        String objectType = fileList.contains(nameWithoutExt);
        if (objectType != null) {
            shellClient.removeObjectByName(this.context, objectType, objectName);
            logger.error("Remote object {} successfully deleted from the project", (Object)nameWithoutExt);
            this.removeObjectLocally(nameWithoutExt);
            File file = Paths.get(this.context.getMetadataDumpPath().toString(), objectType, nameWithExt).toFile();
            shellClient.removeMetadataChecksumListElement(this.context, file);
        } else {
            logger.error("Object {} not found in the project, no local files were deleted\n", (Object)objectName);
        }
    }

    protected void removeObjectById(String objectId) throws IOException {
        logger.error("Removing object {} from project {}...\n", (Object)objectId, (Object)this.context.getCurrentProject());
        ArrayList<MdObjectDTO> objectsToDelete = new ArrayList<MdObjectDTO>();
        List metadataFiles = FileTools.findAllMetadataInDump((File)this.context.getMetadataDumpPath().toFile());
        for (File metadataFile : metadataFiles) {
            MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)metadataFile);
            if (!mdObjectDump.getContent().getId().equals(objectId)) continue;
            objectsToDelete.add(mdObjectDump.getContent());
        }
        AbstractShellClient shellClient = this.context.getShellClient();
        for (MdObjectDTO mdObject : objectsToDelete) {
            shellClient.removeObjectById(this.context.getCurrentProject(), mdObject.getType().toStringPlural(), objectId);
            logger.error("Remote object with id {} successfully deleted from the project", (Object)objectId);
            this.removeObjectLocally(mdObject.getName());
            File file = Paths.get(this.context.getMetadataDumpPath().toString(), mdObject.getType().toStringPlural(), mdObject.getName()).toFile();
            shellClient.removeMetadataChecksumListElement(this.context, file);
        }
    }

    protected void removeObjectLocally(String objectName) throws IOException {
        File fileToDelete = FileTools.findMetadataInDump((ShellContext)this.context, (String)objectName);
        if (fileToDelete != null && fileToDelete.exists()) {
            FileSystemUtils.deleteRecursively((File)fileToDelete);
            if (!fileToDelete.exists()) {
                logger.error("Local file {} successfully deleted\n", (Object)fileToDelete.getName());
            } else {
                logger.error("Failed to delete local file {}\n", (Object)fileToDelete.getName());
            }
        } else {
            logger.error("File {} was not found in dump {}\n", (Object)objectName, (Object)this.context.getCurrentDump());
        }
    }
}

