/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.shell.client.LinkReplacer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyIdentifierReplacer
extends LinkReplacer {
    private final Pattern propertyIdentifierPattern = Pattern.compile("^[a-z][a-z0-9_-]*\\.[a-z][a-z0-9_-]*$");
    private String prefix;
    private String objectName;

    public PropertyIdentifierReplacer(String prefix, String objectName) {
        this.prefix = prefix;
        this.objectName = objectName;
    }

    public String replace(String input) {
        Matcher matcher;
        String replaced = null;
        if (input != null && input.equals(replaced = (matcher = this.propertyIdentifierPattern.matcher(input)).replaceFirst(this.prefix + input))) {
            System.out.println("\nWarning: failed to prefix dataset property=" + input + " of object=" + this.objectName);
        }
        return replaced;
    }

    public boolean isPropertyIdentifier(String input) {
        return this.propertyIdentifierPattern.matcher(input).matches();
    }
}

