/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdFileList;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;

@Component
public class RemoveMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(RemoveMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public RemoveMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"removeMetadata"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"removeMetadata"}, help="Remove metadata object from the server and current dump.")
    public void removeMetadataCmd(@CliOption(key={"objectName"}, mandatory=true, help="Name of the metadata object to be removed from the server and the current dump (with or without \".json\" extension).") String inputName) throws Exception {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            this.removeObject(inputName);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected void removeObject(String nameInput) throws IOException {
        logger.error("Removing object {} from project {}...\n", (Object)nameInput, (Object)this.context.getCurrentProject());
        String nameWithExt = FileTools.appendExtension((String)nameInput, (String)".json");
        String nameWithoutExt = FilenameUtils.removeExtension((String)nameInput);
        AbstractShellClient shellClient = this.context.getShellClient();
        MdFileList fileList = shellClient.getObjectsList(this.context);
        String objectType = fileList.contains(nameWithoutExt);
        if (objectType != null) {
            this.removeObjectRemotely(shellClient, nameWithoutExt, objectType);
            this.removeObjectLocally(nameWithoutExt);
            File file = Paths.get(this.context.getMetadataDumpPath().toString(), objectType, nameWithExt).toFile();
            shellClient.removeMetadataChecksumListElement(this.context, file);
        } else {
            logger.error("Object {} not found in the project, no local files were deleted\n", (Object)nameInput);
        }
    }

    protected void removeObjectLocally(String objectName) throws IOException {
        File fileToDelete = FileTools.findMetadataInDump((ShellContext)this.context, (String)objectName);
        if (fileToDelete != null && fileToDelete.exists()) {
            FileSystemUtils.deleteRecursively((File)fileToDelete);
            if (!fileToDelete.exists()) {
                logger.error("Local file {} successfully deleted\n", (Object)fileToDelete.getName());
            } else {
                logger.error("Failed to delete local file {}\n", (Object)fileToDelete.getName());
            }
        } else {
            logger.error("File {} was not found in dump {}\n", (Object)objectName, (Object)this.context.getCurrentDump());
        }
    }

    protected void removeObjectRemotely(AbstractShellClient shellClient, String objectName, String type) throws IOException {
        shellClient.removeObject(this.context.getCurrentProject(), type, objectName);
        logger.error("Remote object {} successfully deleted from the project", (Object)FilenameUtils.removeExtension((String)objectName));
    }
}

