/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.dwh.rest.dto.CsvOptions;
import com.cleveranalytics.service.dwh.rest.dto.DataPullMode;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class LoadCsvCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(LoadCsvCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public LoadCsvCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"loadCsv"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"loadCsv"}, help="Load CSV file into existing CleverMaps dataset.")
    public void loadCsvCmd(@CliOption(key={"dataset"}, mandatory=true, help="Name of the dataset where the data will be loaded.") String datasetName, @CliOption(key={"file"}, mandatory=true, help="Path to a CSV file to be loaded. If a dump is opened and contains some CSV files, file can be specified by using just the filename ('restaurants.csv') instead of full path.") String file, @CliOption(key={"mode"}, mandatory=true, help="Data load mode. Allowed values=[\"full\", \"incremental\"].") String mode, @CliOption(key={"csvHeader"}, mandatory=false, help="Specifies if the CSV file has a header.") Boolean csvHeader, @CliOption(key={"csvSeparator"}, mandatory=false, help="Specifies the CSV column separator character.") Character csvSeparator, @CliOption(key={"csvQuote"}, mandatory=false, help="Specifies the CSV quote character.") Character csvQuote, @CliOption(key={"csvEscape"}, mandatory=false, help="Specifies the CSV escape character.") Character csvEscape, @CliOption(key={"csvNull"}, mandatory=false, help="Specifies the replacement of custom CSV null values.") String csvNull, @CliOption(key={"csvForceNull"}, mandatory=false, help="Specifies which CSV columns should enforce the null replacement.") String[] csvForceNull, @CliOption(key={"verbose"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Verbose option for more detailed output.") boolean verbose, @CliOption(key={"multipart"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Use multipart file upload.") boolean multipart, @CliOption(key={"gzip"}, mandatory=false, unspecifiedDefaultValue="true", help="Enable or disable gzip compression.") boolean gzip) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (multipart && !gzip) {
                logger.error("The combination of --multipart and --gzip false is currently not supported\n");
                return;
            }
            logger.error("Asynchronous data upload started...\n");
            CsvOptions csvOptions = this.parseCsvOptions(csvHeader, csvSeparator, csvQuote, csvEscape, csvNull, csvForceNull);
            this.loadData(file, datasetName, this.convertDataPullRequestMode(mode), csvOptions, verbose, multipart, gzip);
            logger.error("");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private CsvOptions parseCsvOptions(Boolean csvHeader, Character csvSeparator, Character csvQuote, Character csvEscape, String csvNull, String[] csvForceNull) {
        CsvOptions csvOptions = new CsvOptions();
        csvOptions.setHeader(csvHeader);
        csvOptions.setSeparator(csvSeparator);
        csvOptions.setQuote(csvQuote);
        csvOptions.setEscape(csvEscape);
        csvOptions.setNull(csvNull);
        if (csvForceNull == null) {
            csvOptions.setForceNull(null);
        } else {
            csvOptions.setForceNull(Arrays.asList(csvForceNull));
        }
        return csvOptions;
    }

    public void loadData(String csvName, String datasetName, DataPullMode mode, CsvOptions csvOptions, boolean verbose, boolean multipart, boolean gzip) throws IOException {
        File csvFile = FileTools.findDataInDump((ShellContext)this.context, (String)csvName);
        if (csvFile == null || !csvFile.exists() || !csvFile.canRead()) {
            csvFile = FileTools.getCsvFileFromPath((String)csvName);
        }
        DwhShellClient dwhShellClient = new DwhShellClient(this.context.getCanRestClient(), this.context.getProxyHost(), this.context.getProxyPort());
        if (multipart) {
            if (csvFile.length() > 0x3200000L) {
                dwhShellClient.performMultipartLoad(this.context, csvFile, datasetName, mode, csvOptions, verbose, gzip);
            } else {
                logger.error("File size of CSV file=" + csvName + " is less than 50 MB, using regular upload.\n");
                dwhShellClient.performLoad(this.context, csvFile, datasetName, mode, csvOptions, verbose, gzip);
            }
        } else {
            dwhShellClient.performLoad(this.context, csvFile, datasetName, mode, csvOptions, verbose, gzip);
        }
        if (this.context.getCurrentDump() != null) {
            this.fetchUpdatedDataset(datasetName);
        }
    }

    private void fetchUpdatedDataset(String datasetName) {
        MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
        MdDatasetClient datasetClient = this.context.getDatasetClient();
        try {
            DatasetDTO updatedDataset = datasetClient.getDatasetByName(this.context.getCurrentProject(), datasetName);
            shellClient.wrapAndSaveMdObject(this.context, (MdObjectDTO)updatedDataset);
        }
        catch (Exception ex) {
            logger.error("Failed to fetch a new version of dataset name={}.", (Object)datasetName);
        }
    }

    protected DataPullMode convertDataPullRequestMode(String mode) throws IllegalArgumentException {
        try {
            return DataPullMode.fromValue((String)mode);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid 'mode' parameter=" + mode + ". Supported values are=" + Arrays.toString(DataPullMode.values()) + ".");
        }
    }
}

