/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.connected;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.ProjectDTO;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class OpenProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(OpenProjectCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    @Value(value="${can.service.project.serverUrl:#{null}}")
    private final String projectServerUrl;
    @Value(value="${can.service.authn.serverUrl:#{null}}")
    private final String authnServerUrl;
    protected ProjectClient projectClient;
    private ShellContext context;

    @Autowired
    public OpenProjectCommand(ShellContext context) {
        this.serviceName = null;
        this.projectServerUrl = null;
        this.authnServerUrl = null;
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"openProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null;
    }

    @CliCommand(value={"openProject"}, help="Open a project and set as current.")
    public void openProjectCmd(@CliOption(key={"project"}, mandatory=true, help="ProjectId of CleverMaps project which will be opened to be managed.") String projectId) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            ProjectDTO projectDTO = this.openProject(projectId);
            System.out.println("Project " + projectId + " (" + projectDTO.getTitle() + ") successfully opened\n");
            if (this.context.getCurrentProject() != null) {
                this.context.setCurrentDump(null);
            }
            this.context.setCurrentProject(projectId);
            this.context.setProjectTitle(projectDTO.getTitle());
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    protected ProjectDTO openProject(String projectId) throws HttpClientErrorException {
        ProjectDTO projectDTO;
        try {
            this.projectClient = new ProjectClient(this.context.getCanRestClient());
            projectDTO = this.projectClient.getProject(projectId);
        }
        catch (HttpClientErrorException ex) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "Project id=" + projectId + " not found on server=" + this.context.getConnectedServer());
        }
        return projectDTO;
    }
}

