/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.config;

import com.cleveranalytics.shell.config.ShellContext;
import org.fusesource.jansi.Ansi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultPromptProvider;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class PromptProvider
extends DefaultPromptProvider {
    private ShellContext context;
    public static final Ansi ANSI_CYAN = Ansi.ansi().fg(Ansi.Color.CYAN);
    public static final Ansi ANSI_RESET = Ansi.ansi().reset();

    @Autowired
    public PromptProvider(ShellContext context) {
        this.context = context;
    }

    public String getPrompt() {
        StringBuilder prompt = new StringBuilder();
        if (this.context.getUserEmail() != null && this.context.getConnectedServer() != null) {
            prompt.append(ANSI_CYAN);
            prompt.append(this.context.getUsername());
            prompt.append("@");
            prompt.append(this.context.getConnectedServerRelativeUrl());
            if (this.context.getProxyHost() != null) {
                prompt.append("->");
                prompt.append(this.context.getProxyHost());
                prompt.append(":");
                prompt.append(this.context.getProxyPort());
            }
            if (this.context.getCurrentProject() != null) {
                prompt.append("/project:");
                prompt.append(this.context.getCurrentProject());
            }
            if (this.context.getCurrentDump() != null) {
                prompt.append("/dump:");
                prompt.append(this.context.getCurrentDump());
            }
            prompt.append("$ ");
            prompt.append(ANSI_RESET);
            return prompt.toString();
        }
        return ANSI_CYAN + "CleverMaps$ " + ANSI_RESET;
    }

    public String getProviderName() {
        return "CleverMaps";
    }
}

