/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.GenerateDatasetRequestDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.jdbc.JdbcShellClient;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.ShellException;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class ImportDatabaseCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(ImportDatabaseCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    private ShellContext context;
    private DumpProjectCommand dumpProjectCommand;

    @Autowired
    public ImportDatabaseCommand(ShellContext context, DumpProjectCommand dumpProjectCommand) {
        this.serviceName = null;
        this.context = context;
        this.dumpProjectCommand = dumpProjectCommand;
    }

    @CliAvailabilityIndicator(value={"importDatabase"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"importDatabase"}, help="Import a database using JDBC driver.")
    public void openDatabaseCmd(@CliOption(key={"engine"}, mandatory=true, help="Name of the database engine. Currently supported=[postgresql].") String engine, @CliOption(key={"host"}, mandatory=true, help="Database server hostname. For local databases use 'localhost'.") String host, @CliOption(key={"port"}, mandatory=true, help="Database server port.") String port, @CliOption(key={"database"}, mandatory=true, help="Name of the database.") String database, @CliOption(key={"user"}, mandatory=true, help="User name for login to the database.") String user, @CliOption(key={"password"}, mandatory=true, help="User's password.") String password, @CliOption(key={"schema"}, mandatory=false, help="Name of the database schema.") String schema, @CliOption(key={"tables"}, mandatory=false, help="List of tables to import.") String[] inputTablesArray, @CliOption(key={"skipData"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip data import.") boolean skipData, @CliOption(key={"skipMetadata"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip metadata import.") boolean skipMetadata) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.context.getCurrentDump() == null) {
                logger.error("No dump of project {} opened, making a dump first...\n", (Object)this.context.getCurrentProject());
                this.dumpProjectCommand.dumpProject(null, true, false, false, true, true);
            }
            JdbcShellClient jdbcShellClient = null;
            try {
                List tablesToImport;
                String url = this.constructUrl(engine, host, port, database);
                jdbcShellClient = schema == null ? new JdbcShellClient(url, user, password) : new JdbcShellClient(url, schema, user, password);
                if (inputTablesArray == null || inputTablesArray.length == 0) {
                    tablesToImport = jdbcShellClient.getAllTables();
                } else {
                    List<String> inputTables = Arrays.asList(inputTablesArray);
                    tablesToImport = jdbcShellClient.getTables(inputTables);
                }
                logger.error("Import of {} database tables started...\n", (Object)tablesToImport.size());
                List requests = jdbcShellClient.generateDatasetRequests(tablesToImport);
                if (!skipMetadata) {
                    this.importMetadata(requests);
                }
                if (!skipData) {
                    this.importData(requests, jdbcShellClient);
                }
                this.printImportMessage(url, this.context.getCurrentProject(), this.context.getProjectTitle(), skipMetadata ? 0 : requests.size(), skipData ? 0 : requests.size());
            }
            finally {
                if (jdbcShellClient != null) {
                    jdbcShellClient.closeConnection();
                }
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private void importMetadata(List<GenerateDatasetRequestDTO> requests) throws IOException {
        MdShellClient mdShellClient = (MdShellClient)this.context.getShellClient();
        for (GenerateDatasetRequestDTO request : requests) {
            DatasetDTO generatedDataset = mdShellClient.generateDataset(this.context.getCurrentProject(), request);
            Path path = Paths.get(this.context.getMetadataDumpPath().toString(), "datasets", request.getTableName());
            FileTools.saveObjectToJson((Object)generatedDataset, (String)path.toString());
            logger.error("Created dataset " + request.getTableName() + ".json");
        }
        logger.error("");
    }

    private void importData(List<GenerateDatasetRequestDTO> requests, JdbcShellClient jdbcShellClient) throws IOException {
        for (GenerateDatasetRequestDTO request : requests) {
            Path path = Paths.get(this.context.getDataDumpPath().toString(), request.getTableName());
            jdbcShellClient.dumpDataToCsv(request.getTableName(), path.toString() + ".csv");
            logger.error("Created CSV file " + request.getTableName() + ".csv");
        }
        logger.error("");
    }

    private void printImportMessage(String databaseUrl, String destinationProjectId, String destinationProjectTitle, int importedDatasets, int importedCsvs) {
        logger.error("\nImport finished!");
        logger.error("Imported database URL: {}", (Object)databaseUrl);
        logger.error("Destination project: {} ({})", (Object)destinationProjectId, (Object)destinationProjectTitle);
        logger.error("Imported datasets: {}", (Object)importedDatasets);
        logger.error("Imported CSV files: {}", (Object)importedCsvs);
        logger.error("\nTo view detailed imported content, use status command.");
        logger.error("Now you can make changes, or import another database.");
        if (importedDatasets > 0) {
            logger.error("When you're done, use addMetadata command to add the metadata to the project.");
        }
        if (importedCsvs > 0) {
            logger.error("To push the data to the project, use pushProject command.");
        }
        logger.error("");
    }

    private String constructUrl(String engine, String host, String port, String database) {
        StringBuilder builder = new StringBuilder();
        builder.append("jdbc:");
        if (engine.equals("postgresql")) {
            builder.append("postgresql://");
            builder.append(host);
            builder.append(":");
            builder.append(port);
            builder.append("/");
            builder.append(database);
            return builder.toString();
        }
        throw new ShellException("Unsupported database engine=" + engine + ". Supported engines=[postgresql]. Please contact support for information about implementation of a new engine.");
    }
}

