/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.stepfunctions.machines.dto.DataDumpRequest;
import com.cleveranalytics.common.stepfunctions.machines.dto.ValidateRequest;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.service.dwh.client.DwhFileClient;
import com.cleveranalytics.service.dwh.rest.dto.CsvOptions;
import com.cleveranalytics.service.dwh.rest.dto.DataCreateUploadResponse;
import com.cleveranalytics.service.dwh.rest.dto.DataPullMode;
import com.cleveranalytics.service.dwh.rest.dto.DataPullRequest;
import com.cleveranalytics.service.dwh.rest.dto.DataPullResponse;
import com.cleveranalytics.service.dwh.rest.dto.DataValidator;
import com.cleveranalytics.service.dwh.rest.dto.DumpDatasetContentResponse;
import com.cleveranalytics.service.dwh.rest.dto.DumpDatasetRequest;
import com.cleveranalytics.service.dwh.rest.dto.DwhValidateRequest;
import com.cleveranalytics.service.dwh.rest.dto.DwhValidateResponse;
import com.cleveranalytics.service.dwh.rest.dto.DwhValidateViolation;
import com.cleveranalytics.service.dwh.rest.dto.ModelValidator;
import com.cleveranalytics.service.job.JobDetailResponse;
import com.cleveranalytics.service.job.client.JobClient;
import com.cleveranalytics.service.job.dto.GeneralJobRequest;
import com.cleveranalytics.service.job.type.DataDumpJobRequest;
import com.cleveranalytics.service.job.type.DataPullJobRequest;
import com.cleveranalytics.service.job.type.ValidateJobRequest;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;

public class DwhShellClient {
    private static final Logger logger = LoggerFactory.getLogger(DwhShellClient.class);
    private final ObjectMapper mapper = new MdObjectMapper();
    private DwhFileClient dwhFileClient;

    public DwhShellClient(CanRestClient canRestClient) {
        this.dwhFileClient = new DwhFileClient(canRestClient);
    }

    public void dumpData(ShellContext context, IDatasets<IDatasetDTO> datasets, boolean skipErrors) throws IOException {
        List dumpResponses;
        try {
            dumpResponses = this.performDump(context, datasets, skipErrors);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
        for (DumpDatasetContentResponse dumpDatasetResponse : dumpResponses) {
            if (!((Link)dumpDatasetResponse.getLinks().get(0)).getRel().equals("self")) {
                throw new IOException("Failed to obtain CSV dump link.");
            }
            String csvDumpLink = ((Link)dumpDatasetResponse.getLinks().get(0)).getHref();
            String datasetName = dumpDatasetResponse.getDataset();
            String bearerToken = context.getCanRestClient().refreshAccessToken();
            String csvFilePath = Paths.get(context.getDataDumpPath().toString(), datasetName).toString();
            csvFilePath = FileTools.appendExtension((String)csvFilePath, (String)".csv");
            File csvFile = new File(csvFilePath);
            String projectId = context.getCurrentProject();
            ResponseEntity csvResponse = this.dwhFileClient.getCsv(projectId, csvFilePath, csvDumpLink, bearerToken);
            String md5hash = this.getContentMd5(csvResponse.getHeaders());
            if (md5hash == null) continue;
            this.checkDumpedFile(context, csvFile, datasetName, dumpDatasetResponse.getNumberOfRows(), md5hash);
        }
    }

    private List<DumpDatasetContentResponse> performDump(ShellContext context, IDatasets<IDatasetDTO> datasets, boolean skipErrors) throws IOException, InterruptedException {
        ArrayList<DumpDatasetContentResponse> dumpResponses = new ArrayList<DumpDatasetContentResponse>();
        JobClient jobClient = new JobClient((CanRestClient)context.getCanRestClient());
        logger.error("Asynchronous data dump started...\n");
        for (IDatasetDTO dwhDataset : datasets) {
            DumpDatasetRequest dumpDatasetRequest = new DumpDatasetRequest().withDataset(dwhDataset.getName());
            DataDumpJobRequest dataDumpJobRequest = this.convertToJobDataDumpRequest(context.getCurrentProject(), dumpDatasetRequest);
            JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)dataDumpJobRequest);
            if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
                DumpDatasetContentResponse asyncResponse = (DumpDatasetContentResponse)this.mapper.convertValue(jobResponse.getResult(), DumpDatasetContentResponse.class);
                dumpResponses.add(asyncResponse);
                continue;
            }
            if (!skipErrors) {
                throw new CleverMapsShellException("Data dump failed with status=" + jobResponse.getStatus() + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId());
            }
            logger.error(jobResponse.getMessage().split("\n")[0]);
        }
        return dumpResponses;
    }

    protected DataDumpJobRequest convertToJobDataDumpRequest(String projectId, DumpDatasetRequest dwhDataDumpRequest) throws IOException {
        try {
            String dwhDataDumpRequestString = this.mapper.writeValueAsString((Object)dwhDataDumpRequest);
            DataDumpRequest stepsDataDumpRequest = (DataDumpRequest)this.mapper.readValue(dwhDataDumpRequestString, DataDumpRequest.class);
            return new DataDumpJobRequest().withType("dataDump").withProjectId(projectId).withContent(stepsDataDumpRequest);
        }
        catch (IOException ex) {
            logger.error("Failed to convert DWH data dump request to job data dump request.", (Throwable)ex);
            throw new IOException("Failed to convert DWH data dump request to job data dump request.");
        }
    }

    public void checkDumpedFile(ShellContext context, File csvFile, String datasetName, Long numberOfRows, String md5Hash) throws IOException {
        if (csvFile.exists()) {
            String dumpedMd5Hash = FileTools.calculateMD5((File)csvFile);
            if (!md5Hash.equals(dumpedMd5Hash)) {
                throw new CleverMapsShellException("MD5 checksum of dumped CSV file " + csvFile.getName() + " differs from the server file checksum.");
            }
        } else {
            throw new FileNotFoundException("Dumped CSV file=" + csvFile.getAbsolutePath() + " not found.");
        }
        AbstractShellClient shellClient = context.getShellClient();
        shellClient.putDataChecksumListElement(context, csvFile);
        logger.error("DWH data of dataset {} successfully dumped to {} ({} rows dumped)", new Object[]{datasetName, csvFile.getName(), numberOfRows});
    }

    public void performLoad(ShellContext context, File csvFile, String datasetName, DataPullMode mode, CsvOptions csvOptions) throws IOException {
        JobDetailResponse jobResponse;
        DataPullRequest dataPullRequest;
        String projectId = context.getCurrentProject();
        DataCreateUploadResponse dataCreateUploadResponse = this.dwhFileClient.createFileUpload(projectId);
        this.dwhFileClient.uploadCsv(projectId, csvFile, dataCreateUploadResponse.getUploadUrl());
        String uploadLink = this.dwhFileClient.findSelfLink(dataCreateUploadResponse);
        try {
            dataPullRequest = this.createDataPullRequest(datasetName, mode, new URI(uploadLink), csvOptions);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Failed to parse self link=" + uploadLink);
        }
        DataPullJobRequest dataPullJobRequest = this.convertToJobDataPullJobRequest(projectId, dataPullRequest);
        JobClient jobClient = new JobClient((CanRestClient)context.getCanRestClient());
        try {
            jobResponse = jobClient.executeJob((GeneralJobRequest)dataPullJobRequest);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
        if (!jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            throw new CleverMapsShellException("Data upload failed with status=" + jobResponse.getStatus() + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId());
        }
        AbstractShellClient shellClient = context.getShellClient();
        shellClient.putDataChecksumListElement(context, csvFile);
        DataPullResponse dataPullResponse = this.convertJobDetailResponse(jobResponse);
        logger.error("CSV file {} successfully loaded into dataset {} ({} rows loaded)", new Object[]{csvFile.getName(), datasetName, dataPullResponse.getNumberOfRowsLoaded()});
    }

    protected DataPullRequest createDataPullRequest(String datasetName, DataPullMode mode, URI uploadUri, CsvOptions csvOptions) {
        return new DataPullRequest().withDataset(datasetName).withMode(mode).withUpload(uploadUri).withType(DataPullRequest.Type.CSV).withCsvOptions(csvOptions);
    }

    protected DataPullJobRequest convertToJobDataPullJobRequest(String projectId, DataPullRequest dwhDataPullRequest) {
        try {
            String dwhDataPullRequestString = this.mapper.writeValueAsString((Object)dwhDataPullRequest);
            com.cleveranalytics.common.stepfunctions.machines.dto.DataPullRequest stepsDataPullRequest = (com.cleveranalytics.common.stepfunctions.machines.dto.DataPullRequest)this.mapper.readValue(dwhDataPullRequestString, com.cleveranalytics.common.stepfunctions.machines.dto.DataPullRequest.class);
            return new DataPullJobRequest().withType("dataPull").withProjectId(projectId).withContent(stepsDataPullRequest);
        }
        catch (IOException ex) {
            throw new CleverMapsShellException("Failed to convert DWH data pull request to job data pull request.");
        }
    }

    protected DataPullResponse convertJobDetailResponse(JobDetailResponse jobDetailResponse) {
        try {
            String dwhDataPullResponseResultString = this.mapper.writeValueAsString(jobDetailResponse.getResult());
            return (DataPullResponse)this.mapper.readValue(dwhDataPullResponseResultString, DataPullResponse.class);
        }
        catch (IOException ex) {
            throw new CleverMapsShellException("Failed to convert JobDetailResponse to the DataPullResponse object.");
        }
    }

    public Map<String, Integer> simpleProjectIntegrityCheck(UserCredentialsCanRestClient canRestClient, String projectId) throws IOException {
        System.out.printf("Validating DWH model/data integrity of project " + projectId + "... ", new Object[0]);
        DwhValidateResponse validateResponse = this.validateProjectIntegrity(canRestClient, projectId, false, false);
        HashMap<String, Integer> violationTypes = new HashMap<String, Integer>();
        for (DwhValidateViolation violation : validateResponse.getViolations()) {
            if (violationTypes.containsKey(violation.getViolationType())) {
                Integer violationCount;
                Integer n = violationCount = (Integer)violationTypes.get(violation.getViolationType());
                Integer n2 = violationCount = Integer.valueOf(violationCount + 1);
                violationTypes.put(violation.getViolationType(), violationCount);
                continue;
            }
            violationTypes.put(violation.getViolationType(), 1);
        }
        return violationTypes;
    }

    public DwhValidateResponse validateProjectIntegrity(UserCredentialsCanRestClient canRestClient, String projectId, boolean skipModel, boolean skipData) throws IOException {
        DwhValidateRequest validateRequest = new DwhValidateRequest();
        if (!skipModel) {
            validateRequest.setModelValidator(new ModelValidator());
        }
        if (!skipData) {
            validateRequest.setDataValidator(new DataValidator());
        }
        try {
            return this.performValidation(canRestClient, projectId, validateRequest);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
    }

    protected DwhValidateResponse performValidation(UserCredentialsCanRestClient canRestClient, String projectId, DwhValidateRequest dwhValidateRequest) throws IOException, InterruptedException {
        JobClient jobClient = new JobClient((CanRestClient)canRestClient);
        ValidateJobRequest validateJobRequest = this.convertToJobValidateRequest(projectId, dwhValidateRequest);
        JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)validateJobRequest);
        if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            String dwhValidateResponseResult = this.mapper.writeValueAsString(jobResponse.getResult());
            return (DwhValidateResponse)this.mapper.readValue(dwhValidateResponseResult, DwhValidateResponse.class);
        }
        throw new CleverMapsShellException("Project validation job failed with status=" + jobResponse.getStatus() + " message=" + jobResponse.getMessage() + "\n");
    }

    protected ValidateJobRequest convertToJobValidateRequest(String projectId, DwhValidateRequest dwhValidateRequest) {
        try {
            String dwhValidateRequestString = this.mapper.writeValueAsString((Object)dwhValidateRequest);
            ValidateRequest stepsValidateRequest = (ValidateRequest)this.mapper.readValue(dwhValidateRequestString, ValidateRequest.class);
            return new ValidateJobRequest().withType("validate").withProjectId(projectId).withContent(stepsValidateRequest);
        }
        catch (IOException ex) {
            logger.error("Failed to convert DWH data dump request to job data dump request.", (Throwable)ex);
            throw new CleverMapsShellException("Failed to convert DWH data pull request to job data pull request.");
        }
    }

    protected String getContentMd5(HttpHeaders headers) {
        if (headers.containsKey((Object)"x-amz-meta-content-md5")) {
            return headers.getFirst("x-amz-meta-content-md5");
        }
        if (headers.containsKey((Object)"Content-MD5")) {
            return headers.getFirst("Content-MD5");
        }
        logger.error("Skipping verification of downloaded file, no content-md5 header was found in server response.");
        return null;
    }
}

