/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.GenerateDatasetRequestDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.jdbc.JdbcShellClient;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliOption;

public class ImportDatabaseCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(ImportDatabaseCommand.class);
    @Value(value="${service.name}")
    private final String serviceName;
    private ShellContext context;
    private DumpProjectCommand dumpProjectCommand;

    public ImportDatabaseCommand(ShellContext context, DumpProjectCommand dumpProjectCommand) {
        this.serviceName = null;
        this.context = context;
        this.dumpProjectCommand = dumpProjectCommand;
    }

    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getUserEmail() != null && this.context.getCurrentProject() != null;
    }

    public void openDatabaseCmd(@CliOption(key={"url"}, mandatory=true, help="URL of any database.") String url, @CliOption(key={"user"}, mandatory=true, help="User name for login to the database.") String user, @CliOption(key={"password"}, mandatory=true, help="User's password.") String password, @CliOption(key={"tables"}, mandatory=false, help="List of tables to import.") String[] inputTablesArray, @CliOption(key={"skipData"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip data import.") boolean skipData, @CliOption(key={"skipMetadata"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Skip metadata import.") boolean skipMetadata) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (this.context.getCurrentDump() == null) {
                logger.error("No dump of project {} opened, making a dump first...\n", (Object)this.context.getCurrentProject());
                this.dumpProjectCommand.dumpProject(null, true, false, "async", false, true, true);
            }
            JdbcShellClient jdbcShellClient = new JdbcShellClient(url, user, password);
            List allTables = jdbcShellClient.getAllTableNames();
            List<Object> inputTables = inputTablesArray == null ? new ArrayList() : Arrays.asList(inputTablesArray);
            List tablesToImport = this.determineTablesToImport(allTables, inputTables);
            logger.error("Import of {} database tables started...\n", (Object)tablesToImport.size());
            List requests = jdbcShellClient.generateDatasetRequests(tablesToImport);
            if (!skipMetadata) {
                this.importMetadata(requests);
            }
            if (!skipData) {
                this.importData(requests, jdbcShellClient);
            }
            this.printImportMessage(url, this.context.getCurrentProject(), this.context.getProjectTitle(), skipMetadata ? 0 : requests.size(), skipData ? 0 : requests.size());
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (ShellContext)this.context);
        }
    }

    private void importMetadata(List<GenerateDatasetRequestDTO> requests) throws IOException {
        MdShellClient mdShellClient = (MdShellClient)this.context.getShellClient();
        for (GenerateDatasetRequestDTO request : requests) {
            DatasetDTO generatedDataset = mdShellClient.generateDataset(this.context.getCurrentProject(), request);
            Path path = Paths.get(this.context.getMetadataDumpPath().toString(), "datasets", request.getTableName());
            FileTools.saveObjectToJson((Object)generatedDataset, (String)path.toString());
            logger.error("Created dataset " + request.getTableName() + ".json");
        }
        logger.error("");
    }

    private void importData(List<GenerateDatasetRequestDTO> requests, JdbcShellClient jdbcShellClient) throws IOException {
        for (GenerateDatasetRequestDTO request : requests) {
            Path path = Paths.get(this.context.getDataDumpPath().toString(), request.getTableName());
            jdbcShellClient.dumpDataToCsv(request.getTableName(), path.toString() + ".csv");
            logger.error("Created CSV file " + request.getTableName() + ".csv");
        }
        logger.error("");
    }

    private List<String> determineTablesToImport(List<String> allTables, List<String> inputTables) {
        if (inputTables.size() == 0) {
            return new ArrayList<String>(allTables);
        }
        for (String tableName : inputTables) {
            if (allTables.contains(tableName)) continue;
            throw new CleverMapsShellException("Table name=" + tableName + " does not exist in specified database.");
        }
        return new ArrayList<String>(inputTables);
    }

    private void printImportMessage(String databaseUrl, String destinationProjectId, String destinationProjectTitle, int importedDatasets, int importedCsvs) {
        logger.error("\nImport finished!");
        logger.error("Imported database URL: {}", (Object)databaseUrl);
        logger.error("Destination project: {} ({})", (Object)destinationProjectId, (Object)destinationProjectTitle);
        logger.error("Imported datasets: {}", (Object)importedDatasets);
        logger.error("Imported CSV files: {}", (Object)importedCsvs);
        logger.error("\nTo view detailed imported content, use status command.");
        logger.error("Now you can make changes, or import another database.");
        if (importedDatasets > 0) {
            logger.error("When you're done, use addMetadata command to add the metadata to the project.");
        }
        if (importedCsvs > 0) {
            logger.error("To push the data to the project, use pushProject command.");
        }
        logger.error("");
    }
}

