/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.dto.MdObjectAbstractContent;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.BlockAbstractType;
import com.cleveranalytics.service.md.rest.dto.FilterAbstractType;
import com.cleveranalytics.service.md.rest.dto.GenerateDatasetRequestDTO;
import com.cleveranalytics.service.md.rest.dto.MdFileList;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.rest.dto.MdObjectsDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDwhTypeDTO;
import com.cleveranalytics.service.md.rest.dto.other.AdditionalSeriesLinkDTO;
import com.cleveranalytics.service.md.rest.dto.other.AnnotationLinkDTO;
import com.cleveranalytics.service.md.rest.dto.other.CategoriesDTO;
import com.cleveranalytics.service.md.rest.dto.other.CategoryDTO;
import com.cleveranalytics.service.md.rest.dto.other.DashboardContentDTO;
import com.cleveranalytics.service.md.rest.dto.other.DashboardDatasetPropertiesDTO;
import com.cleveranalytics.service.md.rest.dto.other.DefaultValuesNumberDTO;
import com.cleveranalytics.service.md.rest.dto.other.IndicatorContentDTO;
import com.cleveranalytics.service.md.rest.dto.other.IndicatorDrillContentDTO;
import com.cleveranalytics.service.md.rest.dto.other.IndicatorFilterDTO;
import com.cleveranalytics.service.md.rest.dto.other.IndicatorGroupDTO;
import com.cleveranalytics.service.md.rest.dto.other.IndicatorLinkDTO;
import com.cleveranalytics.service.md.rest.dto.other.LinkedLayerDTO;
import com.cleveranalytics.service.md.rest.dto.other.MarkerSelectorContentDTO;
import com.cleveranalytics.service.md.rest.dto.other.StaticScaleOptionDTO;
import com.cleveranalytics.service.md.rest.dto.other.TimeSeriesDTO;
import com.cleveranalytics.service.md.rest.dto.other.ViewContentDTO;
import com.cleveranalytics.service.md.util.ETag;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.service.metadata.rest.dto.FileList;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.Role;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.IdLinkReplacer;
import com.cleveranalytics.shell.client.LinkReplacer;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.NameLinkReplacer;
import com.cleveranalytics.shell.client.PlaceholderLinkReplacer;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import com.cleveranalytics.shell.exception.JsonSyntaxException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpStatusCodeException;

public class MdShellClient
extends AbstractShellClient {
    private static final Logger logger = LoggerFactory.getLogger(MdShellClient.class);
    private ObjectMapper mapper = new MdObjectMapper();
    private MdObjectClient mdObjectClient;

    public MdShellClient(CanRestClient canRestClient) {
        this.mdObjectClient = new MdObjectClient(canRestClient);
    }

    public FileList getObjectsList(ShellContext context) throws IOException {
        MdFileList fileList = new MdFileList();
        ProjectClient projectClient = new ProjectClient((CanRestClient)context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        block26: for (String mdObjectType : MdObjectType.getList()) {
            if (mdObjectType.equals("dataPermissions") && !projectRole.equals((Object)Role.ADMIN)) {
                fileList = fileList.withDataPermissions(new ArrayList());
                continue;
            }
            MdObjectsDTO mdObjects = this.mdObjectClient.getMdObjects(context.getCurrentProject(), mdObjectType);
            ArrayList<String> mdObjectNames = new ArrayList<String>();
            for (MdObjectDTO mdObject : mdObjects) {
                mdObjectNames.add(mdObject.getName());
            }
            switch (mdObjectType) {
                case "dashboards": {
                    fileList = fileList.withDashboards(mdObjectNames);
                    continue block26;
                }
                case "dataPermissions": {
                    fileList = fileList.withDataPermissions(mdObjectNames);
                    continue block26;
                }
                case "datasets": {
                    fileList = fileList.withDatasets(mdObjectNames);
                    continue block26;
                }
                case "exports": {
                    fileList = fileList.withExports(mdObjectNames);
                    continue block26;
                }
                case "indicatorDrills": {
                    fileList = fileList.withIndicatorDrills(mdObjectNames);
                    continue block26;
                }
                case "indicators": {
                    fileList = fileList.withIndicators(mdObjectNames);
                    continue block26;
                }
                case "markers": {
                    fileList = fileList.withMarkers(mdObjectNames);
                    continue block26;
                }
                case "markerSelectors": {
                    fileList = fileList.withMarkerSelectors(mdObjectNames);
                    continue block26;
                }
                case "metrics": {
                    fileList = fileList.withMetrics(mdObjectNames);
                    continue block26;
                }
                case "projectSettings": {
                    fileList = fileList.withProjectSettings(mdObjectNames);
                    continue block26;
                }
                case "views": {
                    fileList = fileList.withViews(mdObjectNames);
                    continue block26;
                }
            }
            logger.error("\"" + mdObjectType + "\" is not a valid MdObject type.");
        }
        return fileList;
    }

    public void dumpObjectsLocal(ShellContext context) throws IOException {
        String projectId = context.getCurrentProject();
        ProjectClient projectClient = new ProjectClient((CanRestClient)context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        for (String mdObjectType : MdObjectType.getList()) {
            MdObjectsDTO mdObjects;
            if (mdObjectType.equals("dataPermissions") && !projectRole.equals((Object)Role.ADMIN) || (mdObjects = this.mdObjectClient.getMdObjects(projectId, mdObjectType)).size() <= 0) continue;
            System.out.println("Dumping " + mdObjectType);
            for (MdObjectDTO mdObject : mdObjects) {
                this.wrapAndSaveMdObject(context, mdObject);
            }
        }
    }

    public void wrapAndSaveMdObject(ShellContext context, MdObjectDTO mdObject) throws IOException {
        Assert.notNull((Object)context, (String)"ShellContext is null.");
        Assert.notNull((Object)mdObject, (String)"MdObject is null.");
        String objectType = mdObject.getType().toStringPlural();
        String projectId = context.getCurrentProject();
        String serverETagValue = this.mdObjectClient.headETagValue(projectId, objectType, mdObject.getId());
        ETag serverETag = new ETag(serverETagValue);
        mdObject.setVersion(serverETag.getVersion());
        mdObject = this.replaceURILinks(mdObject, (LinkReplacer)new IdLinkReplacer(mdObject.getName()));
        MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, mdObject);
        String filename = FileTools.appendExtension((String)mdObject.getName(), (String)".json");
        File typeDirectory = this.createMetadataSubfolder(context.getMetadataDumpPath().toFile(), objectType);
        Path path = Paths.get(typeDirectory.toString(), filename);
        FileTools.saveObjectToJson((Object)objectDump, (String)path.toString());
        this.putMetadataChecksumListElement(context, path.toFile());
    }

    public void addObject(String projectId, File file, boolean silent) throws IOException {
        MdObjectDTO mdObject;
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to add is null.");
        try {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            mdObject = (MdObjectDTO)this.mapper.readValue(content, MdObjectDTO.class);
        }
        catch (JsonProcessingException exception) {
            throw new JsonSyntaxException(file, (Object)"addMetadata", exception);
        }
        try {
            if (!mdObject.getName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
                throw new CleverMapsShellException("JSON object name=" + mdObject.getName() + " and the filename=" + file.getName() + " do not match.");
            }
            mdObject = this.replaceURILinks(mdObject, (LinkReplacer)new PlaceholderLinkReplacer(projectId, mdObject.getName()));
            MdObjectDTO response = this.mdObjectClient.postMdObject(projectId, mdObject);
            response = this.replaceURILinks(response, (LinkReplacer)new IdLinkReplacer(mdObject.getName()));
            String serverETagValue = this.mdObjectClient.headETagValue(projectId, response.getType().toStringPlural(), response.getId());
            ETag serverETag = new ETag(serverETagValue);
            response.setVersion(serverETag.getVersion());
            MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, response);
            FileTools.saveObjectToJson((Object)objectDump, (String)file.getAbsolutePath());
        }
        catch (HttpStatusCodeException ex) {
            if (!silent) {
                logger.error("Failed to add object " + file.getName());
            }
            throw ex;
        }
    }

    public void pushObject(String projectId, File file) throws IOException {
        MdObjectDTO mdObject;
        MdObjectDumpDTO mdObjectDump;
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to push is null.");
        try {
            FileTools.validateMdObjectDump((File)file);
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            mdObjectDump = (MdObjectDumpDTO)this.mapper.readValue(content, MdObjectDumpDTO.class);
            mdObject = mdObjectDump.getContent();
        }
        catch (JsonProcessingException exception) {
            throw new JsonSyntaxException(file, (Object)"pushProject", exception);
        }
        try {
            if (!mdObject.getName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
                throw new CleverMapsShellException("JSON object name=" + mdObject.getName() + " and the filename=" + file.getName() + " do not match.");
            }
            mdObject.setVersion(Long.valueOf(Long.parseLong(mdObjectDump.getVersion())));
            mdObject = this.replaceURILinks(mdObject, (LinkReplacer)new PlaceholderLinkReplacer(projectId, mdObject.getName()));
            MdObjectDTO response = this.mdObjectClient.putMdObject(projectId, mdObject.getType().toStringPlural(), mdObject.getId(), mdObject);
            response = this.replaceURILinks(response, (LinkReplacer)new IdLinkReplacer(mdObject.getName()));
            String serverETagValue = this.mdObjectClient.headETagValue(projectId, response.getType().toStringPlural(), response.getId());
            ETag serverETag = new ETag(serverETagValue);
            response.setVersion(serverETag.getVersion());
            MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, response);
            FileTools.saveObjectToJson((Object)objectDump, (String)file.getAbsolutePath());
        }
        catch (HttpStatusCodeException ex) {
            logger.error("Failed to push object " + file.getName());
            throw ex;
        }
    }

    public void removeObject(String projectId, String mdObjectType, String filename) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.hasText((String)mdObjectType, (String)"Missing property type.");
        Assert.hasText((String)filename, (String)"Missing filename of object to delete.");
        String objectName = FilenameUtils.removeExtension((String)filename);
        MdObjectDTO mdObject = this.mdObjectClient.getMdObjectByName(projectId, mdObjectType, objectName);
        this.mdObjectClient.deleteMdObjectById(projectId, mdObjectType, mdObject.getId());
    }

    public DatasetDTO generateDataset(String projectId, String name, String subtype, String primaryKey, String geometry, File csvFile, Character csvSeparator, Character csvQuote, Character csvEscape) throws IOException {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.hasText((String)name, (String)"Missing property name.");
        Assert.hasText((String)subtype, (String)"Missing property subtype.");
        Assert.notNull((Object)csvFile, (String)"Missing csv file.");
        if (primaryKey == null) {
            primaryKey = "";
        }
        if (geometry == null) {
            geometry = "";
        }
        if (csvSeparator == null) {
            csvSeparator = Character.valueOf(',');
        }
        if (csvQuote == null) {
            csvQuote = Character.valueOf('\"');
        }
        if (csvEscape == null) {
            csvEscape = Character.valueOf('\\');
        }
        String csvContent = FileTools.loadCsvLines((File)csvFile, (int)10);
        return this.mdObjectClient.generateDataset(projectId, name, subtype, primaryKey, geometry, csvContent, csvSeparator, csvQuote, csvEscape);
    }

    public DatasetDTO generateDataset(String projectId, GenerateDatasetRequestDTO generateRequest) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)generateRequest, (String)"GenerateDatasetRequest must not be null.");
        return this.mdObjectClient.generateDataset(projectId, generateRequest);
    }

    public MdObjectDumpDTO renameObject(ShellContext context, File localFile, String oldName, String newName) throws IOException {
        Assert.notNull((Object)context, (String)"ShellContext is null.");
        Assert.notNull((Object)localFile, (String)"LocalFile is null.");
        Assert.hasText((String)oldName, (String)"Missing oldName of object to be renamed.");
        Assert.hasText((String)newName, (String)"Missing newName of object to be renamed.");
        File renamedLocalFile = FileTools.renameLocalObject((File)localFile, (String)newName);
        if (!renamedLocalFile.exists()) {
            throw new IOException("Failed to rename local object " + oldName);
        }
        logger.error("Object:");
        logger.error("\tLocal object {} successfully renamed to {}", (Object)oldName, (Object)newName);
        FileUtils.deleteQuietly((File)localFile);
        AbstractShellClient shellClient = context.getShellClient();
        String oldObjectName = FilenameUtils.removeExtension((String)oldName);
        String newObjectName = FilenameUtils.removeExtension((String)newName);
        shellClient.pushObject(context.getCurrentProject(), renamedLocalFile);
        logger.error("\tRemote object {} successfully renamed to {}\n", (Object)oldObjectName, (Object)newObjectName);
        shellClient.removeMetadataChecksumListElement(context, localFile);
        shellClient.putMetadataChecksumListElement(context, renamedLocalFile);
        return FileTools.loadFileAsMdObjectDump((File)renamedLocalFile);
    }

    public void renameObjectReferences(ShellContext context, MdObjectDumpDTO objectDumpToRename, List<MdObjectDumpDTO> renamedReferences) throws IOException {
        logger.error("Object references:");
        if (renamedReferences.size() > 0) {
            for (MdObjectDumpDTO renamedReference : renamedReferences) {
                String objectName = renamedReference.getContent().getName();
                String filename = FileTools.appendExtension((String)objectName, (String)".json");
                Path path = Paths.get(context.getMetadataDumpPath().toString(), renamedReference.getContent().getType().toStringPlural(), filename);
                FileTools.saveObjectToJson((Object)renamedReference, (String)path.toAbsolutePath().toString());
                String objectType = objectDumpToRename.getContent().getType().toString();
                logger.error("\tRenamed {} reference(s) key in local file {} and uploaded it", (Object)objectType, (Object)filename);
                AbstractShellClient shellClient = context.getShellClient();
                shellClient.pushObject(context.getCurrentProject(), path.toFile());
                shellClient.putMetadataChecksumListElement(context, path.toFile());
            }
            logger.error("");
        } else {
            logger.error("\tThis object is not referenced in any other object(s).\n");
        }
    }

    public IDatasets<IDatasetDTO> loadDatasetsFromPath(File path) throws IOException {
        IDatasets datasets = new IDatasets();
        File[] files = path.listFiles();
        if (files != null) {
            for (File datasetFile : files) {
                IDatasetDTO dataset;
                if (FileTools.isValidMdObjectDump((File)datasetFile)) {
                    MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)datasetFile);
                    dataset = (IDatasetDTO)this.unwrapMdObject(mdObjectDump);
                } else {
                    dataset = (IDatasetDTO)FileTools.loadFileAsClass((File)datasetFile, DatasetDTO.class);
                }
                datasets.add((Object)dataset);
            }
        }
        return datasets;
    }

    public List<MdObjectDTO> loadMdObjectsFromPath(File dumpPath, Map<String, Boolean> typesToLoad) throws IOException {
        ArrayList<MdObjectDTO> mdObjects = new ArrayList<MdObjectDTO>();
        File[] subdirectories = dumpPath.listFiles();
        if (subdirectories != null) {
            for (File mdObjectTypeFolder : subdirectories) {
                File[] files;
                if (mdObjectTypeFolder.getName().equals("datasets") || (files = mdObjectTypeFolder.listFiles()) == null) continue;
                for (File mdObjectFile : files) {
                    if (FileTools.isValidMdObjectDump((File)mdObjectFile)) {
                        MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)mdObjectFile);
                        if (typesToLoad.size() != 0 && !typesToLoad.get(mdObjectDump.getContent().getType().toStringPlural()).booleanValue()) continue;
                        mdObjects.add(this.unwrapMdObject(mdObjectDump));
                        continue;
                    }
                    MdObjectDTO mdObject = (MdObjectDTO)FileTools.loadFileAsClass((File)mdObjectFile, MdObjectDTO.class);
                    mdObjects.add(mdObject);
                }
            }
        }
        return mdObjects;
    }

    public List<MdObjectDumpDTO> loadMdObjectTypeDumps(File dumpPath, MdObjectTypeEnum type) throws IOException {
        ArrayList<MdObjectDumpDTO> mdObjectDumps = new ArrayList<MdObjectDumpDTO>();
        File[] subdirectories = dumpPath.listFiles();
        if (subdirectories != null) {
            for (File mdObjectTypeFolder : subdirectories) {
                File[] files;
                if (!mdObjectTypeFolder.getName().equals(type.toStringPlural()) || (files = mdObjectTypeFolder.listFiles()) == null) continue;
                for (File mdObjectFile : files) {
                    if (!FileTools.isValidMdObjectDump((File)mdObjectFile)) continue;
                    MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump((File)mdObjectFile);
                    mdObjectDumps.add(mdObjectDump);
                }
            }
        }
        return mdObjectDumps;
    }

    public void saveDatasetsToPath(IDatasets<IDatasetDTO> datasets, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Failed to create directory=" + path);
        }
        for (IDatasetDTO dataset : datasets) {
            String datasetName = FileTools.appendExtension((String)dataset.getName(), (String)".json");
            Path finalPath = Paths.get(path.toString(), datasetName);
            FileTools.saveObjectToJson((Object)dataset, (String)finalPath.toString());
        }
    }

    public void saveMdObjectsToPath(List<MdObjectDTO> mdObjects, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Failed to create directory=" + path);
        }
        for (MdObjectDTO mdObject : mdObjects) {
            String mdObjectName = FileTools.appendExtension((String)mdObject.getName(), (String)".json");
            String type = mdObject.getType().toStringPlural();
            Path finalPath = Paths.get(path.toString(), type, mdObjectName);
            FileTools.saveObjectToJson((Object)mdObject, (String)finalPath.toString());
        }
    }

    public File getCurrentDatasetsPath(ShellContext context) {
        return Paths.get(context.getMetadataDumpPath().toString(), "datasets").toFile();
    }

    public MdObjectDumpDTO wrapMdObject(String projectId, MdObjectDTO mdObject) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)mdObject, (String)"MdObject is null.");
        URI uri = this.mdObjectClient.objectIdToURI(projectId, mdObject.getType().toStringPlural(), mdObject.getId());
        return new MdObjectDumpDTO().withUrl(uri.toString()).withDumpTime(FileTools.formatTimeToIso8601((Date)new Date())).withVersion(mdObject.getVersion().toString()).withContent(mdObject);
    }

    public MdObjectDTO unwrapMdObject(MdObjectDumpDTO mdObjectDump) {
        Assert.notNull((Object)mdObjectDump, (String)"MdObjectDump is null.");
        MdObjectDTO mdObject = mdObjectDump.getContent();
        mdObject.setId(null);
        mdObject.setAccessInfo(null);
        Map additionalProperties = mdObject.getAdditionalProperties();
        additionalProperties.remove("links");
        mdObject.setAdditionalProperties(additionalProperties);
        return mdObject;
    }

    public MdObjectDTO replaceURILinks(MdObjectDTO mdObject, LinkReplacer linkReplacer) {
        Assert.notNull((Object)mdObject, (String)("MdObject " + mdObject.getName() + " must not be null."));
        if (mdObject.getType() != MdObjectTypeEnum.DATASET) {
            Assert.notNull((Object)mdObject.getContent(), (String)("MdObject " + mdObject.getName() + " must have a content."));
        }
        MdObjectTypeEnum type = mdObject.getType();
        switch (1.$SwitchMap$com$cleveranalytics$service$md$rest$dto$MdObjectTypeEnum[type.ordinal()]) {
            case 1: {
                DashboardContentDTO dashboardContent = (DashboardContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInDashboard(dashboardContent, linkReplacer));
                break;
            }
            case 2: {
                IndicatorContentDTO indicatorContent = (IndicatorContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInIndicator(indicatorContent, linkReplacer));
                break;
            }
            case 3: {
                IndicatorDrillContentDTO indicatorDrillContent = (IndicatorDrillContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInIndicatorDrill(indicatorDrillContent, linkReplacer));
                break;
            }
            case 4: {
                MarkerSelectorContentDTO markerSelectorContent = (MarkerSelectorContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInMarkerSelector(markerSelectorContent, linkReplacer));
                break;
            }
            case 5: {
                ViewContentDTO viewContent = (ViewContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInView(viewContent, linkReplacer));
                break;
            }
            default: {
                logger.warn("Skipping MdObject type={}, this type has no URI links.", (Object)type);
            }
        }
        return mdObject;
    }

    private DashboardContentDTO replaceURILinksInDashboard(DashboardContentDTO dashboardContent, LinkReplacer linkReplacer) {
        if (dashboardContent.getIndicators() != null) {
            for (IndicatorLinkDTO indicatorLink : dashboardContent.getIndicators()) {
                indicatorLink.setIndicator(linkReplacer.replace(indicatorLink.getIndicator()));
                indicatorLink.setIndicatorDrill(linkReplacer.replace(indicatorLink.getIndicatorDrill()));
            }
        }
        if (dashboardContent.getIndicatorGroups() != null) {
            for (IndicatorGroupDTO indicatorGroup : dashboardContent.getIndicatorGroups()) {
                for (IndicatorLinkDTO indicatorLink : indicatorGroup.getIndicators()) {
                    indicatorLink.setIndicator(linkReplacer.replace(indicatorLink.getIndicator()));
                    indicatorLink.setIndicatorDrill(linkReplacer.replace(indicatorLink.getIndicatorDrill()));
                }
            }
        }
        if (dashboardContent.getBlocks() != null) {
            for (BlockAbstractType block : dashboardContent.getBlocks()) {
                String indicatorLink;
                if (!(block instanceof CategoriesDTO) || (indicatorLink = ((CategoriesDTO)block).getIndicator()) == null) continue;
                ((CategoriesDTO)block).setIndicator(linkReplacer.replace(indicatorLink));
            }
        }
        if (dashboardContent.getDatasetProperties() != null) {
            for (DashboardDatasetPropertiesDTO dashboardDatasetProperty : dashboardContent.getDatasetProperties()) {
                String datasetLink = dashboardDatasetProperty.getDataset();
                if (datasetLink == null) continue;
                dashboardDatasetProperty.setDataset(linkReplacer.replace(datasetLink));
            }
        }
        return dashboardContent;
    }

    private IndicatorContentDTO replaceURILinksInIndicator(IndicatorContentDTO indicatorContent, LinkReplacer linkReplacer) {
        indicatorContent.setMetric(linkReplacer.replace(indicatorContent.getMetric()));
        if (indicatorContent.getRelations() != null) {
            indicatorContent.getRelations().setReversedMetric(linkReplacer.replace(indicatorContent.getRelations().getReversedMetric()));
        }
        if (indicatorContent.getScaleOptions() != null && indicatorContent.getScaleOptions().getStatic() != null) {
            for (StaticScaleOptionDTO scaleOption : indicatorContent.getScaleOptions().getStatic()) {
                if (scaleOption.getDataset() == null) continue;
                scaleOption.setDataset(linkReplacer.replace(scaleOption.getDataset()));
            }
        }
        return indicatorContent;
    }

    private IndicatorDrillContentDTO replaceURILinksInIndicatorDrill(IndicatorDrillContentDTO indicatorDrillContent, LinkReplacer linkReplacer) {
        if (indicatorDrillContent.getBlocks() != null) {
            for (BlockAbstractType block : indicatorDrillContent.getBlocks()) {
                String indicatorLink;
                if (block instanceof CategoriesDTO && (indicatorLink = ((CategoriesDTO)block).getIndicator()) != null) {
                    ((CategoriesDTO)block).setIndicator(linkReplacer.replace(indicatorLink));
                }
                if (!(block instanceof TimeSeriesDTO)) continue;
                List additionalSeriesList = ((TimeSeriesDTO)block).getAdditionalSeries();
                for (AdditionalSeriesLinkDTO additionalSeriesLink : additionalSeriesList) {
                    String indicatorLink2 = additionalSeriesLink.getIndicator();
                    additionalSeriesLink.setIndicator(linkReplacer.replace(indicatorLink2));
                }
                List annotationsList = ((TimeSeriesDTO)block).getAnnotations();
                for (AnnotationLinkDTO annotationLink : annotationsList) {
                    String datasetLink = annotationLink.getDataset();
                    annotationLink.setDataset(linkReplacer.replace(datasetLink));
                }
            }
        }
        return indicatorDrillContent;
    }

    private MarkerSelectorContentDTO replaceURILinksInMarkerSelector(MarkerSelectorContentDTO markerSelectorContent, LinkReplacer linkReplacer) {
        for (CategoryDTO category : markerSelectorContent.getCategories()) {
            category.setDataset(linkReplacer.replace(category.getDataset()));
            for (LinkedLayerDTO linkedLayer : category.getLinkedLayers()) {
                linkedLayer.setDataset(linkReplacer.replace(linkedLayer.getDataset()));
            }
        }
        return markerSelectorContent;
    }

    private ViewContentDTO replaceURILinksInView(ViewContentDTO viewContent, LinkReplacer linkReplacer) {
        viewContent.setDashboard(linkReplacer.replace(viewContent.getDashboard()));
        viewContent.setMarkerSelector(linkReplacer.replace(viewContent.getMarkerSelector()));
        if (viewContent.getDefaultGranularity() != null) {
            viewContent.setDefaultGranularity(linkReplacer.replace(viewContent.getDefaultGranularity()));
        }
        if (viewContent.getDefaultVisualized() != null) {
            viewContent.setDefaultVisualized(linkReplacer.replace(viewContent.getDefaultVisualized()));
        }
        for (FilterAbstractType filter : viewContent.getFilterGroup()) {
            DefaultValuesNumberDTO defaultValues;
            if (!filter.getType().equals("indicator")) continue;
            IndicatorFilterDTO indicatorFilter = (IndicatorFilterDTO)filter;
            indicatorFilter.setIndicator(linkReplacer.replace(indicatorFilter.getIndicator()));
            if (indicatorFilter.getDefaultValues() == null || (defaultValues = indicatorFilter.getDefaultValues()).getGranularity() == null) continue;
            defaultValues.setGranularity(linkReplacer.replace(defaultValues.getGranularity()));
        }
        return viewContent;
    }

    public List<MdObjectDumpDTO> replaceURIReferences(File metadataDumpPath, MdObjectDTO mdObject, NameLinkReplacer linkReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> renamedReferences = new ArrayList<MdObjectDumpDTO>();
        MdObjectTypeEnum type = mdObject.getType();
        switch (1.$SwitchMap$com$cleveranalytics$service$md$rest$dto$MdObjectTypeEnum[type.ordinal()]) {
            case 2: {
                List indicatorReferences = this.replaceURIReferencesOfIndicator(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(indicatorReferences);
                break;
            }
            case 3: {
                List indicatorDrillReferences = this.replaceURIReferencesOfIndicatorDrill(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(indicatorDrillReferences);
                break;
            }
            case 6: {
                List metricReferences = this.replaceURIReferencesOfMetric(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(metricReferences);
                break;
            }
            case 7: {
                List datasetReferences = this.replaceURIReferencesOfDataset(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(datasetReferences);
                break;
            }
            case 1: {
                List dashboardReferences = this.replaceURIReferencesOfDashboard(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(dashboardReferences);
                break;
            }
            case 4: {
                List markerSelectorReferences = this.replaceURIReferencesOfMarkerSelector(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(markerSelectorReferences);
                break;
            }
            default: {
                logger.warn("Skipping MdObject type={}, this type has no URI references.", (Object)type);
            }
        }
        return renamedReferences;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfMetric(File metadataDumpPath, NameLinkReplacer metricNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedInIndicators = new ArrayList<MdObjectDumpDTO>();
        List allIndicators = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.INDICATOR);
        for (MdObjectDumpDTO indicator : allIndicators) {
            IndicatorContentDTO indicatorContent = (IndicatorContentDTO)indicator.getContent().getContent();
            if (metricNameReplacer.endsWithOldName(indicatorContent.getMetric())) {
                this.replaceURILinksInIndicator(indicatorContent, (LinkReplacer)metricNameReplacer);
                referencedInIndicators.add(indicator);
            }
            if (indicatorContent.getRelations() == null || !metricNameReplacer.endsWithOldName(indicatorContent.getRelations().getReversedMetric())) continue;
            this.replaceURILinksInIndicator(indicatorContent, (LinkReplacer)metricNameReplacer);
            referencedInIndicators.add(indicator);
        }
        return referencedInIndicators;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfIndicator(File metadataDumpPath, NameLinkReplacer indicatorNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedIn = new ArrayList<MdObjectDumpDTO>();
        List allDashboards = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.DASHBOARD);
        for (Object dashboard : allDashboards) {
            DashboardContentDTO dashboardContent = (DashboardContentDTO)dashboard.getContent().getContent();
            if (dashboardContent.getIndicators() != null) {
                for (IndicatorLinkDTO indicatorLink : dashboardContent.getIndicators()) {
                    if (!indicatorNameReplacer.endsWithOldName(indicatorLink.getIndicator())) continue;
                    this.replaceURILinksInDashboard(dashboardContent, (LinkReplacer)indicatorNameReplacer);
                    referencedIn.add((MdObjectDumpDTO)dashboard);
                }
            }
            if (dashboardContent.getIndicatorGroups() != null) {
                for (IndicatorGroupDTO indicatorGroup : dashboardContent.getIndicatorGroups()) {
                    for (IndicatorLinkDTO indicatorLink : indicatorGroup.getIndicators()) {
                        if (!indicatorNameReplacer.endsWithOldName(indicatorLink.getIndicator())) continue;
                        this.replaceURILinksInDashboard(dashboardContent, (LinkReplacer)indicatorNameReplacer);
                        referencedIn.add((MdObjectDumpDTO)dashboard);
                    }
                }
            }
            if (dashboardContent.getBlocks() == null) continue;
            for (BlockAbstractType block : dashboardContent.getBlocks()) {
                String indicatorLink;
                if (!(block instanceof CategoriesDTO) || (indicatorLink = ((CategoriesDTO)block).getIndicator()) == null || !indicatorNameReplacer.endsWithOldName(indicatorLink)) continue;
                this.replaceURILinksInDashboard(dashboardContent, (LinkReplacer)indicatorNameReplacer);
                referencedIn.add((MdObjectDumpDTO)dashboard);
            }
        }
        List allViews = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.VIEW);
        for (MdObjectDumpDTO view : allViews) {
            ViewContentDTO viewContent = (ViewContentDTO)view.getContent().getContent();
            if (viewContent.getDefaultVisualized() != null && indicatorNameReplacer.endsWithOldName(viewContent.getDefaultVisualized())) {
                this.replaceURILinksInView(viewContent, (LinkReplacer)indicatorNameReplacer);
                referencedIn.add(view);
            }
            for (FilterAbstractType filter : viewContent.getFilterGroup()) {
                IndicatorFilterDTO indicatorFilter;
                if (!filter.getType().equals("indicator") || !indicatorNameReplacer.endsWithOldName((indicatorFilter = (IndicatorFilterDTO)filter).getIndicator())) continue;
                this.replaceURILinksInView(viewContent, (LinkReplacer)indicatorNameReplacer);
                referencedIn.add(view);
            }
        }
        List allIndicatorDrills = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.INDICATOR_DRILL);
        for (MdObjectDumpDTO indicatorDrill : allIndicatorDrills) {
            IndicatorDrillContentDTO indicatorDrillContent = (IndicatorDrillContentDTO)indicatorDrill.getContent().getContent();
            for (BlockAbstractType block : indicatorDrillContent.getBlocks()) {
                String indicatorLink;
                if (block instanceof CategoriesDTO && (indicatorLink = ((CategoriesDTO)block).getIndicator()) != null && indicatorNameReplacer.endsWithOldName(indicatorLink)) {
                    this.replaceURILinksInIndicatorDrill(indicatorDrillContent, (LinkReplacer)indicatorNameReplacer);
                    referencedIn.add(indicatorDrill);
                }
                if (!(block instanceof TimeSeriesDTO)) continue;
                List additionalSeriesList = ((TimeSeriesDTO)block).getAdditionalSeries();
                for (AdditionalSeriesLinkDTO additionalSeriesLink : additionalSeriesList) {
                    String indicatorLink2 = additionalSeriesLink.getIndicator();
                    if (indicatorLink2 == null || !indicatorNameReplacer.endsWithOldName(additionalSeriesLink.getIndicator())) continue;
                    this.replaceURILinksInIndicatorDrill(indicatorDrillContent, (LinkReplacer)indicatorNameReplacer);
                    referencedIn.add(indicatorDrill);
                }
            }
        }
        return referencedIn;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfIndicatorDrill(File metadataDumpPath, NameLinkReplacer indicatorDrillNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedInDashboards = new ArrayList<MdObjectDumpDTO>();
        List allDashboards = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.DASHBOARD);
        for (MdObjectDumpDTO dashboard : allDashboards) {
            DashboardContentDTO dashboardContent = (DashboardContentDTO)dashboard.getContent().getContent();
            for (IndicatorLinkDTO indicatorLink : dashboardContent.getIndicators()) {
                if (!indicatorDrillNameReplacer.endsWithOldName(indicatorLink.getIndicatorDrill())) continue;
                this.replaceURILinksInDashboard(dashboardContent, (LinkReplacer)indicatorDrillNameReplacer);
                referencedInDashboards.add(dashboard);
            }
        }
        return referencedInDashboards;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfDataset(File metadataDumpPath, NameLinkReplacer datasetNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedIn = new ArrayList<MdObjectDumpDTO>();
        List allMarkerSelectors = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.MARKER_SELECTOR);
        for (Object markerSelector : allMarkerSelectors) {
            MarkerSelectorContentDTO markerSelectorContent = (MarkerSelectorContentDTO)markerSelector.getContent().getContent();
            for (CategoryDTO category : markerSelectorContent.getCategories()) {
                if (datasetNameReplacer.endsWithOldName(category.getDataset())) {
                    this.replaceURILinksInMarkerSelector(markerSelectorContent, (LinkReplacer)datasetNameReplacer);
                    referencedIn.add((MdObjectDumpDTO)markerSelector);
                }
                if (category.getLinkedLayers() == null) continue;
                for (Object linkedLayer : category.getLinkedLayers()) {
                    if (!datasetNameReplacer.endsWithOldName(linkedLayer.getDataset())) continue;
                    this.replaceURILinksInMarkerSelector(markerSelectorContent, (LinkReplacer)datasetNameReplacer);
                    referencedIn.add((MdObjectDumpDTO)markerSelector);
                }
            }
        }
        List allViews = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.VIEW);
        for (Object view : allViews) {
            ViewContentDTO viewContent = (ViewContentDTO)view.getContent().getContent();
            String defaultGranularityLink = viewContent.getDefaultGranularity();
            if (defaultGranularityLink != null && datasetNameReplacer.endsWithOldName(defaultGranularityLink)) {
                this.replaceURILinksInView(viewContent, (LinkReplacer)datasetNameReplacer);
                referencedIn.add((MdObjectDumpDTO)view);
            }
            List filterGroup = viewContent.getFilterGroup();
            for (FilterAbstractType filter : filterGroup) {
                DefaultValuesNumberDTO defaultValues;
                Object granularity;
                IndicatorFilterDTO indicatorFilter;
                if (!filter.getType().equals("indicator") || (indicatorFilter = (IndicatorFilterDTO)filter).getDefaultValues() == null || (granularity = (defaultValues = indicatorFilter.getDefaultValues()).getGranularity()) == null || !datasetNameReplacer.endsWithOldName((String)granularity)) continue;
                defaultValues.setGranularity(datasetNameReplacer.replace(defaultValues.getGranularity()));
                referencedIn.add((MdObjectDumpDTO)view);
            }
        }
        List allDatasets = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.DATASET);
        for (Object datasetDump : allDatasets) {
            DatasetDwhTypeDTO datasetRef;
            DatasetDTO dataset = (DatasetDTO)datasetDump.getContent();
            if (!dataset.getRef().getType().equals("dwh") || (datasetRef = (DatasetDwhTypeDTO)dataset.getRef()).getGeometry() == null || !datasetNameReplacer.getOldName().equals(datasetRef.getGeometry())) continue;
            datasetRef.setGeometry(datasetNameReplacer.getNewName());
            referencedIn.add((MdObjectDumpDTO)datasetDump);
        }
        List allIndicators = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.INDICATOR);
        for (Object indicator : allIndicators) {
            IndicatorContentDTO indicatorContent = (IndicatorContentDTO)indicator.getContent().getContent();
            if (indicatorContent.getScaleOptions() == null || indicatorContent.getScaleOptions().getStatic() == null) continue;
            for (StaticScaleOptionDTO scaleOption : indicatorContent.getScaleOptions().getStatic()) {
                if (scaleOption.getDataset() == null || !datasetNameReplacer.endsWithOldName(scaleOption.getDataset())) continue;
                scaleOption.setDataset(datasetNameReplacer.replace(scaleOption.getDataset()));
                referencedIn.add((MdObjectDumpDTO)indicator);
            }
        }
        List allIndicatorDrills = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.INDICATOR_DRILL);
        for (MdObjectDumpDTO indicatorDrill : allIndicatorDrills) {
            IndicatorDrillContentDTO indicatorDrillContent = (IndicatorDrillContentDTO)indicatorDrill.getContent().getContent();
            for (BlockAbstractType block : indicatorDrillContent.getBlocks()) {
                if (!(block instanceof TimeSeriesDTO) || ((TimeSeriesDTO)block).getAnnotations().isEmpty()) continue;
                List annotationsList = ((TimeSeriesDTO)block).getAnnotations();
                for (AnnotationLinkDTO annotationLink : annotationsList) {
                    String datasetLink = annotationLink.getDataset();
                    if (datasetLink == null || !datasetNameReplacer.endsWithOldName(datasetLink)) continue;
                    annotationLink.setDataset(datasetNameReplacer.replace(datasetLink));
                    referencedIn.add(indicatorDrill);
                }
            }
        }
        List allDashboards = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.DASHBOARD);
        for (MdObjectDumpDTO dashboard : allDashboards) {
            DashboardContentDTO dashboardContent = (DashboardContentDTO)dashboard.getContent().getContent();
            List datasetProperties = dashboardContent.getDatasetProperties();
            for (DashboardDatasetPropertiesDTO dashboardDatasetProperty : datasetProperties) {
                String datasetLink = dashboardDatasetProperty.getDataset();
                if (datasetLink == null || !datasetNameReplacer.endsWithOldName(datasetLink)) continue;
                dashboardDatasetProperty.setDataset(datasetNameReplacer.replace(datasetLink));
                referencedIn.add(dashboard);
            }
        }
        return referencedIn;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfDashboard(File metadataDumpPath, NameLinkReplacer dashboardNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedInViews = new ArrayList<MdObjectDumpDTO>();
        List allViews = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.VIEW);
        for (MdObjectDumpDTO view : allViews) {
            ViewContentDTO viewContent = (ViewContentDTO)view.getContent().getContent();
            if (!dashboardNameReplacer.endsWithOldName(viewContent.getDashboard())) continue;
            this.replaceURILinksInView(viewContent, (LinkReplacer)dashboardNameReplacer);
            referencedInViews.add(view);
        }
        return referencedInViews;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfMarkerSelector(File metadataDumpPath, NameLinkReplacer markerSelectorNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedInViews = new ArrayList<MdObjectDumpDTO>();
        List allViews = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectTypeEnum.VIEW);
        for (MdObjectDumpDTO view : allViews) {
            ViewContentDTO viewContent = (ViewContentDTO)view.getContent().getContent();
            String markerSelectorLink = viewContent.getMarkerSelector();
            if (markerSelectorLink == null || !markerSelectorNameReplacer.endsWithOldName(markerSelectorLink)) continue;
            this.replaceURILinksInView(viewContent, (LinkReplacer)markerSelectorNameReplacer);
            referencedInViews.add(view);
        }
        return referencedInViews;
    }
}

