/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client.jdbc;

import com.cleveranalytics.service.md.rest.dto.ColumnDTO;
import com.cleveranalytics.service.md.rest.dto.GenerateDatasetRequestDTO;
import com.cleveranalytics.shell.client.jdbc.StreamingCsvResultSetExtractor;
import com.cleveranalytics.shell.commands.project.ImportDatabaseCommand;
import com.cleveranalytics.shell.exception.JdbcShellClientException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class JdbcShellClient {
    private static final Logger logger = LoggerFactory.getLogger(ImportDatabaseCommand.class);
    private JdbcTemplate jdbcTemplate;
    private DSLContext dsl;

    public JdbcShellClient(String url, String user, String password) throws SQLException {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(url);
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        if (dataSource.getConnection() == null) {
            throw new JdbcShellClientException("Database access error has occurred. URL=" + url + ".");
        }
        this.dsl = DSL.using((Connection)dataSource.getConnection());
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        logger.error("Connection to database " + url + " successfully opened\n");
    }

    public List<String> getAllTableNames() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        String[] types = new String[]{"TABLE"};
        ResultSet tablesResultSet = this.getDatabaseMetadata().getTables(null, null, "%", types);
        while (tablesResultSet.next()) {
            tableNames.add(tablesResultSet.getString("TABLE_NAME"));
        }
        return tableNames;
    }

    public List<GenerateDatasetRequestDTO> generateDatasetRequests(List<String> tableNames) throws SQLException {
        ArrayList<GenerateDatasetRequestDTO> requests = new ArrayList<GenerateDatasetRequestDTO>();
        for (String tableName : tableNames) {
            String query = this.prepareSelectQuery(tableName, true);
            Map foreignKeys = this.getForeignKeys(tableName);
            ArrayList columns = new ArrayList();
            this.jdbcTemplate.query(query, resultSet -> {
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    ColumnDTO column = this.createColumn(i, foreignKeys, resultSet.getMetaData());
                    columns.add(column);
                }
                return columns;
            });
            GenerateDatasetRequestDTO request = new GenerateDatasetRequestDTO();
            request.setTableName(tableName);
            request.setColumns(columns);
            request.setPrimaryKey(this.getPrimaryKey(tableName));
            requests.add(request);
        }
        return requests;
    }

    private String prepareSelectQuery(String tableName, boolean limit) {
        SelectQuery select = this.dsl.selectQuery();
        select.addSelect(new SelectFieldOrAsterisk[]{DSL.field((String)"*")});
        select.addFrom((TableLike)DSL.table((Name)DSL.name((String)tableName)));
        if (limit) {
            select.addLimit(DSL.inline((int)1));
        }
        return select.getSQL();
    }

    private String getPrimaryKey(String tableName) throws SQLException {
        ResultSet primaryKeysResultSet = this.getDatabaseMetadata().getPrimaryKeys(null, null, tableName);
        String primaryKey = null;
        while (primaryKeysResultSet.next()) {
            if (primaryKeysResultSet.getRow() > 1) {
                throw new JdbcShellClientException("Table name=" + tableName + " contains multiple primary keys.");
            }
            primaryKey = primaryKeysResultSet.getString("COLUMN_NAME");
        }
        return primaryKey;
    }

    private Map<String, String> getForeignKeys(String tableName) throws SQLException {
        ResultSet foreignKeysResultSet = this.getDatabaseMetadata().getImportedKeys(null, null, tableName);
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        while (foreignKeysResultSet.next()) {
            String fkColumnName = foreignKeysResultSet.getString("FKCOLUMN_NAME");
            String pkTableName = foreignKeysResultSet.getString("PKTABLE_NAME");
            foreignKeys.put(fkColumnName, pkTableName);
        }
        return foreignKeys;
    }

    private DatabaseMetaData getDatabaseMetadata() throws SQLException {
        return this.jdbcTemplate.getDataSource().getConnection().getMetaData();
    }

    private ColumnDTO createColumn(int index, Map<String, String> foreignKeys, ResultSetMetaData metadata) throws SQLException {
        return new ColumnDTO().withIndex(Integer.valueOf(index)).withName(metadata.getColumnName(index)).withTypeClass(metadata.getColumnClassName(index)).withForeignKey(foreignKeys.get(metadata.getColumnName(index)));
    }

    public void dumpDataToCsv(String tableName, String path) throws IOException {
        String query = this.prepareSelectQuery(tableName, false);
        try (FileOutputStream outputStream = new FileOutputStream(new File(path));){
            this.jdbcTemplate.query(query, (ResultSetExtractor)new StreamingCsvResultSetExtractor((OutputStream)outputStream));
        }
    }
}

