/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.service.job.JobDetailResponse;
import com.cleveranalytics.service.job.client.JobClient;
import com.cleveranalytics.service.job.dto.GeneralJobRequest;
import com.cleveranalytics.service.job.type.TruncateJobRequest;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverMapsShellException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobShellClient {
    private static final Logger logger = LoggerFactory.getLogger(JobShellClient.class);

    public void truncateProject(ShellContext context) throws IOException, InterruptedException {
        logger.error("Truncation of project started...\n");
        TruncateJobRequest truncateJobRequest = new TruncateJobRequest();
        truncateJobRequest.setType("truncate");
        truncateJobRequest.setProjectId(context.getCurrentProject());
        JobClient jobClient = new JobClient((CanRestClient)context.getCanRestClient());
        JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)truncateJobRequest);
        if (!jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            throw new CleverMapsShellException("Project truncate operation failed with status=" + jobResponse.getStatus() + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId() + "\n");
        }
        logger.error("Project was successfully truncated.\n");
    }
}

