/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectTypeEnum;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDwhTypeDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.BannerProvider;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class CreateMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(CreateMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public CreateMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"createMetadata"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"createMetadata"}, help="Create a new metadata object.")
    public void createMetadataCmd(@CliOption(key={"type"}, mandatory=true, help="Type of the metadata object to create.") String objectType, @CliOption(key={"objectName"}, mandatory=true, help="Name of the object to create.") String objectName, @CliOption(key={"subtype"}, mandatory=false, help="Subtype of a dataset (only when creating a dataset). Available subtypes=[basic, geometryPoint, geometryPolygon].") String subtype, @CliOption(key={"file"}, mandatory=false, help="Source CSV file to generate the dataset from (only when creating a dataset).") String file, @CliOption(key={"primaryKey"}, mandatory=false, help="Name of the CSV column that will be marked as primary key (only when creating a dataset).") String primaryKey, @CliOption(key={"geometry"}, mandatory=false, help="Name of the geometry key for geometryPolygon dataset (only when creating a dataset).") String geometry, @CliOption(key={"csvSeparator"}, mandatory=false, help="Specifies the CSV column separator character.", unspecifiedDefaultValue=",") Character csvSeparator, @CliOption(key={"csvQuote"}, mandatory=false, help="Specifies the CSV quote character.", unspecifiedDefaultValue="\"") Character csvQuote, @CliOption(key={"csvEscape"}, mandatory=false, help="Specifies the CSV escape character.", unspecifiedDefaultValue="\\") Character csvEscape) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (objectType.equals(MdObjectTypeEnum.DATASET.toString())) {
                if (!this.checkDatasetParameters(subtype, file, geometry)) {
                    return;
                }
                File csvFile = FileTools.findDataInDump((ShellContext)this.context, (String)file);
                if (csvFile == null || !csvFile.exists() || !csvFile.canRead()) {
                    csvFile = FileTools.getCsvFileFromPath((String)file);
                }
                String datasetName = FileTools.appendExtension((String)objectName, (String)".json");
                Path datasetPath = Paths.get(this.context.getMetadataDumpPath().toString(), "datasets", datasetName);
                MdShellClient shellClient = (MdShellClient)this.context.getShellClient();
                DatasetDTO generatedDataset = shellClient.generateDataset(this.context.getCurrentProject(), objectName, subtype, primaryKey, geometry, csvFile, csvSeparator, csvQuote, csvEscape);
                FileTools.saveObjectToJson((Object)generatedDataset, (String)datasetPath.toString());
                logger.error("Dataset name {} of subtype {} generated successfully and saved as new\n", (Object)FilenameUtils.removeExtension((String)datasetName), (Object)subtype);
            } else {
                logger.error("Unknown or unsupported object type={}\n", (Object)objectType);
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle((Exception)ex, (boolean)this.context.isExitOnError());
        }
    }

    protected boolean checkDatasetParameters(String subtype, String file, String geometry) {
        if (subtype == null) {
            System.out.println(BannerProvider.ANSI_MAGENTA + "You should specify option (--subtype) when creating a dataset" + BannerProvider.ANSI_RESET);
            return false;
        }
        if (file == null) {
            System.out.println(BannerProvider.ANSI_MAGENTA + "You should specify option (--file) when creating a dataset" + BannerProvider.ANSI_RESET);
            return false;
        }
        try {
            DatasetDwhTypeDTO.Subtype.fromValue((String)subtype);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unknown dataset subtype=" + subtype);
        }
        if (subtype.equals(DatasetDwhTypeDTO.Subtype.GEOMETRY_POLYGON.toString()) && geometry == null) {
            System.out.println(BannerProvider.ANSI_MAGENTA + "You should specify option (--geometry) when creating a dataset of geometryPolygon subtype" + BannerProvider.ANSI_RESET);
            return false;
        }
        return true;
    }
}

