/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.commands.project.DumpProjectCommand;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.DumpMetadataDTO;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class ListDumpsCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(ListDumpsCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public ListDumpsCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"listDumps"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"listDumps"}, help="List all project dumps in a local directory.")
    public void listDumpsCmd(@CliOption(key={"directory"}, mandatory=false, help="Path to a dump directory.") String inputDirectory) {
        MDC.put((String)"requestId", (String)UriTool.randomId());
        File shellDirectory = DumpProjectCommand.createShellDirectory(inputDirectory, this.context);
        File projectDirectory = DumpProjectCommand.createProjectDirectory(shellDirectory, this.context);
        try {
            if (!projectDirectory.exists() || !projectDirectory.isDirectory()) {
                throw new FileNotFoundException("Dump directory=" + shellDirectory + " not found.");
            }
            logger.error("Listing dumps of project {}...", (Object)this.context.getCurrentProject());
            System.out.println(this.listDumps(projectDirectory));
            this.context.setShellDirectory(shellDirectory.toString());
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    public String listDumps(File projectDirectory) throws ParseException, IOException {
        Object[] dumpFolders = projectDirectory.listFiles();
        if (dumpFolders != null && dumpFolders.length == 0) {
            logger.error("\nNo dump directories found");
        }
        Arrays.sort(dumpFolders);
        ArrayList<String> invalidFiles = new ArrayList<String>();
        StringBuilder output = new StringBuilder();
        try {
            for (Object dump : dumpFolders) {
                if (FileTools.isValidDumpDirectory((File)dump)) {
                    File dumpFile = Paths.get(((File)dump).toString(), "dumpMetadata.json").toFile();
                    output.append("\n");
                    output.append(((File)dump).getName());
                    if (dumpFile.exists()) {
                        DumpMetadataDTO dumpMetadata = FileTools.loadFileAsDumpMetadataFile(dumpFile);
                        DateFormat directoryDateFormat = FileTools.DUMP_ID_FORMAT;
                        Date date = directoryDateFormat.parse(((File)dump).getName());
                        output.append("\n\tDump date: ");
                        output.append(date.toString());
                        output.append("\n\tDump server: ");
                        output.append(dumpMetadata.getServer());
                        output.append("\n\tProject title: ");
                        output.append(dumpMetadata.getProjectTitle());
                        output.append("\n\tData content: ");
                        HashMap<String, String> data = FileTools.getDataDumpList((File)dump);
                        if (data.isEmpty()) {
                            output.append("No data found (data dump might have been skipped)");
                        } else {
                            for (Map.Entry<String, String> entry : data.entrySet()) {
                                output.append("\n\t\t");
                                output.append(entry.getKey());
                                output.append(" (");
                                output.append(entry.getValue());
                                output.append(")");
                            }
                        }
                        output.append("\n\tMetadata content: ");
                        HashMap<String, Integer> metadata = FileTools.getMetadataObjectsDumpList((File)dump);
                        if (this.hasAllZeroValues(metadata)) {
                            output.append("No metadata found (metadata dump might have been skipped)");
                        } else {
                            int entrySetSize = metadata.entrySet().size();
                            int count = 1;
                            for (Map.Entry<String, Integer> entry : metadata.entrySet()) {
                                output.append(entry.getValue());
                                output.append(" ");
                                output.append(entry.getKey());
                                if (count < entrySetSize) {
                                    output.append(", ");
                                }
                                ++count;
                            }
                        }
                        output.append("\n");
                        continue;
                    }
                    output.append("\n\tError: dump metadata file cannot be found\n");
                    continue;
                }
                invalidFiles.add(((File)dump).getAbsolutePath());
            }
            if (invalidFiles.size() > 0) {
                output.append("\nInvalid dump directories/files:\n");
                for (String filename : invalidFiles) {
                    output.append("\t");
                    output.append(filename);
                    output.append("\n");
                }
            }
        }
        catch (ParseException ex) {
            throw new ParseException("Failed to parse directory structure", ex.getErrorOffset());
        }
        return output.toString();
    }

    protected boolean hasAllZeroValues(Map<String, Integer> map) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (entry.getValue() == 0) continue;
            return false;
        }
        return true;
    }
}

