/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.config;

import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.OlderVersionDTO;
import com.cleveranalytics.shell.dto.VersionInfoDTO;
import com.cleveranalytics.shell.exception.CleverAnalyticsShellException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultBannerProvider;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Order(value=-2147483648)
public class BannerProvider
extends DefaultBannerProvider {
    private static final Logger logger = LoggerFactory.getLogger(BannerProvider.class);
    public static final Ansi ANSI_RED = Ansi.ansi().fg(Ansi.Color.RED);
    public static final Ansi ANSI_RED_BACKGROUND = Ansi.ansi().bg(Ansi.Color.RED);
    public static final Ansi ANSI_WHITE = Ansi.ansi().fg(Ansi.Color.WHITE);
    public static final Ansi ANSI_CYAN = Ansi.ansi().fg(Ansi.Color.CYAN);
    public static final Ansi ANSI_MAGENTA = Ansi.ansi().fg(Ansi.Color.MAGENTA);
    public static final Ansi ANSI_RESET = Ansi.ansi().reset();
    @Value(value="${version}")
    private final String version;
    private ShellContext context;
    private static final String VERSIONS_RESOURCE_URL = "https://secure.cleveranalytics.com/shell/versions";
    private final String versionCheckFailedMessage = "Failed to fetch info about latest Shell versions. \nPlease make sure that you use the latest version: https://clevermaps.atlassian.net/wiki/spaces/CDD/pages/214761716/Download\n";
    private final String olderVersionMessage = "You are using an old version of CleverAnalytics Shell.\nVersion {latestVersion} is out, download here: https://clevermaps.atlassian.net/wiki/spaces/CDD/pages/214761716/Download\n\n";

    @Autowired
    public BannerProvider(ShellContext context) {
        this.version = null;
        this.context = context;
    }

    public String getBanner() {
        StringBuilder builder = new StringBuilder(this.buildFullLogo());
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("Version: ");
        builder.append(this.getVersion());
        builder.append(OsUtils.LINE_SEPARATOR);
        return builder.toString();
    }

    private String buildFullLogo() {
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI_RESET + "\n " + ANSI_RED_BACKGROUND + "              " + ANSI_RESET);
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append(" " + ANSI_RED_BACKGROUND + "              " + ANSI_RESET);
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append(" " + ANSI_RED_BACKGROUND + "              " + ANSI_RESET);
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append(" " + ANSI_RED_BACKGROUND + "              " + ANSI_RESET);
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append(" " + ANSI_RED_BACKGROUND + "  " + ANSI_WHITE + "CLEVER\u00b0     " + ANSI_RESET);
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append(" " + ANSI_RED_BACKGROUND + "  " + ANSI_WHITE + "ANALYTICS'  " + ANSI_RESET);
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append(" " + ANSI_RED_BACKGROUND + "              " + ANSI_RESET);
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append(" " + ANSI_RED_BACKGROUND + "              " + ANSI_RESET + "\n");
        return builder.toString();
    }

    private String buildLineLogo() {
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI_RED + "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502            \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502            \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502            \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502 " + ANSI_WHITE + "CLEVER\u00b0" + ANSI_RED + "    \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502 " + ANSI_WHITE + "ANALYTICS'" + ANSI_RED + " \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502            \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518" + ANSI_RESET);
        return builder.toString();
    }

    public String getWelcomeMessage() {
        VersionInfoDTO versionInfo = this.getVersionsInfo();
        StringBuilder versionMessageBuilder = new StringBuilder();
        if (versionInfo == null) {
            versionMessageBuilder.append("Failed to fetch info about latest Shell versions. \nPlease make sure that you use the latest version: https://clevermaps.atlassian.net/wiki/spaces/CDD/pages/214761716/Download\n");
        } else {
            logger.debug("Successfully fetched version info from url={}", (Object)VERSIONS_RESOURCE_URL);
            String latestVersion = versionInfo.getLatestVersion().getVersion();
            if (this.equalOrNewerVersions(this.getVersion(), latestVersion)) {
                versionMessageBuilder.append(versionInfo.getLatestVersion().getMessage());
                versionMessageBuilder.append("\n");
            } else {
                versionMessageBuilder.append("You are using an old version of CleverAnalytics Shell.\nVersion {latestVersion} is out, download here: https://clevermaps.atlassian.net/wiki/spaces/CDD/pages/214761716/Download\n\n".replace("{latestVersion}", latestVersion));
                versionMessageBuilder.append(this.getMissedChanges(versionInfo, this.getVersion()));
            }
        }
        return ANSI_CYAN + versionMessageBuilder.toString() + ANSI_RESET;
    }

    private VersionInfoDTO getVersionsInfo() {
        try {
            return (VersionInfoDTO)new RestTemplate().getForObject(VERSIONS_RESOURCE_URL, VersionInfoDTO.class, new Object[0]);
        }
        catch (Exception ex) {
            logger.debug("Failed to fetch version info from url={}", (Object)VERSIONS_RESOURCE_URL);
            return null;
        }
    }

    private boolean equalOrNewerVersions(String thisVersion, String latestVersion) {
        Integer thisVersionNumber = this.convertVersionNumber(thisVersion);
        Integer latestVersionNumber = this.convertVersionNumber(latestVersion);
        return thisVersion != null && latestVersion != null && thisVersionNumber >= latestVersionNumber;
    }

    private boolean equalVersions(String thisVersion, String latestVersion) {
        Integer thisVersionNumber = this.convertVersionNumber(thisVersion);
        Integer latestVersionNumber = this.convertVersionNumber(latestVersion);
        return thisVersion != null && latestVersion != null && thisVersionNumber.equals(latestVersionNumber);
    }

    private Integer convertVersionNumber(String input) {
        Pattern numberPattern = Pattern.compile("^(\\d\\.\\d\\.\\d)(.*)$");
        Matcher matcher = numberPattern.matcher(input);
        if (!matcher.matches()) {
            throw new CleverAnalyticsShellException("Failed to convert version=" + input);
        }
        String version = matcher.group(1);
        version = version.replace(".", "");
        return Integer.valueOf(version);
    }

    private String getMissedChanges(VersionInfoDTO versionInfo, String thisVersion) {
        StringBuilder missedChanges = new StringBuilder();
        for (OlderVersionDTO olderVersion : versionInfo.getOlderVersions()) {
            if (this.equalVersions(olderVersion.getVersion(), thisVersion)) break;
            for (String message : olderVersion.getMessages()) {
                missedChanges.append(olderVersion.getVersion());
                missedChanges.append(" - ");
                missedChanges.append(message);
                missedChanges.append("\n");
                if (!message.startsWith("FATAL")) continue;
                this.context.setIncompatibleVersion(true);
                this.context.setExitOnError(true);
            }
        }
        return missedChanges.toString();
    }

    public String getProviderName() {
        return "CleverAnalytics";
    }

    public String getVersion() {
        return this.version;
    }
}

