/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.dto.MdObjectAbstractContent;
import com.cleveranalytics.common.rest.util.ETag;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.FilterAbstractType;
import com.cleveranalytics.service.md.rest.dto.MdFileList;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectsDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDwhTypeDTO;
import com.cleveranalytics.service.md.rest.dto.other.CategoryDTO;
import com.cleveranalytics.service.md.rest.dto.other.DashboardContentDTO;
import com.cleveranalytics.service.md.rest.dto.other.DefaultValuesNumberDTO;
import com.cleveranalytics.service.md.rest.dto.other.IndicatorContentDTO;
import com.cleveranalytics.service.md.rest.dto.other.IndicatorFilterDTO;
import com.cleveranalytics.service.md.rest.dto.other.IndicatorLinkDTO;
import com.cleveranalytics.service.md.rest.dto.other.LinkedLayerDTO;
import com.cleveranalytics.service.md.rest.dto.other.MarkerSelectorContentDTO;
import com.cleveranalytics.service.md.rest.dto.other.ViewContentDTO;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.service.metadata.rest.dto.FileList;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.Role;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.IdLinkReplacer;
import com.cleveranalytics.shell.client.LinkReplacer;
import com.cleveranalytics.shell.client.NameLinkReplacer;
import com.cleveranalytics.shell.client.PlaceholderLinkReplacer;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverAnalyticsShellException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MdShellClient
extends AbstractShellClient {
    private static final Logger logger = LoggerFactory.getLogger(MdShellClient.class);
    private ObjectMapper mapper = new MdObjectMapper();
    private MdObjectClient mdObjectClient;

    public MdShellClient(CanRestClient canRestClient) {
        this.mdObjectClient = new MdObjectClient(canRestClient);
    }

    @Override
    public FileList getObjectsList(ShellContext context) throws IOException {
        MdFileList fileList = new MdFileList();
        ProjectClient projectClient = new ProjectClient((CanRestClient)context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        block26: for (String mdObjectType : MdObjectType.getList()) {
            if (mdObjectType.equals("dataPermissions") && !projectRole.equals((Object)Role.ADMIN)) {
                fileList = fileList.withDataPermissions(new ArrayList());
                continue;
            }
            MdObjectsDTO mdObjects = this.mdObjectClient.getMdObjects(context.getCurrentProject(), mdObjectType);
            ArrayList<String> mdObjectNames = new ArrayList<String>();
            for (MdObjectDTO mdObject : mdObjects) {
                mdObjectNames.add(mdObject.getName());
            }
            switch (mdObjectType) {
                case "dashboards": {
                    fileList = fileList.withDashboards(mdObjectNames);
                    continue block26;
                }
                case "dataPermissions": {
                    fileList = fileList.withDataPermissions(mdObjectNames);
                    continue block26;
                }
                case "datasets": {
                    fileList = fileList.withDatasets(mdObjectNames);
                    continue block26;
                }
                case "exports": {
                    fileList = fileList.withExports(mdObjectNames);
                    continue block26;
                }
                case "indicatorDrills": {
                    fileList = fileList.withIndicatorDrills(mdObjectNames);
                    continue block26;
                }
                case "indicators": {
                    fileList = fileList.withIndicators(mdObjectNames);
                    continue block26;
                }
                case "markers": {
                    fileList = fileList.withMarkers(mdObjectNames);
                    continue block26;
                }
                case "markerSelectors": {
                    fileList = fileList.withMarkerSelectors(mdObjectNames);
                    continue block26;
                }
                case "metrics": {
                    fileList = fileList.withMetrics(mdObjectNames);
                    continue block26;
                }
                case "projectSettings": {
                    fileList = fileList.withProjectSettings(mdObjectNames);
                    continue block26;
                }
                case "views": {
                    fileList = fileList.withViews(mdObjectNames);
                    continue block26;
                }
            }
            logger.error("\"" + mdObjectType + "\" is not a valid MdObject type.");
        }
        return fileList;
    }

    @Override
    public void dumpObjectsLocal(ShellContext context) throws IOException {
        String projectId = context.getCurrentProject();
        ProjectClient projectClient = new ProjectClient((CanRestClient)context.getCanRestClient());
        Role projectRole = projectClient.getMembershipInProject(context.getCurrentProject()).getRole();
        for (String mdObjectType : MdObjectType.getList()) {
            MdObjectsDTO mdObjects;
            if (mdObjectType.equals("dataPermissions") && !projectRole.equals((Object)Role.ADMIN) || (mdObjects = this.mdObjectClient.getMdObjects(projectId, mdObjectType)).size() <= 0) continue;
            System.out.println("Dumping " + mdObjectType);
            for (MdObjectDTO mdObject : mdObjects) {
                this.wrapAndSaveMdObject(context, mdObject);
            }
        }
    }

    public void wrapAndSaveMdObject(ShellContext context, MdObjectDTO mdObject) throws IOException {
        Assert.notNull((Object)context, (String)"ShellContext is null.");
        Assert.notNull((Object)mdObject, (String)"MdObject is null.");
        String objectType = mdObject.getType().toStringPlural();
        String projectId = context.getCurrentProject();
        Long serverETag = this.mdObjectClient.headETagLongValue(projectId, objectType, mdObject.getId());
        mdObject.setVersion(serverETag);
        mdObject = this.replaceURILinks(mdObject, new IdLinkReplacer(mdObject.getName()));
        MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, mdObject);
        String filename = FileTools.appendExtension(mdObject.getName(), ".json");
        File typeDirectory = this.createMetadataSubfolder(context.getMetadataDumpPath().toFile(), objectType);
        Path path = Paths.get(typeDirectory.toString(), filename);
        FileTools.saveObjectToJson(objectDump, path.toString());
        this.putMetadataChecksumListElement(context, path.toFile());
    }

    @Override
    public void addObject(String projectId, File file) throws IOException {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to add is null.");
        String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
        MdObjectDTO mdObject = (MdObjectDTO)this.mapper.readValue(content, MdObjectDTO.class);
        if (!mdObject.getName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
            throw new CleverAnalyticsShellException("JSON object name=" + mdObject.getName() + " and the filename=" + file.getName() + " do not match.");
        }
        mdObject = this.replaceURILinks(mdObject, new PlaceholderLinkReplacer(projectId, mdObject.getName()));
        MdObjectDTO response = this.mdObjectClient.postMdObject(projectId, mdObject);
        response = this.replaceURILinks(response, new IdLinkReplacer(mdObject.getName()));
        Long etag = this.mdObjectClient.headETagLongValue(projectId, response.getType().toStringPlural(), response.getId());
        response.setVersion(etag);
        MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, response);
        FileTools.saveObjectToJson(objectDump, file.getAbsolutePath());
    }

    @Override
    public void pushObject(String projectId, File file) throws IOException {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)file, (String)"File path of object to push is null.");
        MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump(file);
        MdObjectDTO mdObject = mdObjectDump.getContent();
        if (!mdObject.getName().equals(FilenameUtils.removeExtension((String)file.getName()))) {
            throw new CleverAnalyticsShellException("JSON object name=" + mdObject.getName() + " and the filename=" + file.getName() + " do not match.");
        }
        mdObject.setVersion(new ETag(mdObjectDump.getVersion()).getLongValue());
        mdObject = this.replaceURILinks(mdObject, new PlaceholderLinkReplacer(projectId, mdObject.getName()));
        MdObjectDTO response = this.mdObjectClient.putMdObject(projectId, mdObject.getType().toStringPlural(), mdObject.getId(), mdObject);
        response = this.replaceURILinks(response, new IdLinkReplacer(mdObject.getName()));
        Long etag = this.mdObjectClient.headETagLongValue(projectId, response.getType().toStringPlural(), response.getId());
        response.setVersion(etag);
        MdObjectDumpDTO objectDump = this.wrapMdObject(projectId, response);
        FileTools.saveObjectToJson(objectDump, file.getAbsolutePath());
    }

    @Override
    public void removeObject(String projectId, String mdObjectType, String filename) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.hasText((String)mdObjectType, (String)"MdObject is missing property type.");
        Assert.notNull((Object)filename, (String)"Missing filename of object to delete.");
        String objectName = FilenameUtils.removeExtension((String)filename);
        MdObjectDTO mdObject = this.mdObjectClient.getMdObjectByName(projectId, mdObjectType, objectName);
        this.mdObjectClient.deleteMdObjectById(projectId, mdObjectType, mdObject.getId());
    }

    public MdObjectDumpDTO renameObject(ShellContext context, File localFile, String oldName, String newName) throws IOException {
        Assert.notNull((Object)context, (String)"ShellContext is null.");
        Assert.notNull((Object)localFile, (String)"LocalFile is null.");
        Assert.hasText((String)oldName, (String)"Missing oldName of object to be renamed.");
        Assert.hasText((String)newName, (String)"Missing newName of object to be renamed.");
        File renamedLocalFile = FileTools.renameLocalObject(localFile, newName);
        if (!renamedLocalFile.exists()) {
            throw new IOException("Failed to rename local object " + oldName);
        }
        logger.error("Object:");
        logger.error("\tLocal object {} successfully renamed to {}", (Object)oldName, (Object)newName);
        FileUtils.deleteQuietly((File)localFile);
        AbstractShellClient shellClient = context.getShellClient();
        String oldObjectName = FilenameUtils.removeExtension((String)oldName);
        String newObjectName = FilenameUtils.removeExtension((String)newName);
        shellClient.pushObject(context.getCurrentProject(), renamedLocalFile);
        logger.error("\tRemote object {} successfully renamed to {}\n", (Object)oldObjectName, (Object)newObjectName);
        shellClient.removeMetadataChecksumListElement(context, localFile);
        shellClient.putMetadataChecksumListElement(context, renamedLocalFile);
        return FileTools.loadFileAsMdObjectDump(renamedLocalFile);
    }

    public void renameObjectReferences(ShellContext context, MdObjectDumpDTO objectDumpToRename, List<MdObjectDumpDTO> renamedReferences) throws IOException {
        logger.error("Object references:");
        if (renamedReferences.size() > 0) {
            for (MdObjectDumpDTO renamedReference : renamedReferences) {
                String objectName = renamedReference.getContent().getName();
                String filename = FileTools.appendExtension(objectName, ".json");
                Path path = Paths.get(context.getMetadataDumpPath().toString(), renamedReference.getContent().getType().toStringPlural(), filename);
                FileTools.saveObjectToJson(renamedReference, path.toAbsolutePath().toString());
                String objectType = objectDumpToRename.getContent().getType().toStringSingular();
                logger.error("\tRenamed {} reference(s) key in local file {} and uploaded it", (Object)objectType, (Object)filename);
                AbstractShellClient shellClient = context.getShellClient();
                shellClient.pushObject(context.getCurrentProject(), path.toFile());
                shellClient.putMetadataChecksumListElement(context, path.toFile());
            }
            logger.error("");
        } else {
            logger.error("\tThis object is not referenced in any other object(s).\n");
        }
    }

    @Override
    public IDatasets<IDatasetDTO> loadDatasetsFromPath(File path) throws IOException {
        IDatasets datasets = new IDatasets();
        File[] files = path.listFiles();
        if (files != null) {
            for (File datasetFile : files) {
                IDatasetDTO dataset;
                if (FileTools.isValidMdObjectDump(datasetFile)) {
                    MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump(datasetFile);
                    dataset = (IDatasetDTO)this.unwrapMdObject(mdObjectDump);
                } else {
                    dataset = (IDatasetDTO)FileTools.loadFileAsClass(datasetFile, DatasetDTO.class);
                }
                datasets.add((Object)dataset);
            }
        }
        return datasets;
    }

    public List<MdObjectDTO> loadMdObjectsFromPath(File dumpPath, Map<String, Boolean> typesToLoad) throws IOException {
        ArrayList<MdObjectDTO> mdObjects = new ArrayList<MdObjectDTO>();
        File[] subdirectories = dumpPath.listFiles();
        if (subdirectories != null) {
            for (File mdObjectTypeFolder : subdirectories) {
                File[] files;
                if (mdObjectTypeFolder.getName().equals("datasets") || (files = mdObjectTypeFolder.listFiles()) == null) continue;
                for (File mdObjectFile : files) {
                    if (FileTools.isValidMdObjectDump(mdObjectFile)) {
                        MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump(mdObjectFile);
                        if (typesToLoad.size() != 0 && !typesToLoad.get(mdObjectDump.getContent().getType().toStringPlural()).booleanValue()) continue;
                        mdObjects.add(this.unwrapMdObject(mdObjectDump));
                        continue;
                    }
                    MdObjectDTO mdObject = FileTools.loadFileAsClass(mdObjectFile, MdObjectDTO.class);
                    mdObjects.add(mdObject);
                }
            }
        }
        return mdObjects;
    }

    public List<MdObjectDumpDTO> loadMdObjectTypeDumps(File dumpPath, MdObjectDTO.Type type) throws IOException {
        ArrayList<MdObjectDumpDTO> mdObjectDumps = new ArrayList<MdObjectDumpDTO>();
        File[] subdirectories = dumpPath.listFiles();
        if (subdirectories != null) {
            for (File mdObjectTypeFolder : subdirectories) {
                File[] files;
                if (!mdObjectTypeFolder.getName().equals(type.toStringPlural()) || (files = mdObjectTypeFolder.listFiles()) == null) continue;
                for (File mdObjectFile : files) {
                    if (!FileTools.isValidMdObjectDump(mdObjectFile)) continue;
                    MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump(mdObjectFile);
                    mdObjectDumps.add(mdObjectDump);
                }
            }
        }
        return mdObjectDumps;
    }

    @Override
    public void saveDatasetsToPath(IDatasets<IDatasetDTO> datasets, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Failed to create directory=" + path);
        }
        for (IDatasetDTO dataset : datasets) {
            String datasetName = FileTools.appendExtension(dataset.getName(), ".json");
            Path finalPath = Paths.get(path.toString(), datasetName);
            FileTools.saveObjectToJson(dataset, finalPath.toString());
        }
    }

    public void saveMdObjectsToPath(List<MdObjectDTO> mdObjects, File path) throws IOException {
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Failed to create directory=" + path);
        }
        for (MdObjectDTO mdObject : mdObjects) {
            String mdObjectName = FileTools.appendExtension(mdObject.getName(), ".json");
            String type = mdObject.getType().toStringPlural();
            Path finalPath = Paths.get(path.toString(), type, mdObjectName);
            FileTools.saveObjectToJson(mdObject, finalPath.toString());
        }
    }

    @Override
    public File getCurrentDatasetsPath(ShellContext context) {
        return Paths.get(context.getMetadataDumpPath().toString(), "datasets").toFile();
    }

    public MdObjectDumpDTO wrapMdObject(String projectId, MdObjectDTO mdObject) {
        Assert.hasText((String)projectId, (String)"Missing property projectId.");
        Assert.notNull((Object)mdObject, (String)"MdObject is null.");
        URI uri = this.mdObjectClient.objectIdToURI(projectId, mdObject.getType().toStringPlural(), mdObject.getId());
        return new MdObjectDumpDTO().withUrl(uri.toString()).withDumpTime(FileTools.formatTimeToIso8601(new Date())).withVersion(mdObject.getVersion().toString()).withContent(mdObject);
    }

    public MdObjectDTO unwrapMdObject(MdObjectDumpDTO mdObjectDump) {
        Assert.notNull((Object)mdObjectDump, (String)"MdObjectDump is null.");
        MdObjectDTO mdObject = mdObjectDump.getContent();
        mdObject.setId(null);
        mdObject.setAccessInfo(null);
        Map additionalProperties = mdObject.getAdditionalProperties();
        additionalProperties.remove("links");
        mdObject.setAdditionalProperties(additionalProperties);
        return mdObject;
    }

    public MdObjectDTO replaceURILinks(MdObjectDTO mdObject, LinkReplacer linkReplacer) {
        MdObjectDTO.Type type = mdObject.getType();
        switch (type) {
            case DASHBOARD: {
                DashboardContentDTO dashboardContent = (DashboardContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInDashboard(dashboardContent, linkReplacer));
                break;
            }
            case INDICATOR: {
                IndicatorContentDTO indicatorContent = (IndicatorContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInIndicator(indicatorContent, linkReplacer));
                break;
            }
            case MARKER_SELECTOR: {
                MarkerSelectorContentDTO markerSelectorContent = (MarkerSelectorContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInMarkerSelector(markerSelectorContent, linkReplacer));
                break;
            }
            case VIEW: {
                ViewContentDTO viewContent = (ViewContentDTO)mdObject.getContent();
                mdObject.setContent((MdObjectAbstractContent)this.replaceURILinksInView(viewContent, linkReplacer));
                break;
            }
            default: {
                logger.warn("Skipping MdObject type={}, this type has no URI links.", (Object)type);
            }
        }
        return mdObject;
    }

    private DashboardContentDTO replaceURILinksInDashboard(DashboardContentDTO dashboardContent, LinkReplacer linkReplacer) {
        for (IndicatorLinkDTO indicatorLink : dashboardContent.getIndicators()) {
            indicatorLink.setIndicator(linkReplacer.replace(indicatorLink.getIndicator()));
            indicatorLink.setIndicatorDrill(linkReplacer.replace(indicatorLink.getIndicatorDrill()));
        }
        return dashboardContent;
    }

    private IndicatorContentDTO replaceURILinksInIndicator(IndicatorContentDTO indicatorContent, LinkReplacer linkReplacer) {
        indicatorContent.setMetric(linkReplacer.replace(indicatorContent.getMetric()));
        return indicatorContent;
    }

    private MarkerSelectorContentDTO replaceURILinksInMarkerSelector(MarkerSelectorContentDTO markerSelectorContent, LinkReplacer linkReplacer) {
        for (CategoryDTO category : markerSelectorContent.getCategories()) {
            category.setDataset(linkReplacer.replace(category.getDataset()));
            for (LinkedLayerDTO linkedLayer : category.getLinkedLayers()) {
                linkedLayer.setDataset(linkReplacer.replace(linkedLayer.getDataset()));
            }
        }
        return markerSelectorContent;
    }

    private ViewContentDTO replaceURILinksInView(ViewContentDTO viewContent, LinkReplacer linkReplacer) {
        viewContent.setDashboard(linkReplacer.replace(viewContent.getDashboard()));
        viewContent.setMarkerSelector(linkReplacer.replace(viewContent.getMarkerSelector()));
        if (viewContent.getDefaultGranularity() != null) {
            viewContent.setDefaultGranularity(linkReplacer.replace(viewContent.getDefaultGranularity()));
        }
        for (FilterAbstractType filter : viewContent.getFilterGroup()) {
            DefaultValuesNumberDTO defaultValues;
            if (!filter.getType().equals("indicator")) continue;
            IndicatorFilterDTO indicatorFilter = (IndicatorFilterDTO)filter;
            indicatorFilter.setIndicator(linkReplacer.replace(indicatorFilter.getIndicator()));
            if (indicatorFilter.getDefaultValues() == null || (defaultValues = indicatorFilter.getDefaultValues()).getGranularity() == null) continue;
            defaultValues.setGranularity(linkReplacer.replace(defaultValues.getGranularity()));
        }
        return viewContent;
    }

    public List<MdObjectDumpDTO> replaceURIReferences(File metadataDumpPath, MdObjectDTO mdObject, NameLinkReplacer linkReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> renamedReferences = new ArrayList<MdObjectDumpDTO>();
        MdObjectDTO.Type type = mdObject.getType();
        switch (type) {
            case INDICATOR: {
                List<MdObjectDumpDTO> indicatorReferences = this.replaceURIReferencesOfIndicator(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(indicatorReferences);
                break;
            }
            case INDICATOR_DRILL: {
                List<MdObjectDumpDTO> indicatorDrillReferences = this.replaceURIReferencesOfIndicatorDrill(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(indicatorDrillReferences);
                break;
            }
            case METRIC: {
                List<MdObjectDumpDTO> metricReferences = this.replaceURIReferencesOfMetric(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(metricReferences);
                break;
            }
            case DATASET: {
                List<MdObjectDumpDTO> datasetReferences = this.replaceURIReferencesOfDataset(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(datasetReferences);
                break;
            }
            case DASHBOARD: {
                List<MdObjectDumpDTO> dashboardReferences = this.replaceURIReferencesOfDashboard(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(dashboardReferences);
                break;
            }
            case MARKER_SELECTOR: {
                List<MdObjectDumpDTO> markerSelectorReferences = this.replaceURIReferencesOfMarkerSelector(metadataDumpPath, linkReplacer);
                renamedReferences.addAll(markerSelectorReferences);
                break;
            }
            default: {
                logger.warn("Skipping MdObject type={}, this type has no URI references.", (Object)type);
            }
        }
        return renamedReferences;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfMetric(File metadataDumpPath, NameLinkReplacer metricNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedInIndicators = new ArrayList<MdObjectDumpDTO>();
        List<MdObjectDumpDTO> allIndicators = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.INDICATOR);
        for (MdObjectDumpDTO indicator : allIndicators) {
            IndicatorContentDTO indicatorContent = (IndicatorContentDTO)indicator.getContent().getContent();
            if (!metricNameReplacer.endsWithOldName(indicatorContent.getMetric())) continue;
            this.replaceURILinksInIndicator(indicatorContent, metricNameReplacer);
            referencedInIndicators.add(indicator);
        }
        return referencedInIndicators;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfIndicator(File metadataDumpPath, NameLinkReplacer indicatorNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedIn = new ArrayList<MdObjectDumpDTO>();
        List<MdObjectDumpDTO> allDashboards = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.DASHBOARD);
        List<MdObjectDumpDTO> allViews = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.VIEW);
        for (MdObjectDumpDTO dashboard : allDashboards) {
            DashboardContentDTO dashboardContent = (DashboardContentDTO)dashboard.getContent().getContent();
            for (IndicatorLinkDTO indicatorLink : dashboardContent.getIndicators()) {
                if (!indicatorNameReplacer.endsWithOldName(indicatorLink.getIndicator())) continue;
                this.replaceURILinksInDashboard(dashboardContent, indicatorNameReplacer);
                referencedIn.add(dashboard);
            }
        }
        for (MdObjectDumpDTO view : allViews) {
            ViewContentDTO viewContent = (ViewContentDTO)view.getContent().getContent();
            for (FilterAbstractType filter : viewContent.getFilterGroup()) {
                IndicatorFilterDTO indicatorFilter;
                if (!filter.getType().equals("indicator") || !indicatorNameReplacer.endsWithOldName((indicatorFilter = (IndicatorFilterDTO)filter).getIndicator())) continue;
                this.replaceURILinksInView(viewContent, indicatorNameReplacer);
                referencedIn.add(view);
            }
        }
        return referencedIn;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfIndicatorDrill(File metadataDumpPath, NameLinkReplacer indicatorDrillNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedInDashboards = new ArrayList<MdObjectDumpDTO>();
        List<MdObjectDumpDTO> allDashboards = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.DASHBOARD);
        for (MdObjectDumpDTO dashboard : allDashboards) {
            DashboardContentDTO dashboardContent = (DashboardContentDTO)dashboard.getContent().getContent();
            for (IndicatorLinkDTO indicatorLink : dashboardContent.getIndicators()) {
                if (!indicatorDrillNameReplacer.endsWithOldName(indicatorLink.getIndicatorDrill())) continue;
                this.replaceURILinksInDashboard(dashboardContent, indicatorDrillNameReplacer);
                referencedInDashboards.add(dashboard);
            }
        }
        return referencedInDashboards;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfDataset(File metadataDumpPath, NameLinkReplacer datasetNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedIn = new ArrayList<MdObjectDumpDTO>();
        List<MdObjectDumpDTO> allMarkerSelectors = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.MARKER_SELECTOR);
        List<MdObjectDumpDTO> allViews = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.VIEW);
        List<MdObjectDumpDTO> allDatasets = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.DATASET);
        for (MdObjectDumpDTO markerSelector : allMarkerSelectors) {
            MarkerSelectorContentDTO markerSelectorContent = (MarkerSelectorContentDTO)markerSelector.getContent().getContent();
            for (CategoryDTO category : markerSelectorContent.getCategories()) {
                if (datasetNameReplacer.endsWithOldName(category.getDataset())) {
                    this.replaceURILinksInMarkerSelector(markerSelectorContent, datasetNameReplacer);
                    referencedIn.add(markerSelector);
                }
                if (category.getLinkedLayers() == null) continue;
                for (LinkedLayerDTO linkedLayer : category.getLinkedLayers()) {
                    if (!datasetNameReplacer.endsWithOldName(linkedLayer.getDataset())) continue;
                    this.replaceURILinksInMarkerSelector(markerSelectorContent, datasetNameReplacer);
                    referencedIn.add(markerSelector);
                }
            }
        }
        for (MdObjectDumpDTO view : allViews) {
            boolean atLeastOneRename = false;
            ViewContentDTO viewContent = (ViewContentDTO)view.getContent().getContent();
            String defaultGranularityLink = viewContent.getDefaultGranularity();
            if (defaultGranularityLink != null && datasetNameReplacer.endsWithOldName(defaultGranularityLink)) {
                this.replaceURILinksInView(viewContent, datasetNameReplacer);
                atLeastOneRename = true;
            }
            List filterGroup = viewContent.getFilterGroup();
            for (FilterAbstractType filter : filterGroup) {
                DefaultValuesNumberDTO defaultValues;
                String granularity;
                IndicatorFilterDTO indicatorFilter;
                if (!filter.getType().equals("indicator") || (indicatorFilter = (IndicatorFilterDTO)filter).getDefaultValues() == null || (granularity = (defaultValues = indicatorFilter.getDefaultValues()).getGranularity()) == null || !datasetNameReplacer.endsWithOldName(granularity)) continue;
                defaultValues.setGranularity(datasetNameReplacer.replace(defaultValues.getGranularity()));
                atLeastOneRename = true;
            }
            if (!atLeastOneRename) continue;
            referencedIn.add(view);
        }
        for (MdObjectDumpDTO datasetDump : allDatasets) {
            DatasetDwhTypeDTO datasetRef;
            DatasetDTO dataset = (DatasetDTO)datasetDump.getContent();
            if (!dataset.getRef().getType().equals("dwh") || (datasetRef = (DatasetDwhTypeDTO)dataset.getRef()).getGeometry() == null || !datasetNameReplacer.getOldName().equals(datasetRef.getGeometry())) continue;
            datasetRef.setGeometry(datasetNameReplacer.getNewName());
            referencedIn.add(datasetDump);
        }
        return referencedIn;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfDashboard(File metadataDumpPath, NameLinkReplacer dashboardNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedInViews = new ArrayList<MdObjectDumpDTO>();
        List<MdObjectDumpDTO> allViews = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.VIEW);
        for (MdObjectDumpDTO view : allViews) {
            ViewContentDTO viewContent = (ViewContentDTO)view.getContent().getContent();
            if (!dashboardNameReplacer.endsWithOldName(viewContent.getDashboard())) continue;
            this.replaceURILinksInView(viewContent, dashboardNameReplacer);
            referencedInViews.add(view);
        }
        return referencedInViews;
    }

    protected List<MdObjectDumpDTO> replaceURIReferencesOfMarkerSelector(File metadataDumpPath, NameLinkReplacer markerSelectorNameReplacer) throws IOException {
        ArrayList<MdObjectDumpDTO> referencedInViews = new ArrayList<MdObjectDumpDTO>();
        List<MdObjectDumpDTO> allViews = this.loadMdObjectTypeDumps(metadataDumpPath, MdObjectDTO.Type.VIEW);
        for (MdObjectDumpDTO view : allViews) {
            ViewContentDTO viewContent = (ViewContentDTO)view.getContent().getContent();
            String markerSelectorLink = viewContent.getMarkerSelector();
            if (markerSelectorLink == null || !markerSelectorNameReplacer.endsWithOldName(markerSelectorLink)) continue;
            this.replaceURILinksInView(viewContent, markerSelectorNameReplacer);
            referencedInViews.add(view);
        }
        return referencedInViews;
    }
}

