/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.md.rest.dto.MdObjectsDTO;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.CleverAnalyticsShellException;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.stereotype.Component;

@Component
public class TruncateProjectCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(TruncateProjectCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public TruncateProjectCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"truncateProject"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"truncateProject"}, help="Delete all metadata objects from the project.")
    public void truncateProjectCmd() {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            for (String objectType : MdObjectType.getList()) {
                if (objectType.equals("datasets")) {
                    this.deleteDatasets(this.context.getCurrentProject());
                    continue;
                }
                this.deleteMdObjects(this.context.getCurrentProject(), objectType);
            }
            logger.error("");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    private void deleteMdObjects(String projectId, String mdObjectType) {
        MdObjectClient mdObjectClient = new MdObjectClient((CanRestClient)this.context.getCanRestClient());
        MdObjectsDTO mdObjects = mdObjectClient.getMdObjects(projectId, mdObjectType);
        if (mdObjects.size() > 0) {
            logger.error("\nDeleting {}:", (Object)mdObjectType);
            for (MdObjectDTO mdObject : mdObjects) {
                try {
                    mdObjectClient.deleteMdObjectById(projectId, mdObject.getType().toStringPlural(), mdObject.getId());
                    logger.error("Deleted {} name={}", (Object)mdObject.getType().toStringSingular(), (Object)mdObject.getName());
                }
                catch (Exception ex) {
                    logger.error("Failed to delete {} name={}", (Object)mdObject.getType().toStringSingular(), (Object)mdObject.getId());
                }
            }
        }
    }

    private void deleteDatasets(String projectId) {
        MdObjectClient mdObjectClient = new MdObjectClient((CanRestClient)this.context.getCanRestClient());
        MdObjectsDTO datasets = mdObjectClient.getMdObjects(projectId, "datasets");
        ArrayList workingArray = new ArrayList(datasets);
        if (datasets.size() > 0) {
            logger.error("\nDeleting {}:", (Object)"datasets");
            while (!workingArray.isEmpty()) {
                boolean iterationSuccessful = false;
                for (MdObjectDTO dataset : datasets) {
                    try {
                        mdObjectClient.deleteMdObjectById(projectId, "datasets", dataset.getId());
                        logger.error("Deleted dataset name={}", (Object)dataset.getName());
                        workingArray.remove(dataset);
                        iterationSuccessful = true;
                    }
                    catch (Exception exception) {}
                }
                if (iterationSuccessful) continue;
                throw new CleverAnalyticsShellException("Failed to automatically delete datasets. Try to remove them one by one using 'removeMetadata --objectName {datasetName}'.");
            }
        }
    }
}

