/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class CopyMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(CopyMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public CopyMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"copyMetadata"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"copyMetadata"}, help="Create a copy of existing wrapped object, unwrap it and rename it.")
    public void copyMetadataCmd(@CliOption(key={"objectName"}, mandatory=true, help="Name of the existing object from which the copy the copy will be created.") String objectName, @CliOption(key={"newName"}, mandatory=true, help="Name of the new object.") String newName) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            String oldObjectName = FileTools.appendExtension(objectName, ".json");
            String newObjectName = FileTools.appendExtension(newName, ".json");
            File fileToCopy = FileTools.findMetadataInDump(this.context, objectName);
            if (fileToCopy == null) {
                logger.error("Metadata object {} was not found in dump {}\n", (Object)objectName, (Object)this.context.getCurrentDump());
                logger.error("Can't create a copy of this object\n");
            } else {
                this.createObjectCopy(fileToCopy, oldObjectName, newObjectName);
            }
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected void createObjectCopy(File file, String oldNameWithExt, String newNameWithExt) throws IOException {
        MdShellClient mdShellClient = (MdShellClient)this.context.getShellClient();
        String newNameWithoutExt = FilenameUtils.removeExtension((String)newNameWithExt);
        mdShellClient.mdObjectNameCheck(newNameWithoutExt);
        File alreadyNamedFile = FileTools.findMetadataInDump(this.context, newNameWithoutExt);
        if (alreadyNamedFile != null) {
            throw new FileAlreadyExistsException("File=" + newNameWithExt + " already exists in dump=" + this.context.getCurrentDump());
        }
        if (FileTools.isValidMdObjectDump(file)) {
            DatasetDTO copy;
            MdObjectDumpDTO mdObjectDump = FileTools.loadFileAsMdObjectDump(file);
            MdObjectDTO original = mdObjectDump.getContent();
            if (original.getType().equals((Object)MdObjectDTO.Type.DATASET)) {
                copy = new DatasetDTO();
                copy.setOrigin(original.getOrigin());
                copy.setProperties(((DatasetDTO)original).getProperties());
                copy.setRef(((DatasetDTO)original).getRef());
            } else {
                copy = new MdObjectDTO();
                copy.setContent(original.getContent());
            }
            copy.setName(FilenameUtils.removeExtension((String)newNameWithExt));
            copy.setType(original.getType());
            copy.setTitle(original.getTitle());
            copy.setDescription(original.getDescription());
            String parentDir = FilenameUtils.getFullPath((String)file.getAbsolutePath());
            String newPath = Paths.get(parentDir, newNameWithExt).toString();
            FileTools.saveObjectToJson(copy, newPath);
            File newFile = new File(FileTools.appendExtension(newPath, ".json"));
            if (newFile.exists()) {
                logger.error("Object {} successfully created as a copy of object {}\n", (Object)newNameWithExt, (Object)oldNameWithExt);
            } else {
                logger.error("Failed to create a copy of object {}\n", (Object)oldNameWithExt);
            }
        } else {
            logger.error("Object {} is not a valid object dump, cannot create copy of it\n", (Object)oldNameWithExt);
        }
    }
}

