/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.shell.client.LinkReplacer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderLinkReplacer
implements LinkReplacer {
    private final String placeholder = "\\$projectId";
    private final Pattern placeholderPattern = Pattern.compile("\\$projectId");
    private String newProjectId;
    private String objectName;

    public PlaceholderLinkReplacer(String projectId, String objectName) {
        this.newProjectId = projectId;
        this.objectName = objectName;
    }

    @Override
    public String replace(String input) {
        Matcher matcher;
        String replaced = null;
        if (input != null && input.equals(replaced = (matcher = this.placeholderPattern.matcher(input)).replaceFirst(this.newProjectId))) {
            System.out.println("\nWarning: failed to replace placeholder in URL=" + input + " of object=" + this.objectName);
            System.out.println("Check if the placeholder in the url matches correct placeholder syntax=$projectId");
        }
        return replaced;
    }
}

