/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.md.rest.dto.MdObjectType;
import com.cleveranalytics.service.metadata.rest.dto.FileList;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.MetadataShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class StatusCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(StatusCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;
    private static final String LOCALLY_MODIFIED = "modified locally";
    private static final String MODIFIED_ON_SERVER = "modified on the server";

    @Autowired
    public StatusCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"status"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"status"}, help="List status of local files and files on the server.")
    public void statusCmd(@CliOption(key={"remote"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="List all objects located on the server.") boolean remote) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            StringBuilder output = new StringBuilder();
            if (!remote) {
                System.out.println(this.printFirstLineStatus());
                File metadataDumpDirectory = this.context.getMetadataDumpPath().toFile();
                List<File> allMetadataFiles = FileTools.findAllMetadataInDump(metadataDumpDirectory);
                List<File> unmappableMetadataFiles = FileTools.filterMappableMetadataFiles(allMetadataFiles);
                List<File> mappableMetadataFiles = FileTools.filterUnmappableMetadataFiles(allMetadataFiles);
                List<File> unwrappedMetadataFiles = FileTools.filterWrappedMetadataFiles(mappableMetadataFiles);
                List<File> newMetadataFiles = FileTools.filterFilesPresentInMd5List(this.context, unwrappedMetadataFiles);
                List<File> locallyModifiedMetadata = FileTools.findModifiedMetadataInDump(this.context, metadataDumpDirectory);
                Map<File, Long> modifiedOnServer = FileTools.findModifiedMetadataOnServer(this.context, metadataDumpDirectory);
                File dataDumpDirectory = this.context.getDataDumpPath().toFile();
                List<File> newDataFiles = FileTools.findNewDataInDump(dataDumpDirectory);
                List<File> locallyModifiedData = FileTools.findModifiedDataInDump(this.context, dataDumpDirectory);
                modifiedOnServer = new TreeMap<File, Long>(modifiedOnServer);
                Collections.sort(mappableMetadataFiles);
                Collections.sort(newMetadataFiles);
                Collections.sort(locallyModifiedMetadata);
                Collections.sort(newDataFiles);
                Collections.sort(locallyModifiedData);
                ArrayList<File> newFiles = new ArrayList<File>();
                ArrayList<File> locallyModified = new ArrayList<File>();
                newFiles.addAll(newMetadataFiles);
                newFiles.addAll(newDataFiles);
                locallyModified.addAll(locallyModifiedMetadata);
                locallyModified.addAll(locallyModifiedData);
                if (unmappableMetadataFiles.size() > 0) {
                    output.append((CharSequence)this.printUnmappableFiles(unmappableMetadataFiles));
                }
                for (File file : newFiles) {
                    if (locallyModified.contains(file)) {
                        locallyModified.remove(file);
                    }
                    if (!modifiedOnServer.containsKey(file)) continue;
                    modifiedOnServer.remove(file);
                }
                if (locallyModified.size() == 0 && modifiedOnServer.size() == 0 && newFiles.size() == 0) {
                    output.append((CharSequence)this.printAllFilesUpToDate());
                } else {
                    if (locallyModified.size() == 0) {
                        output.append((CharSequence)this.printNoFilesModified(LOCALLY_MODIFIED, newFiles.size() > 0 || modifiedOnServer.size() > 0));
                    } else {
                        output.append((CharSequence)this.printModifiedLocally(locallyModified));
                    }
                    if (modifiedOnServer.size() == 0) {
                        output.append((CharSequence)this.printNoFilesModified(MODIFIED_ON_SERVER, newFiles.size() > 0 || modifiedOnServer.size() > 0));
                    } else {
                        output.append((CharSequence)this.printModifiedOnServer(modifiedOnServer));
                    }
                    if (locallyModified.size() > 0 && modifiedOnServer.size() > 0) {
                        ArrayList<File> modifiedOnServerList = new ArrayList<File>(modifiedOnServer.keySet());
                        output.append((CharSequence)this.printConflictFiles(locallyModified, modifiedOnServerList));
                    }
                    if (newFiles.size() > 0) {
                        output.append((CharSequence)this.printNewFiles(newFiles, modifiedOnServer.size() > 0));
                    }
                }
            } else {
                System.out.println(this.printFirstLineServer());
                System.out.println(this.printServerContent());
            }
            System.out.println(output);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected StringBuilder printFirstLineStatus() {
        StringBuilder output = new StringBuilder();
        output.append("Checking status of project ");
        output.append(this.context.getCurrentProject());
        output.append(" (");
        output.append(this.context.getProjectTitle());
        output.append(") ");
        output.append("against dump ");
        output.append(this.context.getCurrentDump());
        output.append("...\n");
        return output;
    }

    protected StringBuilder printFirstLineServer() {
        StringBuilder output = new StringBuilder();
        output.append("Checking project ");
        output.append(this.context.getCurrentProject());
        output.append(" (");
        output.append(this.context.getProjectTitle());
        output.append(") ");
        output.append("metadata content on ");
        output.append(this.context.getConnectedServerRelativeUrl());
        output.append("...\n");
        return output;
    }

    protected StringBuilder printAllFilesUpToDate() {
        StringBuilder output = new StringBuilder();
        output.append("All files are up to date with project ");
        output.append(this.context.getCurrentProject());
        output.append("\n");
        return output;
    }

    protected StringBuilder printNoFilesModified(String phrase, boolean newLine) {
        StringBuilder output = new StringBuilder();
        output.append("No files have been ");
        output.append(phrase);
        output.append("\n");
        if (newLine) {
            output.append("\n");
        }
        return output;
    }

    protected StringBuilder printUnmappableFiles(List<File> unmappableFiles) throws IOException {
        StringBuilder output = new StringBuilder();
        output.append(unmappableFiles.size());
        output.append(unmappableFiles.size() == 1 ? " file" : " files");
        output.append(unmappableFiles.size() == 1 ? " contains" : " contain");
        output.append(" syntax errors and/or constraint violations:\n");
        for (File file : unmappableFiles) {
            output.append("\t");
            output.append(file.getAbsolutePath());
            output.append("\n");
        }
        output.append("\n");
        return output;
    }

    protected StringBuilder printModifiedLocally(List<File> modifiedFiles) throws IOException {
        StringBuilder output = new StringBuilder();
        output.append(modifiedFiles.size());
        output.append(modifiedFiles.size() == 1 ? " file" : " files");
        output.append(modifiedFiles.size() == 1 ? " has been " : " have been ");
        output.append(LOCALLY_MODIFIED);
        output.append(":\n");
        for (File file : modifiedFiles) {
            output.append("\t");
            output.append(file.getAbsolutePath());
            output.append("\n");
        }
        output.append("\n");
        return output;
    }

    protected StringBuilder printModifiedOnServer(Map<File, Long> modifiedFiles) throws IOException {
        StringBuilder output = new StringBuilder();
        output.append(modifiedFiles.size());
        output.append(modifiedFiles.size() == 1 ? " file" : " files");
        output.append(modifiedFiles.size() == 1 ? " has been " : " have been ");
        output.append(MODIFIED_ON_SERVER);
        output.append(":\n");
        for (Map.Entry<File, Long> entry : modifiedFiles.entrySet()) {
            output.append("\t");
            if (entry.getValue() == -1L) {
                output.append("(deleted) ");
            }
            output.append(entry.getKey().getAbsolutePath());
            output.append("\n");
        }
        return output;
    }

    protected StringBuilder printConflictFiles(List<File> locallyModified, List<File> modifiedOnServer) {
        StringBuilder output = new StringBuilder();
        ArrayList<File> conflictFiles = new ArrayList<File>();
        for (File file : locallyModified) {
            if (!modifiedOnServer.contains(file)) continue;
            conflictFiles.add(file);
        }
        if (conflictFiles.size() > 0) {
            output.append("\n");
            output.append(conflictFiles.size());
            output.append(conflictFiles.size() == 1 ? " file" : " files");
            output.append(conflictFiles.size() == 1 ? " has been " : " have been ");
            output.append("modified both locally, and on the server:\n");
            for (File file : conflictFiles) {
                output.append("\t");
                output.append(file.getAbsolutePath());
                output.append("\n");
            }
        }
        return output;
    }

    protected StringBuilder printNewFiles(List<File> newFiles, boolean newLine) {
        StringBuilder output = new StringBuilder();
        if (newLine) {
            output.append("\n");
        }
        output.append(newFiles.size());
        output.append(" new");
        output.append(newFiles.size() == 1 ? " file" : " files");
        output.append(newFiles.size() == 1 ? " has been " : " have been ");
        output.append("detected:");
        for (File file : newFiles) {
            output.append("\n\t");
            output.append(file.getAbsolutePath());
        }
        output.append("\n");
        return output;
    }

    protected StringBuilder printServerContent() throws IOException {
        StringBuilder output = new StringBuilder();
        AbstractShellClient shellClient = this.context.getShellClient();
        FileList fileList = shellClient.getObjectsList(this.context);
        if (shellClient instanceof MetadataShellClient) {
            output.append((CharSequence)this.printMetadataList(fileList));
        } else if (shellClient instanceof MdShellClient) {
            output.append((CharSequence)this.printMdList(fileList));
        }
        return output;
    }

    protected StringBuilder printMdList(FileList fileList) {
        StringBuilder output = new StringBuilder();
        for (String mdObjectType : MdObjectType.getList()) {
            List nameList = fileList.getObjectsList(mdObjectType);
            output.append(mdObjectType);
            output.append(":\n\t");
            if (nameList.size() > 0) {
                Collections.sort(nameList);
                for (int i = 0; i < nameList.size(); ++i) {
                    output.append((String)nameList.get(i));
                    if (i < nameList.size() - 1) {
                        output.append("\n\t");
                        continue;
                    }
                    if (mdObjectType.equals("views")) continue;
                    output.append("\n\t\n");
                }
                continue;
            }
            output.append("[no objects]");
            if (mdObjectType.equals("views")) continue;
            output.append("\n\n");
        }
        return output;
    }

    protected StringBuilder printMetadataList(FileList fileList) {
        StringBuilder output = new StringBuilder();
        output.append("datasets:\n\t");
        output.append((String)fileList.getObjectsList("datasets").get(0));
        output.append("\n\nfeatureCollections:\n");
        for (String featureCollection : fileList.getObjectsList("featureCollections")) {
            output.append("\t");
            output.append(featureCollection);
            output.append("\n");
        }
        output.append("\nuiComponents:\n");
        for (String uiComponent : fileList.getObjectsList("uicomponents")) {
            output.append("\t");
            output.append(uiComponent);
            output.append("\n");
        }
        output.append("\ndetails:\n");
        for (String detail : fileList.getObjectsList("details")) {
            output.append("\t");
            output.append(detail);
            output.append("\n");
        }
        output.append("\nmapOptions:\n\t");
        output.append((String)fileList.getObjectsList("mapOptions").get(0));
        return output;
    }
}

