/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.client;

import com.cleveranalytics.common.jobs.steps.DataDumpRequest;
import com.cleveranalytics.common.jobs.steps.ValidateRequest;
import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.service.dwh.client.DwhClient;
import com.cleveranalytics.service.dwh.rest.dto.DataCreateUploadResponse;
import com.cleveranalytics.service.dwh.rest.dto.DataDumpResponse;
import com.cleveranalytics.service.dwh.rest.dto.DataPullRequest;
import com.cleveranalytics.service.dwh.rest.dto.DataValidator;
import com.cleveranalytics.service.dwh.rest.dto.DumpDatasetContentResponse;
import com.cleveranalytics.service.dwh.rest.dto.DumpDatasetRequest;
import com.cleveranalytics.service.dwh.rest.dto.DumpDatasetsRequest;
import com.cleveranalytics.service.dwh.rest.dto.DwhValidateRequest;
import com.cleveranalytics.service.dwh.rest.dto.DwhValidateResponse;
import com.cleveranalytics.service.dwh.rest.dto.DwhValidateViolation;
import com.cleveranalytics.service.dwh.rest.dto.ModelValidator;
import com.cleveranalytics.service.job.JobDetailResponse;
import com.cleveranalytics.service.job.client.JobClient;
import com.cleveranalytics.service.job.dto.GeneralJobRequest;
import com.cleveranalytics.service.job.type.DataDumpJobRequest;
import com.cleveranalytics.service.job.type.DataPullJobRequest;
import com.cleveranalytics.service.job.type.ValidateJobRequest;
import com.cleveranalytics.service.md.util.MdObjectMapper;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasetDTO;
import com.cleveranalytics.service.metadata.rest.dto.dataset.IDatasets;
import com.cleveranalytics.shell.ExecutionType;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;

public class DwhShellClient {
    private static final Logger logger = LoggerFactory.getLogger(DwhShellClient.class);
    private final ObjectMapper mapper = new MdObjectMapper();
    private DwhClient dwhClient;

    public DwhShellClient(CanRestClient canRestClient) {
        this.dwhClient = new DwhClient(canRestClient);
    }

    public ExecutionType convertExecutionType(String executionType) throws IllegalArgumentException {
        try {
            return ExecutionType.fromValue(executionType);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid 'execution' parameter=" + executionType + ". Supported values are=" + Arrays.toString((Object[])ExecutionType.values()));
        }
    }

    public void dumpData(ShellContext context, ExecutionType executionType, IDatasets<IDatasetDTO> dwhDatasets) throws IOException {
        List<DumpDatasetContentResponse> dumpResponses;
        String projectId = context.getCurrentProject();
        try {
            dumpResponses = executionType.equals((Object)ExecutionType.ASYNCHRONOUS) ? this.performAsynchronousDump(context, dwhDatasets) : this.performSynchronousDump(context, dwhDatasets);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
        for (DumpDatasetContentResponse response : dumpResponses) {
            String datasetName = response.getDataset();
            if (!((Link)response.getLinks().get(0)).getRel().equals("self")) {
                throw new IOException("Failed to obtain CSV dump link.");
            }
            String csvDumpLink = ((Link)response.getLinks().get(0)).getHref();
            String bearerToken = context.getCanRestClient().refreshAccessToken();
            String csvFilePath = Paths.get(context.getDataDumpPath().toString(), datasetName).toString();
            csvFilePath = FileTools.appendExtension(csvFilePath, ".csv");
            this.dwhClient.getCsv(projectId, csvFilePath, csvDumpLink, bearerToken);
            this.checkDumpedFile(context, new File(csvFilePath), datasetName);
        }
    }

    protected List<DumpDatasetContentResponse> performAsynchronousDump(ShellContext context, IDatasets<IDatasetDTO> dwhDatasets) throws IOException, InterruptedException {
        ArrayList<DumpDatasetContentResponse> dumpResponses = new ArrayList<DumpDatasetContentResponse>();
        logger.error("Asynchronous data dump started...\n");
        for (IDatasetDTO dwhDataset : dwhDatasets) {
            DumpDatasetRequest dumpDatasetRequest = this.createDumpDatasetRequest(dwhDataset);
            DataDumpJobRequest dataDumpJobRequest = this.convertToJobDataDumpRequest(context.getCurrentProject(), dumpDatasetRequest);
            JobClient jobClient = new JobClient((CanRestClient)context.getCanRestClient());
            JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)dataDumpJobRequest);
            if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
                DumpDatasetContentResponse asyncResponse = (DumpDatasetContentResponse)this.mapper.convertValue(jobResponse.getResult(), DumpDatasetContentResponse.class);
                dumpResponses.add(asyncResponse);
                continue;
            }
            throw new IOException("Data dump failed with status=" + jobResponse.getStatus() + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId());
        }
        return dumpResponses;
    }

    protected List<DumpDatasetContentResponse> performSynchronousDump(ShellContext context, IDatasets<IDatasetDTO> dwhDatasets) throws IOException, InterruptedException {
        logger.error("Synchronous data dump started...\n");
        DumpDatasetsRequest dumpDatasetsRequest = this.createDumpDatasetsRequest(dwhDatasets);
        DataDumpResponse syncResponses = this.dwhClient.dumpAllCsvs(context.getCurrentProject(), dumpDatasetsRequest);
        return syncResponses.getContent();
    }

    protected DumpDatasetsRequest createDumpDatasetsRequest(IDatasets<IDatasetDTO> dwhDatasets) {
        DumpDatasetsRequest datasetsRequest = new DumpDatasetsRequest();
        for (IDatasetDTO dataset : dwhDatasets) {
            DumpDatasetRequest request = new DumpDatasetRequest();
            request.setDataset(dataset.getName());
            datasetsRequest.add((Object)request);
        }
        return datasetsRequest;
    }

    protected DumpDatasetRequest createDumpDatasetRequest(IDatasetDTO dwhDataset) {
        return new DumpDatasetRequest().withDataset(dwhDataset.getName());
    }

    protected DataDumpJobRequest convertToJobDataDumpRequest(String projectId, DumpDatasetRequest dwhDataDumpRequest) throws IOException {
        try {
            String dwhDataDumpRequestString = this.mapper.writeValueAsString((Object)dwhDataDumpRequest);
            DataDumpRequest stepsDataDumpRequest = (DataDumpRequest)this.mapper.readValue(dwhDataDumpRequestString, DataDumpRequest.class);
            return new DataDumpJobRequest().withType("dataDump").withProjectId(projectId).withContent(stepsDataDumpRequest);
        }
        catch (IOException ex) {
            throw new IOException("Failed to convert DWH data dump request to job data dump request.");
        }
    }

    public void checkDumpedFile(ShellContext context, File csv, String datasetName) throws IOException {
        if (!csv.exists()) {
            throw new IOException("Failed to dump CSV file " + csv.getAbsolutePath());
        }
        AbstractShellClient shellClient = context.getShellClient();
        shellClient.putDataChecksumListElement(context, csv);
        logger.error("DWH data of dataset {} successfully dumped to {}", (Object)datasetName, (Object)csv.getName());
    }

    public void loadData(ShellContext context, ExecutionType executionType, String datasetName, DataPullRequest.Mode mode, File csvFile) throws IOException {
        try {
            if (executionType.equals((Object)ExecutionType.ASYNCHRONOUS)) {
                this.performAsynchronousLoad(context, csvFile, datasetName, mode);
            } else {
                this.performSynchronousLoad(context, csvFile, datasetName, mode);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
    }

    protected void performAsynchronousLoad(ShellContext context, File csvFile, String datasetName, DataPullRequest.Mode mode) throws IOException, InterruptedException {
        DataPullRequest dataPullRequest;
        AbstractShellClient shellClient = context.getShellClient();
        String projectId = context.getCurrentProject();
        DataCreateUploadResponse dataCreateUploadResponse = this.dwhClient.createFileUpload(projectId);
        this.dwhClient.uploadCsv(projectId, csvFile, dataCreateUploadResponse.getUploadUrl());
        String uploadLink = this.dwhClient.findSelfLink(dataCreateUploadResponse);
        try {
            dataPullRequest = this.createDataPullRequest(datasetName, mode, new URI(uploadLink));
        }
        catch (URISyntaxException ex) {
            throw new IOException("Failed to parse self link=" + uploadLink);
        }
        DataPullJobRequest dataPullJobRequest = this.convertToJobDataPullJobRequest(projectId, dataPullRequest);
        JobClient jobClient = new JobClient((CanRestClient)context.getCanRestClient());
        JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)dataPullJobRequest);
        if (!jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            throw new IOException("Data upload failed with status=" + jobResponse.getStatus() + "\nmessage=" + jobResponse.getMessage() + "\njob_id=" + jobResponse.getId());
        }
        shellClient.putDataChecksumListElement(context, csvFile);
        logger.error("CSV file {} successfully loaded into dataset {}", (Object)csvFile.getName(), (Object)datasetName);
    }

    protected void performSynchronousLoad(ShellContext context, File csvFile, String datasetName, DataPullRequest.Mode mode) throws IOException, InterruptedException {
        AbstractShellClient shellClient = context.getShellClient();
        this.dwhClient.loadCsvData(context.getCurrentProject(), csvFile, datasetName, mode);
        shellClient.putDataChecksumListElement(context, csvFile);
        logger.error("CSV file {} successfully loaded into dataset {}", (Object)csvFile.getName(), (Object)datasetName);
    }

    protected DataPullRequest createDataPullRequest(String datasetName, DataPullRequest.Mode mode, URI uploadUri) {
        return new DataPullRequest().withDataset(datasetName).withMode(mode).withUpload(uploadUri).withType(DataPullRequest.Type.CSV);
    }

    protected DataPullJobRequest convertToJobDataPullJobRequest(String projectId, DataPullRequest dwhDataPullRequest) throws IOException {
        try {
            String dwhDataPullRequestString = this.mapper.writeValueAsString((Object)dwhDataPullRequest);
            com.cleveranalytics.common.jobs.steps.DataPullRequest stepsDataPullRequest = (com.cleveranalytics.common.jobs.steps.DataPullRequest)this.mapper.readValue(dwhDataPullRequestString, com.cleveranalytics.common.jobs.steps.DataPullRequest.class);
            return new DataPullJobRequest().withType("dataPull").withProjectId(projectId).withContent(stepsDataPullRequest);
        }
        catch (IOException ex) {
            throw new IOException("Failed to convert DWH data pull request to job data pull request.");
        }
    }

    public Map<String, Integer> simpleProjectIntegrityCheck(UserCredentialsCanRestClient canRestClient, String projectId) throws IOException {
        System.out.printf("Validating DWH model/data integrity of project " + projectId + "... ", new Object[0]);
        DwhValidateResponse validateResponse = this.validateProjectIntegrity(canRestClient, projectId, false, false, ExecutionType.ASYNCHRONOUS);
        HashMap<String, Integer> violationTypes = new HashMap<String, Integer>();
        for (DwhValidateViolation violation : validateResponse.getViolations()) {
            if (violationTypes.containsKey(violation.getViolationType())) {
                Integer violationCount;
                Integer n = violationCount = (Integer)violationTypes.get(violation.getViolationType());
                Integer n2 = violationCount = Integer.valueOf(violationCount + 1);
                violationTypes.put(violation.getViolationType(), violationCount);
                continue;
            }
            violationTypes.put(violation.getViolationType(), 1);
        }
        return violationTypes;
    }

    public DwhValidateResponse validateProjectIntegrity(UserCredentialsCanRestClient canRestClient, String projectId, boolean skipModel, boolean skipData, ExecutionType executionType) throws IOException {
        DwhValidateRequest validateRequest = new DwhValidateRequest();
        if (!skipModel) {
            validateRequest.setModelValidator(new ModelValidator());
        }
        if (!skipData) {
            validateRequest.setDataValidator(new DataValidator());
        }
        try {
            if (executionType.equals((Object)ExecutionType.ASYNCHRONOUS)) {
                return this.performAsynchronousValidation(canRestClient, projectId, validateRequest);
            }
            return this.dwhClient.performSynchronousValidation(projectId, validateRequest);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sleep thread interrupted.");
        }
    }

    protected DwhValidateResponse performAsynchronousValidation(UserCredentialsCanRestClient canRestClient, String projectId, DwhValidateRequest dwhValidateRequest) throws IOException, InterruptedException {
        JobClient jobClient = new JobClient((CanRestClient)canRestClient);
        ValidateJobRequest validateJobRequest = this.convertToJobValidateRequest(projectId, dwhValidateRequest);
        JobDetailResponse jobResponse = jobClient.executeJob((GeneralJobRequest)validateJobRequest);
        if (jobResponse.getStatus().equals((Object)JobDetailResponse.Status.SUCCEEDED)) {
            String dwhValidateResponseResult = this.mapper.writeValueAsString(jobResponse.getResult());
            return (DwhValidateResponse)this.mapper.readValue(dwhValidateResponseResult, DwhValidateResponse.class);
        }
        throw new IOException("Project validation job failed with status=" + jobResponse.getStatus() + " message=" + jobResponse.getMessage() + "\n");
    }

    protected ValidateJobRequest convertToJobValidateRequest(String projectId, DwhValidateRequest dwhValidateRequest) throws IOException {
        try {
            String dwhValidateRequestString = this.mapper.writeValueAsString((Object)dwhValidateRequest);
            ValidateRequest stepsValidateRequest = (ValidateRequest)this.mapper.readValue(dwhValidateRequestString, ValidateRequest.class);
            return new ValidateJobRequest().withType("validate").withProjectId(projectId).withContent(stepsValidateRequest);
        }
        catch (IOException ex) {
            throw new IOException("Failed to convert DWH data pull request to job data pull request.");
        }
    }
}

