/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.dump;

import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.metadata.rest.dto.FileList;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;

@Component
public class RemoveMetadataCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(RemoveMetadataCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public RemoveMetadataCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"removeMetadata"})
    public boolean isCommandAvailable() {
        return this.context.getCurrentDump() != null;
    }

    @CliCommand(value={"removeMetadata"}, help="Remove metadata object from the server and current dump.")
    public void removeMetadataCmd(@CliOption(key={"objectName"}, mandatory=true, help="Name of the metadata object to be removed from the server and the current dump (with or without \".json\" extension).") String inputName) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            this.removeObject(inputName);
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    protected void removeObject(String objectName) throws IOException {
        logger.error("Removing object {} from project {}...\n", (Object)objectName, (Object)this.context.getCurrentProject());
        AbstractShellClient shellClient = this.context.getShellClient();
        FileList fileList = shellClient.getObjectsList(this.context);
        objectName = FilenameUtils.removeExtension((String)objectName);
        String object = fileList.contains(objectName);
        if (object != null) {
            this.removeObjectRemotely(shellClient, objectName, object);
            this.removeObjectLocally(objectName);
            File metadataObjectFile = Paths.get(this.context.getMetadataDumpPath().toString(), object, objectName).toFile();
            shellClient.removeMetadataChecksumListElement(this.context, metadataObjectFile);
        } else {
            logger.error("Object {} not found on the in the project, no local files were deleted\n", (Object)objectName);
        }
    }

    protected void removeObjectLocally(String objectName) throws IOException {
        File fileToDelete = FileTools.findMetadataInDump(this.context, objectName);
        if (fileToDelete.exists()) {
            FileSystemUtils.deleteRecursively((File)fileToDelete);
            if (!fileToDelete.exists()) {
                logger.error("Local file {} successfully deleted\n", (Object)fileToDelete.getName());
            } else {
                logger.error("Failed to delete local file {}\n", (Object)fileToDelete.getName());
            }
        } else {
            logger.error("File {} was not found in dump {}\n", (Object)fileToDelete.getName(), (Object)this.context.getCurrentDump());
        }
    }

    protected void removeObjectRemotely(AbstractShellClient shellClient, String objectName, String type) throws IOException {
        shellClient.removeObject(this.context.getCurrentProject(), type, objectName);
        logger.error("Remote object {} successfully deleted from the project", (Object)FilenameUtils.removeExtension((String)objectName));
    }
}

