/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.config;

import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.dto.OlderVersionDTO;
import com.cleveranalytics.shell.dto.VersionInfoDTO;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultBannerProvider;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Order(value=-2147483648)
public class BannerProvider
extends DefaultBannerProvider {
    private static final Logger logger = LoggerFactory.getLogger(BannerProvider.class);
    @Value(value="${version}")
    private final String version;
    private ShellContext context;
    private static final String VERSIONS_RESOURCE_URL = "https://secure.cleveranalytics.com/shell/versions";
    private final String versionCheckFailedMessage = "Failed to fetch info about latest Shell versions. \nPlease make sure that you use the latest version: https://clevermaps.atlassian.net/wiki/spaces/CDD/pages/214761716/Download\n";
    private final String olderVersionMessage = "You are using an old version of CleverAnalytics Shell.\nVersion {latestVersion} is out, download here: https://clevermaps.atlassian.net/wiki/spaces/CDD/pages/214761716/Download\n\n";

    @Autowired
    public BannerProvider(ShellContext context) {
        this.version = null;
        this.context = context;
    }

    public String getBanner() {
        StringBuilder builder = new StringBuilder();
        builder.append("\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502            \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502            \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502            \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502 CLEVER\u00b0    \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502 ANALYTICS' \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2502            \u2502");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518");
        builder.append(OsUtils.LINE_SEPARATOR);
        builder.append("Version: ");
        builder.append(this.getVersion());
        builder.append(OsUtils.LINE_SEPARATOR);
        return builder.toString();
    }

    public String getWelcomeMessage() {
        VersionInfoDTO versionInfo = this.getVersionsInfo();
        StringBuilder versionMessageBuilder = new StringBuilder();
        if (versionInfo == null) {
            versionMessageBuilder.append("Failed to fetch info about latest Shell versions. \nPlease make sure that you use the latest version: https://clevermaps.atlassian.net/wiki/spaces/CDD/pages/214761716/Download\n");
        } else {
            logger.debug("Successfully fetched version info from url={}", (Object)VERSIONS_RESOURCE_URL);
            String latestVersion = versionInfo.getLatestVersion().getVersion();
            if (this.equalVersions(this.getVersion(), latestVersion)) {
                versionMessageBuilder.append(versionInfo.getLatestVersion().getMessage());
                versionMessageBuilder.append("\n");
            } else {
                versionMessageBuilder.append("You are using an old version of CleverAnalytics Shell.\nVersion {latestVersion} is out, download here: https://clevermaps.atlassian.net/wiki/spaces/CDD/pages/214761716/Download\n\n".replace("{latestVersion}", latestVersion));
                versionMessageBuilder.append(this.getMissedChanges(versionInfo, this.getVersion()));
            }
        }
        return versionMessageBuilder.toString();
    }

    private VersionInfoDTO getVersionsInfo() {
        try {
            return (VersionInfoDTO)new RestTemplate().getForObject(VERSIONS_RESOURCE_URL, VersionInfoDTO.class, new Object[0]);
        }
        catch (Exception ex) {
            logger.debug("Failed to fetch version info from url={}", (Object)VERSIONS_RESOURCE_URL);
            return null;
        }
    }

    private boolean equalVersions(String thisVersion, String latestVersion) {
        thisVersion = this.extractVersionNumber(thisVersion);
        latestVersion = this.extractVersionNumber(latestVersion);
        return thisVersion != null && latestVersion != null && thisVersion.equals(latestVersion);
    }

    private String extractVersionNumber(String input) {
        Pattern numberPattern = Pattern.compile("^(\\d\\.\\d\\.\\d)(.*)$");
        Matcher matcher = numberPattern.matcher(input);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getMissedChanges(VersionInfoDTO versionInfo, String latestVersion) {
        StringBuilder missedChanges = new StringBuilder();
        for (OlderVersionDTO olderVersion : versionInfo.getOlderVersions()) {
            if (this.equalVersions(olderVersion.getVersion(), latestVersion)) break;
            for (String message : olderVersion.getMessages()) {
                missedChanges.append(olderVersion.getVersion());
                missedChanges.append(" - ");
                missedChanges.append(message);
                missedChanges.append("\n");
                if (!message.startsWith("FATAL")) continue;
                this.context.setIncompatibleVersion(true);
                this.context.setExitOnError(true);
            }
        }
        return missedChanges.toString();
    }

    public String getProviderName() {
        return "CleverAnalytics";
    }

    public String getVersion() {
        return this.version;
    }
}

