/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.commands.project;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.common.rest.util.ETag;
import com.cleveranalytics.common.rest.util.UriTool;
import com.cleveranalytics.service.dwh.rest.dto.DataPullRequest;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.md.client.MdObjectClient;
import com.cleveranalytics.service.md.rest.dto.MdObjectDTO;
import com.cleveranalytics.service.md.rest.dto.MdObjectDumpDTO;
import com.cleveranalytics.service.md.rest.dto.dataset.DatasetDTO;
import com.cleveranalytics.shell.ExecutionType;
import com.cleveranalytics.shell.FileTools;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.DwhShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.config.ShellContext;
import com.cleveranalytics.shell.exception.ShellExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class LoadCsvCommand
implements CommandMarker {
    static final Logger logger = LoggerFactory.getLogger(LoadCsvCommand.class);
    @Value(value="${service.name}")
    private String serviceName;
    private ShellContext context;

    @Autowired
    public LoadCsvCommand(ShellContext context) {
        this.context = context;
    }

    @CliAvailabilityIndicator(value={"loadCsv"})
    public boolean isCommandAvailable() {
        return this.context.getConnectedServer() != null && this.context.getLoggedUser() != null && this.context.getCurrentProject() != null;
    }

    @CliCommand(value={"loadCsv"}, help="Load CSV file into existing CleverAnalytics dataset.")
    public void loadCsvCmd(@CliOption(key={"dataset"}, mandatory=true, help="Name of the dataset where the data will be loaded.") String datasetName, @CliOption(key={"mode"}, mandatory=true, help="Data load mode. Allowed values=[\"full\", \"incremental\"]") String mode, @CliOption(key={"file"}, mandatory=true, help="Path to a CSV file to be loaded. If a dump is opened and contains some CSV files, file can be specified by using just the filename ('restaurants.csv') instead of full path") String file, @CliOption(key={"execution"}, mandatory=false, unspecifiedDefaultValue="async", help="Data load execution type. Allowed values=[\"async\", \"sync\"]") String execution) {
        try {
            MDC.put((String)"requestId", (String)UriTool.randomId());
            if (execution.equals("sync")) {
                logger.error("Synchronous data upload started...\n");
            } else {
                logger.error("Asynchronous data upload started...\n");
            }
            this.loadDataset(datasetName, mode, file, execution);
            logger.error("");
        }
        catch (Exception ex) {
            ShellExceptionHandler.handle(ex, this.context.isExitOnError());
        }
    }

    private void loadDataset(String datasetName, String mode, String file, String execution) throws IOException {
        File csvFile = this.getCsvFile(file);
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
        ExecutionType executionType = dwhShellClient.convertExecutionType(execution);
        DataPullRequest.Mode dataPullRequestMode = this.convertDataPullRequestMode(mode);
        this.loadData(csvFile, datasetName, dataPullRequestMode, executionType);
        AbstractShellClient shellClient = this.context.getShellClient();
        if (shellClient instanceof MdShellClient) {
            DatasetDTO fetchDataset = this.fetchDatasetAfterTableSwitch(datasetName);
            ((MdShellClient)shellClient).wrapAndSaveMdObject(this.context, (MdObjectDTO)fetchDataset);
        }
    }

    public DatasetDTO fetchDatasetAfterTableSwitch(String datasetName) throws IOException {
        File localDatasetFile = FileTools.findMetadataInDump(this.context, datasetName);
        MdObjectDumpDTO localDataset = FileTools.loadFileAsMdObjectDump(localDatasetFile);
        Long localVersion = new ETag(localDataset.getVersion()).getLongValue();
        MdObjectClient mdObjectClient = new MdObjectClient((CanRestClient)this.context.getCanRestClient());
        Long serverETag = mdObjectClient.headETagLongValue(this.context.getCurrentProject(), MdObjectDTO.Type.DATASET.toStringPlural(), localDataset.getContent().getId());
        Long serverVersion = new ETag(serverETag).getLongValue();
        if (serverVersion > localVersion) {
            MdDatasetClient datasetClient = (MdDatasetClient)this.context.getDatasetClient();
            return datasetClient.getDatasetByName(this.context.getCurrentProject(), datasetName);
        }
        throw new IOException("Dataset not updated after DWH table switch. Failed to fetch new version.");
    }

    public void loadData(File csvFile, String datasetName, DataPullRequest.Mode mode, ExecutionType executionType) throws IOException {
        DwhShellClient dwhShellClient = new DwhShellClient((CanRestClient)this.context.getCanRestClient());
        dwhShellClient.loadData(this.context, executionType, datasetName, mode, csvFile);
    }

    protected DataPullRequest.Mode convertDataPullRequestMode(String mode) throws IllegalArgumentException {
        try {
            return DataPullRequest.Mode.fromValue((String)mode);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid 'mode' parameter=" + mode + ". Supported values are=" + Arrays.toString(DataPullRequest.Mode.values()));
        }
    }

    protected File getCsvFile(String file) throws IllegalArgumentException {
        File csvFile = new FileSystemResource(file).getFile();
        if (csvFile == null || !csvFile.canRead()) {
            if (this.context.getCurrentDump() != null) {
                csvFile = Paths.get(this.context.getDumpPath().toString(), "data", file).toFile();
            }
            if (csvFile == null || !csvFile.canRead()) {
                throw new IllegalArgumentException("File " + file + " not found.");
            }
        }
        return csvFile;
    }
}

