/*
 * Decompiled with CFR 0.152.
 */
package com.cleveranalytics.shell.config;

import com.cleveranalytics.common.rest.client.CanRestClient;
import com.cleveranalytics.service.authn.client.UserCredentialsCanRestClient;
import com.cleveranalytics.service.md.client.MdDatasetClient;
import com.cleveranalytics.service.metadata.client.IDatasetClient;
import com.cleveranalytics.service.metadata.client.MetadataDatasetClient;
import com.cleveranalytics.service.project.client.ProjectClient;
import com.cleveranalytics.service.project.rest.dto.MetadataServiceType;
import com.cleveranalytics.service.project.rest.dto.ProjectServices;
import com.cleveranalytics.shell.client.AbstractShellClient;
import com.cleveranalytics.shell.client.MdShellClient;
import com.cleveranalytics.shell.client.MetadataShellClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.stereotype.Component;

@Component(value="shellContext")
public class ShellContext {
    private String loggedUser = null;
    private String userPassword = null;
    private String connectedServer = null;
    private String shellDirectory = null;
    private String currentDump = null;
    private String currentProject = null;
    private String projectTitle = null;
    private boolean exitOnError = false;
    private UserCredentialsCanRestClient canRestClient = null;

    public String getLoggedUser() {
        return this.loggedUser;
    }

    public String getLoggedUsername() {
        if (this.loggedUser.contains("@")) {
            return this.loggedUser.split("@")[0];
        }
        return this.loggedUser;
    }

    public void setLoggedUser(String loggedUser) {
        this.loggedUser = loggedUser;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getConnectedServer() {
        return this.connectedServer;
    }

    public String getConnectedServerRelativeUrl() {
        String connectedServerRelativeUrl = this.connectedServer;
        if (connectedServerRelativeUrl.contains("https")) {
            return connectedServerRelativeUrl.replace("https://", "");
        }
        return connectedServerRelativeUrl.replace("http://", "");
    }

    public void setConnectedServer(String connectedServer) {
        this.connectedServer = connectedServer;
    }

    public String getShellDirectory() {
        return this.shellDirectory;
    }

    public void setShellDirectory(String shellDirectory) {
        this.shellDirectory = shellDirectory;
    }

    public String getCurrentDump() {
        return this.currentDump;
    }

    public void setCurrentDump(String currentDump) {
        this.currentDump = currentDump;
    }

    public String getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(String currentProject) {
        this.currentProject = currentProject;
    }

    public String getProjectTitle() {
        return this.projectTitle;
    }

    public void setProjectTitle(String projectTitle) {
        this.projectTitle = projectTitle;
    }

    public boolean isExitOnError() {
        return this.exitOnError;
    }

    public void setExitOnError(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public AbstractShellClient getShellClient() {
        ProjectClient projectClient = new ProjectClient((CanRestClient)this.canRestClient);
        ProjectServices services = projectClient.getProject(this.currentProject).getServices();
        if (services.containsKey((Object)MetadataServiceType.MD.toString())) {
            return new MdShellClient((CanRestClient)this.canRestClient);
        }
        return new MetadataShellClient((CanRestClient)this.canRestClient);
    }

    public IDatasetClient getDatasetClient() {
        ProjectClient projectClient = new ProjectClient((CanRestClient)this.canRestClient);
        ProjectServices services = projectClient.getProject(this.currentProject).getServices();
        if (services.containsKey((Object)MetadataServiceType.MD.toString())) {
            return new MdDatasetClient((CanRestClient)this.canRestClient);
        }
        return new MetadataDatasetClient((CanRestClient)this.canRestClient);
    }

    public UserCredentialsCanRestClient getCanRestClient() {
        return this.canRestClient;
    }

    public void setCanRestClient(UserCredentialsCanRestClient canRestClient) {
        this.canRestClient = canRestClient;
    }

    public Path getProjectPath() {
        return Paths.get(this.getShellDirectory(), this.getCurrentProject());
    }

    public Path getDumpPath() {
        return Paths.get(this.getShellDirectory(), this.getCurrentProject(), this.getCurrentDump());
    }

    public Path getDataDumpPath() {
        return Paths.get(this.getShellDirectory(), this.getCurrentProject(), this.getCurrentDump(), "data");
    }

    public Path getMetadataDumpPath() {
        return Paths.get(this.getShellDirectory(), this.getCurrentProject(), this.getCurrentDump(), "metadata");
    }

    public File getDumpMetadataFile() throws FileNotFoundException {
        if (this.getShellDirectory() == null || this.getCurrentProject() == null || this.getCurrentDump() == null) {
            return null;
        }
        Path dumpMetadataFilePath = Paths.get(this.getShellDirectory(), this.getCurrentProject(), this.getCurrentDump(), "dumpMetadata.json");
        return dumpMetadataFilePath.toFile();
    }
}

